/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Mutation
implements ITreeMutation {
    int chance;
    boolean isSecret = false;
    IAllele allele0;
    IAllele allele1;
    IAllele[] template;
    private float minTemperature = 0.0f;
    private float maxTemperature = 2.0f;
    private float minRainfall = 0.0f;
    private float maxRainfall = 2.0f;

    public Mutation(IAllele allele0, IAllele allele1, IAllele[] template, int chance) {
        this.allele0 = allele0;
        this.allele1 = allele1;
        this.template = template;
        this.chance = chance;
        TreeManager.breedingManager.registerTreeMutation(this);
    }

    public Mutation setIsSecret() {
        this.isSecret = true;
        return this;
    }

    public Mutation setTemperature(float minTemperature, float maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        return this;
    }

    public Mutation setRainfall(float minRainfall, float maxRainfall) {
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        return this;
    }

    public Mutation setTemperatureRainfall(float minTemperature, float maxTemperature, float minRainfall, float maxRainfall) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        return this;
    }

    @Override
    public IAllele getAllele0() {
        return this.allele0;
    }

    @Override
    public IAllele getAllele1() {
        return this.allele1;
    }

    @Override
    public float getBaseChance() {
        return this.chance;
    }

    @Override
    public IAllele[] getTemplate() {
        return this.template;
    }

    @Override
    public boolean isPartner(IAllele allele) {
        return this.allele0.getUID().equals(allele.getUID()) || this.allele1.getUID().equals(allele.getUID());
    }

    @Override
    public IAllele getPartner(IAllele allele) {
        if (this.allele0.getUID().equals(allele.getUID())) {
            return this.allele1;
        }
        return this.allele0;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        float processedChance = this.chance;
        BiomeGenBase biome = world.func_72959_q().func_76935_a(x, z);
        if (biome.field_76750_F < this.minTemperature || biome.field_76750_F > this.maxTemperature) {
            return 0.0f;
        }
        if (biome.field_76751_G < this.minRainfall || biome.field_76751_G > this.maxRainfall) {
            return 0.0f;
        }
        processedChance *= TreeManager.breedingManager.getTreekeepingMode(world).getMutationModifier((ITreeGenome)genome0, (ITreeGenome)genome1, 1.0f);
        if (this.allele0.getUID().equals(allele0.getUID()) && this.allele1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.allele1.getUID().equals(allele0.getUID()) && this.allele0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }
}

