/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeInterface;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IIndividual;
import forestry.arboriculture.gadgets.BlockFruitPod;
import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Chromosome;
import forestry.core.utils.BlockUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeHelper
implements ITreeInterface {
    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.field_77993_c == ForestryItem.sapling.field_77779_bT;
    }

    @Override
    public boolean isPollen(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isPollinated(ItemStack itemstack) {
        return false;
    }

    @Override
    public ITree getTree(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileSapling)) {
            return null;
        }
        return ((TileSapling)tile).getTree();
    }

    @Override
    public ITree getTree(ItemStack itemstack) {
        if (!this.isGermling(itemstack)) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    public ITree getTree(World world, ITreeGenome genome) {
        return new Tree(genome);
    }

    @Override
    public ItemStack getGermlingStack(ITree tree, EnumGermlingType type) {
        Item germlingItem = null;
        switch (type) {
            case SAPLING: {
                germlingItem = ForestryItem.sapling;
                break;
            }
            default: {
                return null;
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound("tag");
        tree.writeToNBT(nbttagcompound);
        ItemStack treeStack = new ItemStack(germlingItem);
        treeStack.func_77982_d(nbttagcompound);
        return treeStack;
    }

    @Override
    public boolean plantSapling(World world, ITree tree, String owner, int x, int y, int z) {
        boolean placed = world.func_72832_d(x, y, z, ForestryBlock.saplingGE.field_71990_ca, 0, 2);
        if (!placed) {
            return false;
        }
        if (world.func_72798_a(x, y, z) != ForestryBlock.saplingGE.field_71990_ca) {
            return false;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileSapling)) {
            world.func_72832_d(x, y, z, 0, 0, 2);
            return false;
        }
        TileSapling sapling = (TileSapling)tile;
        sapling.setTree(tree.copy());
        sapling.setOwner(owner);
        world.func_72845_h(x, y, z);
        return true;
    }

    @Override
    public boolean setLeaves(World world, IIndividual tree, String owner, int x, int y, int z) {
        boolean placed = world.func_72832_d(x, y, z, ForestryBlock.leaves.field_71990_ca, 0, 2);
        if (!placed) {
            return false;
        }
        if (world.func_72798_a(x, y, z) != ForestryBlock.leaves.field_71990_ca) {
            return false;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileLeaves)) {
            world.func_72832_d(x, y, z, 0, 0, 2);
            return false;
        }
        TileLeaves leaves = (TileLeaves)tile;
        leaves.setTree((ITree)tree.copy());
        leaves.setOwner(owner);
        world.func_72845_h(x, y, z);
        return true;
    }

    @Override
    public boolean setFruitBlock(World world, IAlleleFruit allele, float sappiness, short[] indices, int x, int y, int z) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        boolean placed = world.func_72832_d(x, y, z, ForestryBlock.pods.field_71990_ca, direction, 2);
        if (!placed) {
            return false;
        }
        if (world.func_72798_a(x, y, z) != ForestryBlock.pods.field_71990_ca) {
            return false;
        }
        TileFruitPod pod = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (pod == null) {
            world.func_72832_d(x, y, z, 0, 0, 2);
            return false;
        }
        pod.setFruit(allele, sappiness, indices);
        world.func_72845_h(x, y, z);
        return true;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] template) {
        IChromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        IChromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] template) {
        return new TreeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new TreeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }
}

