/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.IIndividual;
import forestry.api.recipes.IVariableFermentable;
import forestry.arboriculture.genetics.BreedingManager;
import forestry.arboriculture.genetics.Tree;
import forestry.core.genetics.ItemGE;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Utils;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemGermlingGE
extends ItemGE
implements IVariableFermentable {
    private EnumGermlingType type;

    public ItemGermlingGE(int id, EnumGermlingType type) {
        super(id);
        this.type = type;
        this.func_77637_a(Tabs.tabArboriculture);
    }

    @Override
    protected IIndividual getIndividual(ItemStack itemstack) {
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 0;
    }

    public String func_77628_j(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return "Unknown";
        }
        Tree individual = new Tree(itemstack.func_77978_p());
        return individual.getDisplayName() + " " + this.type.getName();
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (ITree individual : BreedingManager.treeTemplates) {
            if (hideSecrets && individual.isSecret()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            ItemStack someStack = new ItemStack((Item)this);
            individual.writeToNBT(nbttagcompound);
            someStack.func_77982_d(nbttagcompound);
            itemList.add(someStack);
        }
    }

    @Override
    public int func_82790_a(ItemStack itemstack, int renderPass) {
        return 0xFFFFFF;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ItemStack itemstack, int renderPass) {
        ITree tree = TreeManager.treeInterface.getTree(itemstack);
        IAlleleTreeSpecies species = tree == null ? (IAlleleTreeSpecies)TreeManager.breedingManager.getDefaultTreeTemplate()[EnumTreeChromosome.SPECIES.ordinal()] : tree.getGenome().getPrimaryAsTree();
        return species.getGermlingIcon(this.type, renderPass);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int par7, float facingX, float facingY, float facingZ) {
        int yShift;
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        if (!Utils.isReplaceableBlock(world, x, y, z)) {
            if (!world.func_72799_c(x, y + 1, z)) {
                return false;
            }
            yShift = 1;
        } else {
            yShift = 0;
        }
        ITree tree = TreeManager.treeInterface.getTree(itemstack);
        if (!tree.canStay(world, x, y + yShift, z)) {
            return false;
        }
        if (TreeManager.treeInterface.plantSapling(world, tree, player.field_71092_bJ, x, y + yShift, z)) {
            Proxies.common.addBlockPlaceEffects(world, x, y, z, world.func_72798_a(x, y + yShift, z), 0);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @Override
    public float getFermentationModifier(ItemStack itemstack) {
        ITree tree = TreeManager.treeInterface.getTree(itemstack);
        if (tree == null) {
            return 1.0f;
        }
        return tree.getGenome().getSappiness() * 10.0f;
    }
}

