/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.arboriculture.gadgets.BlockLeaves;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.core.render.OverlayRenderingHandler;
import forestry.plugins.PluginForestryArboriculture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;

public class LeavesRenderingHandler
extends OverlayRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.func_78570_q(block, x, y, z);
        TileLeaves tile = BlockLeaves.getLeafTile(world, x, y, z);
        Icon fruitIcon = null;
        int fruitColor = 0xFFFFFF;
        if (tile != null) {
            fruitIcon = tile.getFruitTexture();
            fruitColor = tile.getFruitColour();
        }
        if (fruitIcon != null) {
            this.renderFruitOverlay(world, block, x, y, z, renderer, fruitIcon, fruitColor);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public int getRenderId() {
        return PluginForestryArboriculture.modelIdLeaves;
    }

    private boolean renderFruitOverlay(IBlockAccess world, Block block, int x, int y, int z, RenderBlocks renderer, Icon texture, int multiplier) {
        float mR = (float)(multiplier >> 16 & 0xFF) / 255.0f;
        float mG = (float)(multiplier >> 8 & 0xFF) / 255.0f;
        float mB = (float)(multiplier & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            mR = (mR * 30.0f + mG * 59.0f + mB * 11.0f) / 100.0f;
            mG = (mR * 30.0f + mG * 70.0f) / 100.0f;
            mB = (mR * 30.0f + mB * 70.0f) / 100.0f;
        }
        return this.renderFruitOverlayWithColorMultiplier(world, block, x, y, z, mR, mG, mB, renderer, texture);
    }

    private boolean renderFruitOverlayWithColorMultiplier(IBlockAccess world, Block block, int x, int y, int z, float r, float g, float b, RenderBlocks renderer, Icon texture) {
        int mixedBrightness = block.func_71874_e(world, x, y, z);
        float adjR = 0.5f * r;
        float adjG = 0.5f * g;
        float adjB = 0.5f * b;
        this.renderBottomFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderTopFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderEastFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderWestFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderNorthFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        this.renderSouthFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        return true;
    }
}

