/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.TreeManager;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.BlockTypeLeaf;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public abstract class WorldGenTree
extends WorldGenArboriculture {
    protected int girth;
    protected int height;
    protected int minHeight = 4;
    protected int maxHeight = 80;

    public WorldGenTree(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(leafSpawn--, 0.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, 0.5f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
    }

    protected WorldGenBase.Vector getCenteredAt(int yCenter, int offset) {
        float cent = this.girth % 2 == 0 ? 0.5f : 0.0f;
        return new WorldGenBase.Vector(cent + (float)offset, yCenter, cent + (float)offset);
    }

    protected void generateAdjustedCylinder(int yCenter, float radius, int height, BlockType block) {
        this.generateAdjustedCylinder(yCenter, 0, radius, height, block, WorldGenBase.EnumReplaceMode.NONE);
    }

    protected void generateAdjustedCylinder(int yCenter, float radius, int height, BlockType block, WorldGenBase.EnumReplaceMode replace) {
        this.generateAdjustedCylinder(yCenter, 0, radius, height, block, replace);
    }

    protected void generateAdjustedCylinder(int yCenter, int offset, float radius, int height, BlockType block, WorldGenBase.EnumReplaceMode replace) {
        this.generateCylinder(this.getCenteredAt(yCenter, offset), radius + (float)this.girth, height, block, replace);
    }

    @Override
    public boolean canGrow() {
        return this.tree.canGrow(this.world, this.startX, this.startY, this.startZ, this.tree.getGirth(this.world, this.startX, this.startY, this.startZ), this.height);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(5, 2);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    protected int determineGirth(int base) {
        return base;
    }

    protected int modifyByHeight(int val, int min, int max) {
        int determined = Math.round((float)val * this.tree.getHeightModifier() * TreeManager.breedingManager.getTreekeepingMode(this.world).getHeightModifier(null, 1.0f));
        return determined < min ? min : (determined > max ? max : determined);
    }

    protected int determineHeight(int required, int variation) {
        int determined = Math.round((float)(required + this.rand.nextInt(variation)) * this.tree.getHeightModifier() * TreeManager.breedingManager.getTreekeepingMode(this.world).getHeightModifier(null, 1.0f));
        return determined < this.minHeight ? this.minHeight : (determined > this.maxHeight ? this.maxHeight : determined);
    }

    @Override
    public BlockType getLeaf(String owner) {
        return new BlockTypeLeaf(owner);
    }

    @Override
    public abstract BlockType getWood();
}

