/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.EnumErrorCode;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.render.TextureManager;
import forestry.core.utils.LiquidHelper;
import forestry.plugins.PluginManager;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;

public class EventHandlerCore {
    @ForgeSubscribe
    public void handleItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        for (IPickupHandler handler : PluginManager.pickupHandlers) {
            if (handler.onItemPickup(event.entityPlayer, event.item)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    @ForgeSubscribe
    public void handleOreRegistration(OreDictionary.OreRegisterEvent event) {
        if (event.isCanceled()) {
            return;
        }
        for (IOreDictionaryHandler handler : PluginManager.dictionaryHandlers) {
            handler.onOreRegistration(event.Name, event.Ore);
        }
    }

    @ForgeSubscribe
    public void handleWorldLoad(WorldEvent.Load event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldLoad(event.world);
        }
    }

    @ForgeSubscribe
    public void handleWorldSave(WorldEvent.Save event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldSave(event.world);
        }
    }

    @ForgeSubscribe
    public void handleWorldUnload(WorldEvent.Unload event) {
        for (ISaveEventHandler handler : PluginManager.saveEventHandlers) {
            handler.onWorldUnload(event.world);
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        EnumErrorCode.initIcons();
        TextureManager.getInstance().initDefaultIcons();
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void handleTexturePostmap(TextureStitchEvent.Post event) {
        LiquidHelper.resetLiquidIcons();
    }
}

