/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.interfaces.IGameMode;
import java.util.HashMap;
import net.minecraft.item.ItemStack;

public class GameMode
implements IGameMode {
    private static IGameMode activeMode;
    private String identifier = "EASY";
    private String category;
    private HashMap booleanSettings = new HashMap();
    private HashMap integerSettings = new HashMap();
    private HashMap floatSettings = new HashMap();
    private static final float ENERGY_DEMAND_MODIFIER = 1.0f;
    private int fertilizerFarmValue = 2000;
    private ItemStack recipeFertilizerOutputApatite = new ItemStack(ForestryItem.fertilizerCompound, 8);
    private ItemStack recipeFertilizerOutputAsh = new ItemStack(ForestryItem.fertilizerCompound, 16);
    private ItemStack recipeCompostOutputWheat = new ItemStack(ForestryItem.fertilizerBio, 4);
    private ItemStack recipeCompostOutputAsh = new ItemStack(ForestryItem.fertilizerBio, 1);
    private ItemStack recipeHumusOutputFertilizer = new ItemStack(ForestryBlock.soil, 8, 0);
    private ItemStack recipeHumusOutputCompost = new ItemStack(ForestryBlock.soil, 8, 0);
    private ItemStack recipeBogEarthOutputBucket = new ItemStack(ForestryBlock.soil, 6, 1);
    private ItemStack recipeBogEarthOutputCans = new ItemStack(ForestryBlock.soil, 8, 1);
    private ItemStack recipeCanOutput = new ItemStack(ForestryItem.canEmpty, 12);
    private ItemStack recipeCapsuleOutput = new ItemStack(ForestryItem.waxCapsule, 4);
    private ItemStack recipeRefractoryOutput = new ItemStack(ForestryItem.refractoryEmpty, 4);
    private static final int FERMENTATION_DURATION_FERTILIZER = 200;
    private static final int FERMENTATION_DURATION_COMPOST = 250;
    private static final int FERMENTED_CYCLE_FERTILIZER = 56;
    private static final int FERMENTED_CYCLE_COMPOST = 48;
    private static final int FERMENTED_SAPLING = 250;
    private static final int FERMENTED_CACTI = 50;
    private static final int FERMENTED_WHEAT = 50;
    private static final int FERMENTED_CANE = 50;
    private static final int FERMENTED_MUSHROOM = 50;
    private static final int SQUEEZED_LIQUID_SEED = 10;
    private static final int SQUEEZED_LIQUID_APPLE = 200;
    private static final int SQUEEZED_MULCH_APPLE = 20;

    public static IGameMode getGameMode() {
        if (activeMode == null) {
            activeMode = new GameMode(Config.gameMode);
        }
        return activeMode;
    }

    public GameMode(String identifier) {
        this.identifier = identifier;
        this.category = "gamemodes/" + identifier;
        Configuration config = Config.config;
        this.initSetting("energy.demand.modifier", 1.0f, -1.0f, "modifies the energy required to activate machines, as well as the max amount of energy stored and accepted.");
        Property property = config.get("farms.fertilizer.value", this.category, this.fertilizerFarmValue);
        property.Comment = "modifies the time fertilizer lasts in a farm.";
        this.fertilizerFarmValue = Integer.parseInt(property.Value);
        property = config.get("recipe.output.fertilizer.apatite", this.category, this.recipeFertilizerOutputApatite.field_77994_a);
        property.Comment = "amount of fertilizer yielded by the recipe using apatite.";
        this.recipeFertilizerOutputApatite = new ItemStack(this.recipeFertilizerOutputApatite.field_77993_c, Integer.parseInt(property.Value), this.recipeFertilizerOutputApatite.func_77960_j());
        property = config.get("recipe.output.fertilizer.ash", this.category, this.recipeFertilizerOutputAsh.field_77994_a);
        property.Comment = "amount of fertilizer yielded by the recipe using ash.";
        this.recipeFertilizerOutputAsh = new ItemStack(this.recipeFertilizerOutputAsh.field_77993_c, Integer.parseInt(property.Value), this.recipeFertilizerOutputAsh.func_77960_j());
        property = config.get("recipe.output.compost.wheat", this.category, this.recipeCompostOutputWheat.field_77994_a);
        property.Comment = "amount of compost yielded by the recipe using wheat.";
        this.recipeCompostOutputWheat = new ItemStack(this.recipeCompostOutputWheat.field_77993_c, Integer.parseInt(property.Value), this.recipeCompostOutputWheat.func_77960_j());
        property = config.get("recipe.output.compost.ash", this.category, this.recipeCompostOutputAsh.field_77994_a);
        property.Comment = "amount of compost yielded by the recipe using ash.";
        this.recipeCompostOutputAsh = new ItemStack(this.recipeCompostOutputAsh.field_77993_c, Integer.parseInt(property.Value), this.recipeCompostOutputAsh.func_77960_j());
        property = config.get("recipe.output.humus.fertilizer", this.category, this.recipeHumusOutputFertilizer.field_77994_a);
        property.Comment = "amount of humus yielded by the recipe using fertilizer.";
        this.recipeHumusOutputFertilizer = new ItemStack(this.recipeHumusOutputFertilizer.field_77993_c, Integer.parseInt(property.Value), this.recipeHumusOutputFertilizer.func_77960_j());
        property = config.get("recipe.output.humus.compost", this.category, this.recipeHumusOutputCompost.field_77994_a);
        property.Comment = "amount of humus yielded by the recipe using compost.";
        this.recipeHumusOutputCompost = new ItemStack(this.recipeHumusOutputCompost.field_77993_c, Integer.parseInt(property.Value), this.recipeHumusOutputCompost.func_77960_j());
        property = config.get("recipe.output.bogearth.bucket", this.category, this.recipeBogEarthOutputBucket.field_77994_a);
        property.Comment = "amount of bog earth yielded by the recipe using buckets.";
        this.recipeBogEarthOutputBucket = new ItemStack(this.recipeBogEarthOutputBucket.field_77993_c, Integer.parseInt(property.Value), this.recipeBogEarthOutputBucket.func_77960_j());
        property = config.get("recipe.output.bogearth.can", this.category, this.recipeBogEarthOutputCans.field_77994_a);
        property.Comment = "amount of bog earth yielded by the recipes using cans, cells or capsules.";
        this.recipeBogEarthOutputCans = new ItemStack(this.recipeBogEarthOutputCans.field_77993_c, Integer.parseInt(property.Value), this.recipeBogEarthOutputCans.func_77960_j());
        property = config.get("recipe.output.can", this.category, this.recipeCanOutput.field_77994_a);
        property.Comment = "amount yielded by the recipe for tin cans.";
        this.recipeCanOutput = new ItemStack(this.recipeCanOutput.field_77993_c, Integer.parseInt(property.Value), this.recipeCanOutput.func_77960_j());
        property = config.get("recipe.output.capsule", this.category, this.recipeCapsuleOutput.field_77994_a);
        property.Comment = "amount yielded by the recipe for wax capsules.";
        this.recipeCapsuleOutput = new ItemStack(this.recipeCapsuleOutput.field_77993_c, Integer.parseInt(property.Value), this.recipeCapsuleOutput.func_77960_j());
        property = config.get("recipe.output.refractory", this.category, this.recipeRefractoryOutput.field_77994_a);
        property.Comment = "amount yielded by the recipe for refractory capsules.";
        this.recipeRefractoryOutput = new ItemStack(this.recipeRefractoryOutput.field_77993_c, Integer.parseInt(property.Value), this.recipeRefractoryOutput.func_77960_j());
        this.initSetting("fermenter.cycles.fertilizer", 200, -1, "modifies the amount of cycles fertilizer can keep a fermenter going.");
        this.initSetting("fermenter.cycles.compost", 250, -1, "modifies the amount of cycles compost can keep a fermenter going.");
        this.initSetting("fermenter.value.fertilizer", 56, -1, "modifies the amount of biomass per cycle a fermenter will produce using fertilizer.");
        this.initSetting("fermenter.value.compost", 48, -1, "modifies the amount of biomass per cycle a fermenter will produce using compost.");
        this.initSetting("fermenter.yield.sapling", 250, 2000, "modifies the base amount of biomass a sapling will yield in a fermenter, affected by sappiness trait.");
        this.initSetting("fermenter.yield.cactus", 50, 400, "modifies the amount of biomass a piece of cactus will yield in a fermenter.");
        this.initSetting("fermenter.yield.wheat", 50, 400, "modifies the amount of biomass a piece of wheat will yield in a fermenter.");
        this.initSetting("fermenter.yield.cane", 50, 400, "modifies the amount of biomass a piece of sugar cane will yield in a fermenter.");
        this.initSetting("fermenter.yield.mushroom", 50, 400, "modifies the amount of biomass a mushroom will yield in a fermenter.");
        this.initSetting("squeezer.liquid.seed", 10, 80, "modifies the amount of seed oil squeezed from a single seed. other sources are based off this.");
        this.initSetting("squeezer.liquid.apple", 200, 1600, "modifies the amount of juice squeezed from a single apple. other sources are based off this.");
        this.initSetting("squeezer.mulch.apple", 20, 160, "modifies the chance of mulch per squeezed apple.");
        this.initSetting("energy.engine.clockwork", true, "set to false to disable the clockwork engine.");
        config.save();
    }

    private void initSetting(String ident, int def, int max, String comment) {
        Property property = Config.config.get(ident, this.category, def);
        if (max < 0) {
            property.Comment = comment;
            this.integerSettings.put(ident, Integer.parseInt(property.Value));
        } else {
            property.Comment = comment + " (max: " + max + ")";
            this.integerSettings.put(ident, Math.min(Integer.parseInt(property.Value), max));
        }
        Config.config.set(ident, this.category, (Integer)this.integerSettings.get(ident));
    }

    private void initSetting(String ident, float def, float max, String comment) {
        Property property = Config.config.get(ident, this.category, def);
        if (max < 0.0f) {
            property.Comment = comment;
            this.floatSettings.put(ident, Float.valueOf(Float.parseFloat(property.Value)));
        } else {
            property.Comment = comment + " (max: " + max + ")";
            this.floatSettings.put(ident, Float.valueOf(Math.min(Float.parseFloat(property.Value), max)));
        }
        Config.config.set(ident, this.category, ((Float)this.floatSettings.get(ident)).floatValue());
    }

    private void initSetting(String ident, boolean def, String comment) {
        Property property = Config.config.get(ident, this.category, def);
        property.Comment = comment;
        this.booleanSettings.put(ident, Boolean.parseBoolean(property.Value));
        Config.config.set(ident, this.category, (Boolean)this.booleanSettings.get(ident));
    }

    @Override
    public int getIntegerSetting(String ident) {
        if (this.integerSettings.containsKey(ident)) {
            return (Integer)this.integerSettings.get(ident);
        }
        throw new IllegalArgumentException("No such setting: " + ident);
    }

    @Override
    public float getFloatSetting(String ident) {
        if (this.floatSettings.containsKey(ident)) {
            return ((Float)this.floatSettings.get(ident)).floatValue();
        }
        throw new IllegalArgumentException("No such setting: " + ident);
    }

    @Override
    public boolean getBooleanSetting(String ident) {
        if (this.booleanSettings.containsKey(ident)) {
            return (Boolean)this.booleanSettings.get(ident);
        }
        throw new IllegalArgumentException("No such setting: " + ident);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getFertilizerFarmValue() {
        return this.fertilizerFarmValue;
    }

    @Override
    public ItemStack getRecipeFertilizerOutputApatite() {
        return this.recipeFertilizerOutputApatite;
    }

    @Override
    public ItemStack getRecipeFertilizerOutputAsh() {
        return this.recipeFertilizerOutputAsh;
    }

    @Override
    public ItemStack getRecipeCompostOutputWheat() {
        return this.recipeCompostOutputWheat;
    }

    @Override
    public ItemStack getRecipeCompostOutputAsh() {
        return this.recipeCompostOutputAsh;
    }

    @Override
    public ItemStack getRecipeHumusOutputFertilizer() {
        return this.recipeHumusOutputFertilizer;
    }

    @Override
    public ItemStack getRecipeHumusOutputCompost() {
        return this.recipeHumusOutputCompost;
    }

    @Override
    public ItemStack getRecipeBogEarthOutputBucket() {
        return this.recipeBogEarthOutputBucket;
    }

    @Override
    public ItemStack getRecipeBogEarthOutputCans() {
        return this.recipeBogEarthOutputCans;
    }

    @Override
    public ItemStack getRecipeCanOutput() {
        return this.recipeCanOutput;
    }

    @Override
    public ItemStack getRecipeCapsuleOutput() {
        return this.recipeCapsuleOutput;
    }

    @Override
    public ItemStack getRecipeRefractoryOutput() {
        return this.recipeRefractoryOutput;
    }
}

