/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import forestry.core.config.Config;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.player.EntityPlayer;

public class TickHandlerCoreClient
implements ITickHandler,
Runnable {
    private static ConcurrentLinkedQueue messages = new ConcurrentLinkedQueue();
    private boolean nagged;

    public void queueChatMessage(String message) {
        messages.add(message);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        if (messages.size() > 0) {
            String message;
            EntityPlayer player = (EntityPlayer)tickData[0];
            while ((message = (String)messages.poll()) != null) {
                player.func_70006_a(message);
            }
        }
        if (this.nagged) {
            return;
        }
        if (!Config.disableNags && Proxies.common.isModLoaded("GregTech_Addon")) {
            this.queueChatMessage("\u00a76Forestry may have been modified by GregTech. It may behave unexpectedly and some config options may not work. Do not report issues with this install! You can disable this nag in the config.");
        }
        if (!Config.disableVersionCheck) {
            new Thread(new TickHandlerCoreClient()).start();
        }
        if (Config.invalidFingerprint) {
            this.queueChatMessage("\u00a76Forestry's jar file was tampered with. Some machines have shut down and beekeeping has grown dangerous. Get a new jar from the official download page to fix that!");
        }
        this.nagged = true;
    }

    @Override
    public void run() {
        if (Version.needsUpdateNoticeAndMarkAsSeen()) {
            this.queueChatMessage(String.format("\u00a7cNew version of Forestry available: %s for Minecraft %s", Version.getRecommendedVersion(), Proxies.common.getMinecraftVersion()));
            this.queueChatMessage("\u00a7cThis message only displays once. Type '/forestry version' to see the changelog.");
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "Forestry - Player update tick";
    }
}

