/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitLibrary;
import forestry.api.circuits.ICircuitRegistry;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.CircuitLibrary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class CircuitRegistry
implements ICircuitRegistry {
    private LinkedHashMap layoutMap = new LinkedHashMap();
    private LinkedHashMap circuitMap = new LinkedHashMap();
    private HashMap legacyMap = new HashMap();

    @Override
    public ICircuitLibrary getCircuitLibrary(World world, String playername) {
        CircuitLibrary library = (CircuitLibrary)world.func_72943_a(CircuitLibrary.class, "CircuitLibrary_" + playername);
        if (library == null) {
            library = new CircuitLibrary(playername);
            world.func_72823_a("CircuitLibrary_" + playername, (WorldSavedData)library);
        }
        return library;
    }

    @Override
    public ICircuitLayout getDefaultLayout() {
        if (this.layoutMap.containsKey("forestry.engine.tin")) {
            return (ICircuitLayout)this.layoutMap.get("forestry.engine.tin");
        }
        return (ICircuitLayout)this.layoutMap.values().iterator().next();
    }

    @Override
    public LinkedHashMap getRegisteredLayouts() {
        return this.layoutMap;
    }

    @Override
    public void registerLayout(ICircuitLayout layout) {
        this.layoutMap.put(layout.getUID(), layout);
    }

    @Override
    public ICircuitLayout getLayout(String uid) {
        if (this.layoutMap.containsKey(uid)) {
            return (ICircuitLayout)this.layoutMap.get(uid);
        }
        return null;
    }

    @Override
    public HashMap getRegisteredCircuits() {
        return this.circuitMap;
    }

    @Override
    public void registerCircuit(ICircuit circuit) {
        this.circuitMap.put(circuit.getUID(), circuit);
    }

    @Override
    public ICircuit getCircuit(String uid) {
        return (ICircuit)this.circuitMap.get(uid);
    }

    @Override
    public void registerLegacyMapping(int id, String uid) {
        this.legacyMap.put(id, uid);
    }

    @Override
    public ICircuit getFromLegacyMap(int id) {
        if (!this.legacyMap.containsKey(id)) {
            return null;
        }
        return this.getCircuit((String)this.legacyMap.get(id));
    }

    public void initialize() {
        this.registerLayout(new CircuitLayout("engine.tin"));
    }
}

