/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.SlotCustom;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ContainerSolderingIron
extends ContainerItemInventory
implements IGuiSelectable {
    ItemSolderingIron.SolderingInventory inventory;

    public ContainerSolderingIron(InventoryPlayer inventoryplayer, ItemSolderingIron.SolderingInventory inventory) {
        super(inventory);
        this.inventory = inventory;
        this.addSlot(new SlotCustom((IInventory)inventory, new Object[]{ItemCircuitBoard.class}, 0, 152, 12));
        this.addSlot(new SlotCustom((IInventory)inventory, new Object[]{ItemCircuitBoard.class}, 1, 152, 92));
        this.addSlot(new Slot((IInventory)inventory, 2, 12, 32));
        this.addSlot(new Slot((IInventory)inventory, 3, 12, 52));
        this.addSlot(new Slot((IInventory)inventory, 4, 12, 72));
        this.addSlot(new Slot((IInventory)inventory, 5, 12, 92));
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int l1 = 0; l1 < 9; ++l1) {
                this.addSecuredSlot((IInventory)inventoryplayer, l1 + i1 * 9 + 9, 8 + l1 * 18, 123 + i1 * 18);
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.addSecuredSlot((IInventory)inventoryplayer, j1, 8 + j1 * 18, 181);
        }
    }

    @Override
    protected boolean isAcceptedItem(EntityPlayer player, ItemStack stack) {
        return false;
    }

    public ICircuitLayout getLayout() {
        return this.inventory.getLayout();
    }

    public void advanceSelection(int index, World world) {
        PacketPayload payload = new PacketPayload(2, 0, 0);
        payload.intPayload[0] = index;
        payload.intPayload[1] = 0;
        this.sendSelectionChange(payload);
    }

    public void regressSelection(int index, World world) {
        PacketPayload payload = new PacketPayload(2, 0, 0);
        payload.intPayload[0] = index;
        payload.intPayload[1] = 1;
        this.sendSelectionChange(payload);
    }

    private void sendSelectionChange(PacketPayload payload) {
        PacketUpdate packet = new PacketUpdate(30, payload);
        Proxies.net.sendToServer(packet);
    }

    @Override
    public void setSelection(PacketUpdate packet) {
        this.inventory.setLayout(packet.payload.stringPayload[0]);
    }

    @Override
    public void handleSelectionChange(EntityPlayer player, PacketUpdate packet) {
        if (packet.payload.intPayload[1] == 0) {
            if (packet.payload.intPayload[0] == 0) {
                this.inventory.advanceLayout();
            }
        } else if (packet.payload.intPayload[0] == 0) {
            this.inventory.regressLayout();
        }
        this.sendSelection(player);
    }

    public void sendSelection(EntityPlayer player) {
        PacketPayload payload = new PacketPayload(0, 0, 1);
        payload.stringPayload[0] = this.inventory.getLayout().getUID();
        Proxies.net.sendToPlayer(new PacketUpdate(32, payload), player);
    }
}

