/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.CircuitBoard;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.config.ForestryItem;
import forestry.core.items.ItemForestry;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ItemCircuitBoard
extends ItemForestry {
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public ItemCircuitBoard(int i) {
        super(i);
        this.func_77627_a(true);
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.BASIC, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.ENHANCED, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]));
        itemList.add(ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.INTRICATE, null, new ICircuit[0]));
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.icons = new Icon[2];
        this.icons[0] = TextureManager.getInstance().registerItemTex(this.func_77658_a().replace("item.", "") + ".0");
        this.icons[1] = TextureManager.getInstance().registerItemTex(this.func_77658_a().replace("item.", "") + ".1");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int i, int j) {
        if (j > 0) {
            return this.icons[0];
        }
        return this.icons[1];
    }

    public boolean func_77623_v() {
        return true;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[itemstack.func_77960_j()];
        if (j == 0) {
            return type.primaryColor;
        }
        return type.secondaryColor;
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        EnumCircuitBoardType type = EnumCircuitBoardType.values()[itemstack.func_77960_j()];
        return StringUtil.localize("item.circuitboard." + type.toString().toLowerCase(Locale.ENGLISH));
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        ICircuitBoard circuitboard = ItemCircuitBoard.getCircuitboard(itemstack);
        if (circuitboard != null) {
            circuitboard.addTooltip(list);
        }
    }

    public static boolean isChipset(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.field_77993_c == ForestryItem.circuitboards.field_77779_bT;
    }

    public static ItemStack createCircuitboard(EnumCircuitBoardType type, ICircuitLayout layout, ICircuit[] circuits) {
        ItemStack chipset = new ItemStack(ForestryItem.circuitboards, 1, type.ordinal());
        ItemCircuitBoard.saveChipset(chipset, new CircuitBoard(type, layout, circuits));
        return chipset;
    }

    public static void saveChipset(ItemStack itemstack, ICircuitBoard circuitboard) {
        if (circuitboard == null) {
            itemstack.func_77982_d(null);
            return;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        circuitboard.writeToNBT(nbttagcompound);
        itemstack.func_77982_d(nbttagcompound);
    }

    public static ICircuitBoard getCircuitboard(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        if (nbttagcompound == null) {
            return null;
        }
        return new CircuitBoard(nbttagcompound);
    }
}

