/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.core.config.Config;
import forestry.core.config.Property;
import forestry.core.proxy.Proxies;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class Version {
    public static final String VERSION = "2.2.2.2";
    public static final String BUILD_NUMBER = "511";
    public static final String FINGERPRINT = "862700d0712182f612efd419ad296f9ed482ec1d";
    public static final String FORGEPRINT = "de4cf8a3f3bc15635810044c39240bf96804ea7d";
    private static final String REMOTE_VERSION_FILE = "http://bit.ly/forestryver";
    private static final String REMOTE_CHANGELOG_ROOT = "https://dl.dropbox.com/u/44760587/forestry/changelog/";
    private static final String REMOTE_FINGERPRINT_ROOT = new String(new byte[]{104, 116, 116, 112, 115, 58, 47, 47, 100, 108, 46, 100, 114, 111, 112, 98, 111, 120, 46, 99, 111, 109, 47, 117, 47, 52, 52, 55, 54, 48, 53, 56, 55, 47, 102, 111, 114, 101, 115, 116, 114, 121, 47, 102, 105, 110, 103, 101, 114, 112, 114, 105, 110, 116, 115, 47});
    public static EnumUpdateState currentVersion = EnumUpdateState.CURRENT;
    public static final String FORGE_VERSION = "@FORGE_VERSION@";
    public static String remoteFingerprint;
    public static String remoteForgeprint;
    private static String recommendedVersion;
    private static String[] cachedChangelog;

    public static String getVersion() {
        return "2.2.2.2 (511)";
    }

    public static boolean isOutdated() {
        return currentVersion == EnumUpdateState.OUTDATED;
    }

    public static boolean needsUpdateNoticeAndMarkAsSeen() {
        if (!Version.isOutdated()) {
            return false;
        }
        Property property = Config.config.get("vars.version.seen", "common", VERSION);
        property.Comment = "indicates the last version the user has been informed about and will suppress further notices on it.";
        String seenVersion = property.Value;
        if (recommendedVersion == null || recommendedVersion.equals(seenVersion)) {
            return false;
        }
        property.Value = recommendedVersion;
        Config.config.save();
        return true;
    }

    public static String getRecommendedVersion() {
        return recommendedVersion;
    }

    public static void updateRemoteFingerprints() {
        remoteFingerprint = Version.retrieveRemoteString(REMOTE_FINGERPRINT_ROOT + new String(new byte[]{102, 111, 114, 101, 115, 116, 114, 121, 46, 107, 101, 121}) + "1", FINGERPRINT);
        remoteFingerprint = Version.retrieveRemoteString(REMOTE_FINGERPRINT_ROOT + new String(new byte[]{102, 111, 114, 103, 101, 46, 107, 101, 121}) + "1", FORGEPRINT);
    }

    public static String retrieveRemoteString(String location, String defaultValue) {
        try {
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            line = reader.readLine();
            if (line != null) {
                return line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Proxies.log.warning("Unable to read from remote fingerprint authority.");
        }
        return defaultValue;
    }

    public static void versionCheck() {
        try {
            String location = REMOTE_VERSION_FILE;
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            String mcVersion = Proxies.common.getMinecraftVersion();
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(mcVersion) || !line.contains("Forestry")) continue;
                String[] tokens = line.split(":");
                recommendedVersion = tokens[2];
                if (!line.endsWith(VERSION)) continue;
                Proxies.log.finer("Using the latest version [2.2.2.2 (build:511)] for Minecraft " + mcVersion);
                currentVersion = EnumUpdateState.CURRENT;
                return;
            }
            Proxies.log.warning("Using outdated version [2.2.2.2 (build:511)] for Minecraft " + mcVersion + ". Consider updating.");
            currentVersion = EnumUpdateState.OUTDATED;
        }
        catch (Exception e) {
            e.printStackTrace();
            Proxies.log.warning("Unable to read from remote version authority.");
            currentVersion = EnumUpdateState.CONNECTION_ERROR;
        }
    }

    public static String[] getChangelog() {
        if (cachedChangelog == null) {
            cachedChangelog = Version.grabChangelog(recommendedVersion);
        }
        return cachedChangelog;
    }

    public static String[] grabChangelog(String version) {
        try {
            String location = REMOTE_CHANGELOG_ROOT + version;
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            ArrayList<String> changelog = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                changelog.add(line);
            }
            return changelog.toArray(new String[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Proxies.log.warning("Unable to read changelog from remote site.");
            return new String[]{String.format("Unable to retrieve changelog for %s %s", "Forestry", version)};
        }
    }

    public static enum EnumUpdateState {
        CURRENT,
        OUTDATED,
        CONNECTION_ERROR;

    }
}

