/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineAnalyzer
extends TileBase
implements ISpecialInventory,
ISidedInventory,
ILiquidTankContainer {
    public static final int TIME_TO_ANALYZE = 500;
    public static final int HONEY_REQUIRED = 100;
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_OUTPUT_1 = 8;
    private InventoryAdapter inventory = new InventoryAdapter(12, "Items").configureSidedDown(8, 4).configureSidedUp(1, 1).configureSidedSides(2, 6);
    private int analyzeTime;
    private short analyzeSlot = 0;
    private short canSlot = 1;
    private short inputSlot1 = (short)2;
    private short outputSlot1 = (short)8;
    public LiquidStack resource = new LiquidStack(ForestryItem.liquidHoney, 100);
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private Stack pendingProducts = new Stack();

    @Override
    public String func_70303_b() {
        return StringUtil.localize("core.0");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.AnalyzerGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("AnalyzeTime", this.analyzeTime);
        this.resourceTank.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] pending = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < pending.length; ++i) {
            if (pending[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            pending[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.analyzeTime = nbttagcompound.func_74762_e("AnalyzeTime");
        this.resourceTank.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("PendingProducts");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            this.pendingProducts.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.tryAddPending()) {
            return;
        }
        if (!this.pendingProducts.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
            return;
        }
        if (this.func_70301_a(this.canSlot) != null && (container = LiquidHelper.getLiquidContainer(this.func_70301_a(this.canSlot))) != null && this.resource.isLiquidEqual(container.stillLiquid)) {
            this.func_70299_a(this.canSlot, StackUtils.replenishByContainer(this, this.func_70301_a(this.canSlot), container, this.resourceTank));
            if (this.func_70301_a((int)this.canSlot).field_77994_a <= 0) {
                this.func_70299_a(this.canSlot, null);
            }
        }
        if (this.analyzeTime > 0 && this.func_70301_a(this.analyzeSlot) != null && AlleleManager.alleleRegistry.isIndividual(this.func_70301_a(this.analyzeSlot))) {
            --this.analyzeTime;
            if (this.analyzeTime > 0) {
                this.setErrorState(EnumErrorCode.OK);
                return;
            }
            IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.func_70301_a(this.analyzeSlot));
            if (individual == null) {
                return;
            }
            individual.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            individual.writeToNBT(nbttagcompound);
            this.func_70301_a(this.analyzeSlot).func_77982_d(nbttagcompound);
            this.pendingProducts.push(this.func_70301_a(this.analyzeSlot));
            this.func_70299_a(this.analyzeSlot, null);
        } else {
            this.analyzeTime = 0;
            if (this.func_70301_a(this.analyzeSlot) != null) {
                return;
            }
            if (this.resourceTank.quantity < this.resource.amount) {
                this.setErrorState(EnumErrorCode.NORESOURCE);
                return;
            }
            for (int i = this.inputSlot1; i < this.outputSlot1; ++i) {
                if (this.func_70301_a(i) == null || !AlleleManager.alleleRegistry.isIndividual(this.func_70301_a(i))) continue;
                IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.func_70301_a(i));
                if (individual.isAnalyzed()) {
                    this.pendingProducts.push(this.func_70301_a(i));
                    this.func_70299_a(i, null);
                    continue;
                }
                this.func_70299_a(this.analyzeSlot, this.func_70301_a(i));
                this.func_70299_a(i, null);
                this.resourceTank.drain(this.resource.amount, true);
                this.analyzeTime = 500;
                return;
            }
            this.setErrorState(EnumErrorCode.NOTHINGANALYZE);
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = (ItemStack)this.pendingProducts.peek();
        if (this.inventory.tryAddStack(next, this.outputSlot1, this.inventory.func_70302_i_() - this.outputSlot1, true)) {
            this.pendingProducts.pop();
            return true;
        }
        return false;
    }

    public boolean isWorking() {
        return this.analyzeTime > 0;
    }

    public int getProgressScaled(int i) {
        return this.analyzeTime * i / 500;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public ItemStack getBeeOnDisplay() {
        if (this.func_70301_a(this.analyzeSlot) != null) {
            return this.func_70301_a(this.analyzeSlot);
        }
        return null;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.analyzeTime = j;
                break;
            }
            case 1: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 2: {
                this.resourceTank.quantity = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.analyzeTime);
        iCrafting.func_71112_a(container, 1, this.resourceTank.liquidId);
        iCrafting.func_71112_a(container, 2, this.resourceTank.quantity);
    }

    @Override
    protected InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack product = null;
        for (int i = this.outputSlot1; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            product = this.func_70301_a(i).func_77946_l();
            if (!doRemove) break;
            this.func_70301_a((int)i).field_77994_a = 0;
            this.func_70299_a(i, null);
            break;
        }
        return new ItemStack[]{product};
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (!AlleleManager.alleleRegistry.isIndividual(stack)) {
            LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
            if (container == null || !container.stillLiquid.isLiquidEqual(this.resource)) {
                return 0;
            }
            if (this.func_70301_a(this.canSlot) == null) {
                if (doAdd) {
                    this.func_70299_a(this.canSlot, stack.func_77946_l());
                }
                return stack.field_77994_a;
            }
            int space = this.func_70301_a(this.canSlot).func_77976_d() - this.func_70301_a((int)this.canSlot).field_77994_a;
            if (space <= 0) {
                return 0;
            }
            if (doAdd) {
                this.func_70301_a((int)this.canSlot).field_77994_a += stack.field_77994_a;
                if (this.func_70301_a((int)this.canSlot).field_77994_a > this.func_70301_a(this.canSlot).func_77976_d()) {
                    this.func_70301_a((int)this.canSlot).field_77994_a = this.func_70301_a(this.canSlot).func_77976_d();
                }
            }
            return space;
        }
        for (int i = this.inputSlot1; i < this.outputSlot1; ++i) {
            if (this.func_70301_a(i) != null) continue;
            if (doAdd) {
                this.func_70299_a(i, stack.func_77946_l());
            }
            return stack.field_77994_a;
        }
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.resourceTank.quantity > 0 && this.resourceTank.liquidId != resource.itemID) {
            return 0;
        }
        if (resource.itemID != ForestryItem.liquidHoney.field_77779_bT) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }
}

