/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.PowerFramework;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IEnergyConsumer;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Utils;
import forestry.plugins.PluginForestryApiculture;
import forestry.plugins.PluginForestryCore;
import forestry.plugins.PluginForestryEnergy;
import forestry.plugins.PluginForestryFactory;
import forestry.plugins.PluginForestryMail;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySource;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileMachine
extends TileForestry
implements ILiquidTankContainer,
ISpecialInventory,
ISidedInventory,
IEnergyConsumer,
IEnergySource,
IClimatised,
IHintSource {
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    int oldkind;
    NBTTagCompound olddata;
    private HashMap definitionMap;

    public TileMachine() {
        this.powerProvider.configure(1000, 5, 40, 75, 500);
    }

    @Override
    public boolean throwsErrors() {
        return false;
    }

    @Override
    public boolean hasHints() {
        return false;
    }

    @Override
    public String[] getHints() {
        return null;
    }

    @Override
    public boolean isClimatized() {
        return false;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.NORMAL;
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.NORMAL;
    }

    @Override
    public float getExactTemperature() {
        return 0.0f;
    }

    @Override
    public float getExactHumidity() {
        return 0.0f;
    }

    @Override
    public boolean isOwnable() {
        return true;
    }

    protected void createMachine() {
    }

    @Override
    public void initialize() {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        if (this.olddata != null) {
            this.legacyConversion(this.oldkind, this.olddata);
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
    }

    @Override
    public void onRemoval() {
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        int kind;
        super.func_70307_a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.oldkind = kind = nbttagcompound.func_74762_e("Kind");
        this.olddata = nbttagcompound;
    }

    private void createDefinitionMap() {
        this.definitionMap = new HashMap();
        HashMap<Integer, MachineDefinition> machineMap = new HashMap<Integer, MachineDefinition>();
        machineMap.put(2, PluginForestryFactory.definitionBottler);
        machineMap.put(5, PluginForestryFactory.definitionCarpenter);
        machineMap.put(8, PluginForestryFactory.definitionCentrifuge);
        machineMap.put(11, PluginForestryFactory.definitionFabricator);
        machineMap.put(0, PluginForestryFactory.definitionFermenter);
        machineMap.put(6, PluginForestryFactory.definitionMoistener);
        machineMap.put(3, PluginForestryFactory.definitionRaintank);
        machineMap.put(9, PluginForestryFactory.definitionSqueezer);
        machineMap.put(1, PluginForestryFactory.definitionStill);
        machineMap.put(7, PluginForestryApiculture.definitionApiary);
        machineMap.put(4, PluginForestryEnergy.definitionGenerator);
        this.definitionMap.put(ForestryBlock.factoryTESR.field_71990_ca, machineMap);
        HashMap<Integer, MachineDefinition> millMap = new HashMap<Integer, MachineDefinition>();
        millMap.put(5, PluginForestryMail.definitionMailbox);
        millMap.put(6, PluginForestryMail.definitionTradestation);
        millMap.put(7, PluginForestryMail.definitionPhilatelist);
        millMap.put(3, PluginForestryApiculture.definitionChest);
        millMap.put(4, PluginForestryCore.definitionAnalyzer);
        millMap.put(1, PluginForestryFactory.definitionRainmaker);
        this.definitionMap.put(ForestryBlock.factoryPlain.field_71990_ca, millMap);
        HashMap<Integer, MachineDefinition> engineMap = new HashMap<Integer, MachineDefinition>();
        engineMap.put(0, PluginForestryEnergy.definitionEngineBronze);
        engineMap.put(1, PluginForestryEnergy.definitionEngineCopper);
        engineMap.put(2, PluginForestryEnergy.definitionEngineTin);
        this.definitionMap.put(ForestryBlock.engine.field_71990_ca, engineMap);
    }

    private void legacyConversion(int kind, NBTTagCompound nbttagcompound) {
        int blockid;
        if (this.definitionMap == null) {
            this.createDefinitionMap();
        }
        if (!this.definitionMap.containsKey(blockid = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)) || !((HashMap)this.definitionMap.get(blockid)).containsKey(kind)) {
            this.commitSeppuku(blockid, kind);
            return;
        }
        MachineDefinition definition = (MachineDefinition)((HashMap)this.definitionMap.get(blockid)).get(kind);
        Proxies.log.info("Converting obsolete gadget %s-%s to new '%s' %s-%s", blockid, kind, definition.teIdent, definition.blockID, definition.meta);
        Proxies.log.info("Removing old tile entity...");
        this.field_70331_k.func_72932_q(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 2);
        Proxies.log.info("Setting to new block id...");
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, definition.blockID, definition.meta, 2);
        TileEntity tile = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (tile == null) {
            throw new RuntimeException("Failed to set new block tile entity!");
        }
        if (tile.getClass() != definition.teClass) {
            throw new RuntimeException(String.format("Converted tile entity was '%s' instead of expected '%s'", tile.getClass(), definition.teClass));
        }
        Proxies.log.info("Refreshing converted tile entity %s with nbt data...", (Object)tile.getClass());
        if (nbttagcompound.func_74764_b("Machine")) {
            tile.func_70307_a(this.complementNBT(nbttagcompound, nbttagcompound.func_74775_l("Machine"), definition));
        } else {
            tile.func_70307_a(nbttagcompound);
        }
    }

    private NBTTagCompound complementNBT(NBTTagCompound parent, NBTTagCompound inner, MachineDefinition definition) {
        inner.func_74778_a("id", definition.teIdent);
        inner.func_74768_a("x", this.field_70329_l);
        inner.func_74768_a("y", this.field_70330_m);
        inner.func_74768_a("z", this.field_70327_n);
        inner.func_74768_a("Access", parent.func_74762_e("Access"));
        if (parent.func_74764_b("Owner")) {
            inner.func_74778_a("Owner", parent.func_74779_i("Owner"));
        }
        if (parent.func_74764_b("Orientation")) {
            inner.func_74768_a("Orientation", parent.func_74762_e("Orientation"));
        }
        return inner;
    }

    private void commitSeppuku(int blockid, int meta) {
        Proxies.log.info("Obsolete gadget %s-%s has no replacement defined. Committing sepukku.", blockid, meta);
        this.field_70331_k.func_72932_q(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 2);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        int kind = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        nbttagcompound.func_74768_a("Kind", kind);
    }

    public void func_70312_q() {
        super.func_70312_q();
    }

    public boolean isWorking() {
        return false;
    }

    public int getChargeReceivedScaled(int i) {
        return this.energyReceived * i / this.powerProvider.getMaxEnergyReceived();
    }

    public static EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    public boolean isIndirectlyPoweringTo(IBlockAccess world, int i, int j, int k, int l) {
        return false;
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest(ForgeDirection direction) {
        if (this.isWorking()) {
            return Math.min(this.getPowerProvider().getMaxEnergyReceived(), this.getPowerProvider().getActivationEnergy() / 5 + 1);
        }
        return 0;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    @Override
    public String func_70303_b() {
        return "[Unknown]";
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return Utils.isUseableByPlayer(player, this, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        return 0;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return new ItemStack[0];
        }
        return new ItemStack[0];
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = null;
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
    }

    public void onNeighborBlockChange() {
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return false;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return false;
    }

    @Override
    public int getMaxEnergyOutput() {
        return 0;
    }

    @Override
    public LinkedList getCustomTriggers() {
        return null;
    }

    @Override
    public boolean consumesEnergy() {
        return this.powerProvider.getMaxEnergyReceived() > 0;
    }

    @Override
    public float getMaxEnergyStored() {
        return this.powerProvider.getMaxEnergyStored();
    }

    @Override
    public float getEnergyStored() {
        return this.powerProvider.getEnergyStored();
    }

    @Override
    public float getMaxEnergyReceived() {
        return this.powerProvider.getMaxEnergyReceived();
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new LiquidTank[0];
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return null;
    }
}

