/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.core.network.PacketNBT;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;

public abstract class BreedingTracker
extends WorldSavedData
implements IBreedingTracker {
    private ArrayList discoveredSpecies = new ArrayList();
    private ArrayList discoveredMutations = new ArrayList();
    private String modeName;

    public BreedingTracker(String s) {
        super(s);
    }

    @Override
    public String getModeName() {
        return this.modeName;
    }

    @Override
    public void setModeName(String name) {
        this.modeName = name;
        this.func_76185_a();
    }

    protected abstract IBreedingTracker getCommonTracker(EntityPlayer var1);

    protected abstract String getPacketTag();

    @Override
    public void synchToPlayer(EntityPlayer player) {
        this.setModeName(this.getCommonTracker(player).getModeName());
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.encodeToNBT(nbttagcompound);
        Proxies.net.sendToPlayer(new PacketNBT(60, nbttagcompound), player);
    }

    @Override
    public void decodeFromNBT(NBTTagCompound nbttagcompound) {
        this.func_76184_a(nbttagcompound);
    }

    @Override
    public void encodeToNBT(NBTTagCompound nbttagcompound) {
        this.func_76187_b(nbttagcompound);
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        int i;
        if (nbttagcompound.func_74764_b("BMS")) {
            this.modeName = nbttagcompound.func_74779_i("BMS");
        }
        this.discoveredSpecies = new ArrayList();
        int count = nbttagcompound.func_74762_e("SpeciesCount");
        for (i = 0; i < count; ++i) {
            this.discoveredSpecies.add(nbttagcompound.func_74779_i("SD" + i));
        }
        this.discoveredMutations = new ArrayList();
        count = nbttagcompound.func_74762_e("MutationsCount");
        for (i = 0; i < count; ++i) {
            this.discoveredMutations.add(nbttagcompound.func_74779_i("MD" + i));
        }
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        int i;
        if (this.modeName != null && !this.modeName.isEmpty()) {
            nbttagcompound.func_74778_a("BMS", this.modeName);
        }
        nbttagcompound.func_74778_a("TYPE", this.getPacketTag());
        nbttagcompound.func_74768_a("SpeciesCount", this.discoveredSpecies.size());
        for (i = 0; i < this.discoveredSpecies.size(); ++i) {
            if (this.discoveredSpecies.get(i) == null) continue;
            nbttagcompound.func_74778_a("SD" + i, (String)this.discoveredSpecies.get(i));
        }
        nbttagcompound.func_74768_a("MutationsCount", this.discoveredMutations.size());
        for (i = 0; i < this.discoveredMutations.size(); ++i) {
            if (this.discoveredMutations.get(i) == null) continue;
            nbttagcompound.func_74778_a("MD" + i, (String)this.discoveredMutations.get(i));
        }
    }

    @Override
    public void registerMutation(IMutation mutation) {
        this.discoveredMutations.add(mutation.getAllele0().getUID() + "-" + mutation.getAllele1().getUID());
        this.func_76185_a();
    }

    @Override
    public boolean isDiscovered(IMutation mutation) {
        return this.discoveredMutations.contains(mutation.getAllele0().getUID() + "-" + mutation.getAllele1().getUID());
    }

    @Override
    public boolean isDiscovered(IAlleleSpecies species) {
        return this.discoveredSpecies.contains(species.getUID());
    }

    @Override
    public int getSpeciesBred() {
        return this.discoveredSpecies.size();
    }

    @Override
    public void registerIndividual(IIndividual individual) {
        this.registerSpecies(individual.getGenome().getPrimary());
        this.registerSpecies(individual.getGenome().getSecondary());
    }

    @Override
    public void registerSpecies(IAlleleSpecies species) {
        if (!this.discoveredSpecies.contains(species.getUID())) {
            this.discoveredSpecies.add(species.getUID());
        }
    }
}

