/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import buildcraft.api.tools.IToolPipette;
import forestry.core.gui.ContainerForestry;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class ContainerLiquidTanks
extends ContainerForestry {
    private ILiquidTankContainer tanks;

    public ContainerLiquidTanks(IInventory inventory, ILiquidTankContainer tanks) {
        this(inventory, tanks, inventory.func_70302_i_());
    }

    public ContainerLiquidTanks(IInventory inventory, ILiquidTankContainer tanks, int slotCount) {
        super(inventory, slotCount);
        this.tanks = tanks;
    }

    public void handlePipetteClick(int slot, EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        if (!(held instanceof IToolPipette)) {
            return;
        }
        if (!Proxies.common.isSimulating(player.field_70170_p)) {
            PacketPayload payload = new PacketPayload(1, 0, 0);
            payload.intPayload[0] = slot;
            Proxies.net.sendToServer(new PacketUpdate(40, payload));
            return;
        }
        IToolPipette pipette = (IToolPipette)held;
        int liquidAmount = this.tanks.getTanks((ForgeDirection)ForgeDirection.UNKNOWN)[slot].getLiquid().amount;
        if (pipette.canPipette(itemstack) && liquidAmount > 0) {
            if (liquidAmount > 0) {
                int filled = pipette.fill(itemstack, this.tanks.getTanks(ForgeDirection.UNKNOWN)[slot].drain(1000, false), true);
                this.tanks.getTanks(ForgeDirection.UNKNOWN)[slot].drain(filled, true);
            }
        } else {
            ILiquidTank tank = this.tanks.getTanks(ForgeDirection.UNKNOWN)[slot];
            LiquidStack potential = pipette.drain(itemstack, pipette.getCapacity(itemstack), false);
            if (potential != null) {
                pipette.drain(itemstack, tank.fill(potential, true), true);
            }
        }
    }
}

