/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Stack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class GuiAlyzer
extends GuiForestry {
    protected IInventory inventory;
    protected HashMap iconStacks = new HashMap();

    public GuiAlyzer(String texture, ContainerForestry container, IInventory inventory, int pageMax, int pageSize) {
        super(texture, container);
        this.inventory = inventory;
    }

    protected final int getColorCoding(boolean dominant) {
        if (dominant) {
            return this.fontColor.get("gui.beealyzer.dominant");
        }
        return this.fontColor.get("gui.beealyzer.recessive");
    }

    protected final void drawLine(String text, int x, IIndividual individual, Enum chromosome, boolean inactive) {
        if (!inactive) {
            this.drawLine(text, x, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome.ordinal()).isDominant()));
        } else {
            this.drawLine(text, x, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome.ordinal()).isDominant()));
        }
    }

    protected final void drawSplitLine(String text, int x, int maxWidth, IIndividual individual, Enum chromosome, boolean inactive) {
        if (!inactive) {
            this.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getActiveAllele(chromosome.ordinal()).isDominant()));
        } else {
            this.drawSplitLine(text, x, maxWidth, this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome.ordinal()).isDominant()));
        }
    }

    protected final void drawRow(String text0, String text1, String text2, IIndividual individual, Enum chromosome) {
        this.drawRow(text0, text1, text2, this.fontColor.get("gui.screen"), this.getColorCoding(individual.getGenome().getActiveAllele(chromosome.ordinal()).isDominant()), this.getColorCoding(individual.getGenome().getInactiveAllele(chromosome.ordinal()).isDominant()));
    }

    protected final void drawAnalyticsPageClassification(IIndividual individual) {
        this.startPage();
        this.drawLine(StringUtil.localize("gui.alyzer.classification") + ":", 12);
        this.newLine();
        Stack<IClassification> hierarchy = new Stack<IClassification>();
        for (IClassification classification = individual.getGenome().getPrimary().getBranch(); classification != null; classification = classification.getParent()) {
            if (classification.getScientific() == null || classification.getScientific().isEmpty()) continue;
            hierarchy.push(classification);
        }
        boolean overcrowded = hierarchy.size() > 5;
        int x = 12;
        IClassification group = null;
        while (!hierarchy.isEmpty()) {
            group = (IClassification)hierarchy.pop();
            if (overcrowded && group.getLevel().isDroppable()) continue;
            this.drawLine(group.getScientific(), x, group.getLevel().getColour());
            this.drawLine(group.getLevel().name(), 130, group.getLevel().getColour());
            this.newLine();
            x += 8;
        }
        String binomial = individual.getGenome().getPrimary().getBinomial();
        if (group != null && group.getLevel() == IClassification.EnumClassLevel.GENUS) {
            binomial = group.getScientific().substring(0, 1) + ". " + binomial.toLowerCase(Locale.ENGLISH);
        }
        this.drawLine(binomial, x, 15445637);
        this.drawLine("SPECIES", 130, 15445637);
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.alyzer.authority") + ": " + individual.getGenome().getPrimary().getAuthority(), 12);
        if (AlleleManager.alleleRegistry.isBlacklisted(individual.getIdent())) {
            String extinct = ">> " + StringUtil.localize("gui.alyzer.extinct").toUpperCase() + " <<";
            this.field_73886_k.func_78261_a(extinct, this.adjustToFactor(this.guiLeft + 160) - this.field_73886_k.func_78256_a(extinct), this.adjustToFactor(this.guiTop + this.getLineY()), this.fontColor.get("gui.beealyzer.dominant"));
        }
        this.newLine();
        String description = individual.getGenome().getPrimary().getDescription();
        if (description == null || description.isEmpty()) {
            this.drawSplitLine(StringUtil.localize("gui.alyzer.nodescription"), 12, 156, 0x666666);
        } else {
            String[] tokens = description.split("\\|");
            this.drawSplitLine(tokens[0], 12, 152, 0x666666);
            if (tokens.length > 1) {
                this.field_73886_k.func_78261_a("- " + tokens[1], this.adjustToFactor(this.guiLeft + 160) - this.field_73886_k.func_78256_a("- " + tokens[1]), this.adjustToFactor(this.guiTop + 145 - 14), 10079282);
            }
        }
        this.endPage();
    }

    protected void drawMutationInfo(IMutation combination, IAllele species, int x) {
        itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.guiLeft) + x, this.adjustToFactor(this.guiTop) + this.getLineY());
        itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.guiLeft) + x, this.adjustToFactor(this.guiTop) + this.getLineY());
        IAllele result = combination.getTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(result.getUID()), this.adjustToFactor(this.guiLeft) + x + 33, this.adjustToFactor(this.guiTop) + this.getLineY());
        itemRenderer.func_77021_b(this.field_73886_k, this.field_73882_e.field_71446_o, (ItemStack)this.iconStacks.get(result.getUID()), this.adjustToFactor(this.guiLeft) + x + 33, this.adjustToFactor(this.guiTop) + this.getLineY());
        int line = 0;
        int column = 196;
        switch (EnumMutateChance.rateChance(combination.getBaseChance())) {
            case HIGHEST: {
                column = 226;
                line = 9;
                break;
            }
            case HIGHER: {
                column = 211;
                line = 9;
                break;
            }
            case HIGH: {
                line = 9;
                break;
            }
            case NORMAL: {
                column = 226;
                break;
            }
            case LOW: {
                column = 211;
                break;
            }
        }
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft) + x + 18, this.adjustToFactor(this.guiTop) + this.getLineY() + 4, column, line, 15, 9);
    }

    protected void drawUnknownMutation(IMutation combination, IAllele species, int x) {
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft) + x, this.adjustToFactor(this.guiTop) + this.getLineY(), 196, 18, 16, 16);
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft) + x + 32, this.adjustToFactor(this.guiTop) + this.getLineY(), 196, 18, 16, 16);
        int line = 0;
        int column = 196;
        switch (EnumMutateChance.rateChance(combination.getBaseChance())) {
            case HIGHEST: {
                column = 226;
                line = 9;
                break;
            }
            case HIGHER: {
                column = 211;
                line = 9;
                break;
            }
            case HIGH: {
                line = 9;
                break;
            }
            case NORMAL: {
                column = 226;
                break;
            }
            case LOW: {
                column = 211;
                break;
            }
        }
        this.field_73882_e.field_71446_o.func_98187_b("/gfx/forestry/gui/beealyzer.png");
        this.func_73729_b(this.adjustToFactor(this.guiLeft) + x + 18, this.adjustToFactor(this.guiTop) + this.getLineY() + 4, column, line, 15, 9);
    }
}

