/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ItemForestryFood
extends Item {
    private boolean isAlwaysEdible = false;
    private boolean isDrink = false;
    private int healAmount = 0;
    private float saturationModifier;
    private int potionId;
    private int potionDuration;
    private int potionAmplifier;
    private float potionEffectProbability;

    public ItemForestryFood(int index, int heal) {
        this(index, heal, 0.6f);
    }

    public ItemForestryFood(int index, int heal, float saturation) {
        super(index);
        this.healAmount = heal;
        this.saturationModifier = saturation;
        this.func_77637_a(CreativeTabForestry.tabForestry);
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        --itemstack.field_77994_a;
        entityplayer.func_71024_bL().func_75122_a(this.healAmount, this.saturationModifier);
        world.func_72956_a((Entity)entityplayer, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        if (!world.field_72995_K && this.potionId > 0 && world.field_73012_v.nextFloat() < this.potionEffectProbability) {
            entityplayer.func_70690_d(new PotionEffect(this.potionId, this.potionDuration * 20, this.potionAmplifier));
        }
        return itemstack;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        if (this.isDrink) {
            return EnumAction.drink;
        }
        return EnumAction.eat;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (entityplayer.func_71043_e(this.isAlwaysEdible)) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public ItemForestryFood setIsDrink() {
        this.isDrink = true;
        return this;
    }

    public ItemForestryFood setPotionEffect(int i, int j, int k, float f) {
        this.potionId = i;
        this.potionDuration = j;
        this.potionAmplifier = k;
        this.potionEffectProbability = f;
        return this;
    }

    public ItemForestryFood setAlwaysEdible() {
        this.isAlwaysEdible = true;
        return this;
    }

    public String func_77628_j(ItemStack itemstack) {
        return StringUtil.localize(this.func_77667_c(itemstack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.field_77791_bV = TextureManager.getInstance().registerItemTex(this.func_77658_a().replace("item.", ""));
    }
}

