/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.items.ItemForestry;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemOverlay
extends ItemForestry {
    private OverlayInfo[] overlays;
    @SideOnly(value=Side.CLIENT)
    private Icon primaryIcon;
    @SideOnly(value=Side.CLIENT)
    private Icon secondaryIcon;

    public ItemOverlay(int i, CreativeTabs tab, OverlayInfo[] overlays) {
        super(i);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(tab);
        this.overlays = overlays;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.overlays.length; ++i) {
            if (this.overlays[i].isSecret) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.primaryIcon = TextureManager.getInstance().registerItemTex(this.func_77658_a().replace("item.", "") + ".0");
        if (this.overlays[0].secondaryColor != 0) {
            this.secondaryIcon = TextureManager.getInstance().registerItemTex(this.func_77658_a().replace("item.", "") + ".1");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int i, int j) {
        if (j > 0 && this.overlays[i].secondaryColor != 0) {
            return this.secondaryIcon;
        }
        return this.primaryIcon;
    }

    public int getRenderPasses(int metadata) {
        return this.overlays[metadata].secondaryColor != 0 ? 2 : 1;
    }

    public boolean func_77623_v() {
        return true;
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        if (itemstack.func_77960_j() < 0 || itemstack.func_77960_j() >= this.overlays.length) {
            return null;
        }
        return StringUtil.localize(this.func_77658_a() + "." + this.overlays[itemstack.func_77960_j()].name);
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j == 0 || this.overlays[itemstack.func_77960_j()].secondaryColor == 0) {
            return this.overlays[itemstack.func_77960_j()].primaryColor;
        }
        return this.overlays[itemstack.func_77960_j()].secondaryColor;
    }

    public static class OverlayInfo {
        public String name;
        public int primaryColor = 0;
        public int secondaryColor = 0;
        public boolean isSecret = false;

        public OverlayInfo(String name, int primaryColor, int secondaryColor) {
            this.name = name;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }

        public OverlayInfo(String name, int primaryColor) {
            this(name, primaryColor, 0);
        }

        public OverlayInfo setIsSecret() {
            this.isSecret = true;
            return this;
        }
    }
}

