/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import buildcraft.api.tools.IToolPipette;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.INBTTagable;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.liquids.LiquidStack;

public class ItemPipette
extends ItemForestry
implements IToolPipette {
    @SideOnly(value=Side.CLIENT)
    private Icon primaryIcon;
    @SideOnly(value=Side.CLIENT)
    private Icon secondaryIcon;

    public ItemPipette(int i) {
        super(i);
        this.func_77625_d(1);
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    public boolean canPipette(ItemStack itemstack) {
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        return !contained.isFull(1000);
    }

    @Override
    public int fill(ItemStack itemstack, LiquidStack liquid, boolean doFill) {
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        int limit = this.getCapacity(itemstack);
        int filled = 0;
        if (contained.contents == null) {
            filled = liquid.amount > limit ? limit : liquid.amount;
            contained.contents = new LiquidStack(liquid.itemID, filled, liquid.itemMeta);
            filled = liquid.amount;
        } else {
            if (contained.contents.amount >= limit) {
                return 0;
            }
            if (!contained.contents.isLiquidEqual(liquid)) {
                return 0;
            }
            int space = limit - contained.contents.amount;
            filled = liquid.amount > space ? space : liquid.amount;
            contained.contents.amount += filled;
        }
        if (doFill) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            contained.writeToNBT(nbttagcompound);
            itemstack.func_77982_d(nbttagcompound);
            itemstack.func_77964_b(1);
        }
        return filled;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        contained.addTooltip(list);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.primaryIcon = TextureManager.getInstance().registerItemTex(this.func_77658_a().replace("item.", "") + ".0");
        this.secondaryIcon = TextureManager.getInstance().registerItemTex(this.func_77658_a().replace("item.", "") + ".1");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int damage) {
        if (damage <= 0) {
            return this.primaryIcon;
        }
        return this.secondaryIcon;
    }

    @Override
    public LiquidStack drain(ItemStack pipette, int maxDrain, boolean doDrain) {
        PipetteContents contained = new PipetteContents(pipette.func_77978_p());
        if (contained.contents == null || contained.contents.itemID <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (contained.contents.amount < drained) {
            drained = contained.contents.amount;
        }
        if (doDrain) {
            contained.contents.amount -= drained;
            if (contained.contents.amount <= 0) {
                pipette.func_77982_d(null);
                pipette.func_77964_b(0);
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                contained.writeToNBT(nbttagcompound);
                pipette.func_77982_d(nbttagcompound);
            }
        }
        return new LiquidStack(contained.contents.itemID, drained, contained.contents.itemMeta);
    }

    @Override
    public int getCapacity(ItemStack pipette) {
        return 1000;
    }

    class PipetteContents
    implements INBTTagable {
        LiquidStack contents;

        public PipetteContents(NBTTagCompound nbttagcompound) {
            if (nbttagcompound != null) {
                this.readFromNBT(nbttagcompound);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            this.contents = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)nbttagcompound);
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            if (this.contents != null) {
                this.contents.writeToNBT(nbttagcompound);
            }
        }

        public boolean isFull(int limit) {
            if (this.contents == null) {
                return false;
            }
            return this.contents.itemID > 0 && this.contents.amount >= limit;
        }

        public void addTooltip(List list) {
            if (this.contents == null) {
                return;
            }
            if (this.contents.itemID <= 0) {
                return;
            }
            String descr = Proxies.common.getItemDisplayName(Item.field_77698_e[this.contents.itemID]);
            list.add(descr);
        }
    }
}

