/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.gadgets.Mill;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMill
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private ModelBase model = new ModelBase(){};
    private String gfxBase;
    private ModelRenderer pedestal = new ModelRenderer(this.model, 0, 0);
    private ModelRenderer column;
    private ModelRenderer extension;
    private ModelRenderer blade1;
    private ModelRenderer blade2;

    public RenderMill() {
        this.pedestal.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 1, 16);
        this.pedestal.field_78800_c = 8.0f;
        this.pedestal.field_78797_d = 8.0f;
        this.pedestal.field_78798_e = 8.0f;
        this.column = new ModelRenderer(this.model, 0, 0);
        this.column.func_78789_a(-2.0f, -7.0f, -2.0f, 4, 15, 4);
        this.column.field_78800_c = 8.0f;
        this.column.field_78797_d = 8.0f;
        this.column.field_78798_e = 8.0f;
        this.extension = new ModelRenderer(this.model, 0, 0);
        this.extension.func_78789_a(1.0f, 8.0f, 7.0f, 14, 2, 2);
        this.extension.field_78800_c = 0.0f;
        this.extension.field_78797_d = 0.0f;
        this.extension.field_78798_e = 0.0f;
        this.blade1 = new ModelRenderer(this.model, 0, 0);
        this.blade1.func_78789_a(-4.0f, -5.0f, -3.0f, 8, 12, 1);
        this.blade1.field_78800_c = 8.0f;
        this.blade1.field_78797_d = 8.0f;
        this.blade1.field_78798_e = 8.0f;
        this.blade2 = new ModelRenderer(this.model, 0, 0);
        this.blade2.func_78789_a(-4.0f, -5.0f, 2.0f, 8, 12, 1);
        this.blade2.field_78800_c = 8.0f;
        this.blade2.field_78797_d = 8.0f;
        this.blade2.field_78798_e = 8.0f;
    }

    public RenderMill(String baseTexture) {
        this();
        this.gfxBase = baseTexture;
    }

    public RenderMill(String baseTexture, byte charges) {
        this(baseTexture);
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        int charge = 0;
        this.render(0.0f, charge, ForgeDirection.WEST, this.gfxBase, x, y, z);
    }

    @Override
    public void func_76894_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        Mill tile = (Mill)tileentity;
        this.render(tile.progress, tile.charge, ForgeDirection.WEST, this.gfxBase, d, d1, d2);
    }

    private void render(float progress, int charge, ForgeDirection orientation, String gfxBase, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 3.99f - (progress - 0.5f) * 2.0f * 3.99f : progress * 2.0f * 3.99f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float tfactor = step / 16.0f;
        if (orientation == null) {
            orientation = ForgeDirection.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case UP: {
                translate[1] = 1.0f;
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.pedestal.field_78795_f = angle[0];
        this.pedestal.field_78796_g = angle[2];
        this.pedestal.field_78808_h = angle[1];
        this.column.field_78795_f = angle[0];
        this.column.field_78796_g = angle[2];
        this.column.field_78808_h = angle[1];
        this.blade1.field_78795_f = angle[0];
        this.blade1.field_78796_g = angle[2];
        this.blade1.field_78808_h = angle[1];
        this.blade2.field_78795_f = angle[0];
        this.blade2.field_78796_g = angle[2];
        this.blade2.field_78808_h = angle[1];
        float factor = 0.0625f;
        Proxies.common.bindTexture(gfxBase + "pedestal.png");
        this.pedestal.func_78785_a(factor);
        Proxies.common.bindTexture(gfxBase + "column_" + charge + ".png");
        this.column.func_78785_a(factor);
        Proxies.common.bindTexture(gfxBase + "extension.png");
        this.extension.func_78785_a(factor);
        Proxies.common.bindTexture(gfxBase + "blade1.png");
        GL11.glTranslatef((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.blade1.func_78785_a(factor);
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        Proxies.common.bindTexture(gfxBase + "blade2.png");
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(-translate[2] * tfactor));
        this.blade2.func_78785_a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

