/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.RecipeManagers;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.core.proxy.Proxies;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class RecipeUtil {
    public static void injectLeveledRecipe(ItemStack resource, int fermentationValue, ItemStack outputItem) {
        if (RecipeManagers.fermenterManager == null) {
            return;
        }
        if (!Config.invalidFingerprint) {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.0f, new LiquidStack(outputItem.field_77993_c, 1, outputItem.func_77960_j()), new LiquidStack(Block.field_71943_B, 1));
            if (ForestryItem.liquidJuice != null) {
                RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, new LiquidStack(outputItem.field_77993_c, 1, outputItem.func_77960_j()), new LiquidStack(ForestryItem.liquidJuice, 1));
            }
            if (ForestryItem.liquidHoney != null) {
                RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 1.5f, new LiquidStack(outputItem.field_77993_c, 1, outputItem.func_77960_j()), new LiquidStack(ForestryItem.liquidHoney, 1));
            }
        } else {
            RecipeManagers.fermenterManager.addRecipe(resource, fermentationValue, 0.5f, new LiquidStack(outputItem.field_77993_c, 1, outputItem.func_77960_j()), new LiquidStack(Block.field_71938_D, 1));
        }
    }

    public static Object[] getCraftingRecipeAsArray(Object rec) {
        try {
            if (rec instanceof IDescriptiveRecipe) {
                IDescriptiveRecipe recipe = (IDescriptiveRecipe)rec;
                return RecipeUtil.getShapedRecipeAsArray(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients(), recipe.func_77571_b());
            }
        }
        catch (Exception ex) {
            Proxies.log.warning("Exception while trying to parse an ItemStack[10] from an IRecipe:");
            Proxies.log.warning(ex.getMessage());
        }
        return null;
    }

    private static Object[] getShapedRecipeAsArray(int width, int height, Object[] ingredients, ItemStack output) {
        Object[] result = new Object[10];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y * 3 + x] = ingredients[y * width + x];
            }
        }
        result[9] = output;
        return result;
    }
}

