/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IBottlerManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class MachineBottler
extends TilePowered
implements ISpecialInventory,
ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    public static final short SLOT_CAN = 2;
    public static final short CYCLES_FILLING_DEFAULT = 5;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private InventoryAdapter inventory = new InventoryAdapter(3, "Items");
    private boolean productPending = false;
    private Recipe currentRecipe;
    private Stack pendingProducts = new Stack();
    private int fillingTime;
    private int fillingTotalTime;

    public MachineBottler() {
        this.setHints((String[])Config.hints.get("bottler"));
    }

    @Override
    public String func_70303_b() {
        return "factory.0";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.BottlerGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    protected void configurePowerProvider(IPowerProvider provider) {
        provider.configure(1000, 5, 110, 25, 400);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("FillingTime", this.fillingTime);
        nbttagcompound.func_74768_a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.func_74757_a("ProductPending", this.productPending);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.fillingTime = nbttagcompound.func_74762_e("FillingTime");
        this.fillingTotalTime = nbttagcompound.func_74762_e("FillingTotalTime");
        this.productPending = nbttagcompound.func_74767_n("ProductPending");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("PendingProducts");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            this.pendingProducts.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.field_70331_k.func_72820_D() % 20L * 10L != 0L) {
            return;
        }
        if (this.inventory.func_70301_a(2) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(2))) != null && RecipeManager.isInput(container.stillLiquid)) {
            this.inventory.func_70299_a(2, StackUtils.replenishByContainer(this, this.inventory.func_70301_a(2), container, this.resourceTank));
            if (this.inventory.func_70301_a((int)2).field_77994_a <= 0) {
                this.inventory.func_70299_a(2, null);
            }
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.fillingTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
            return false;
        }
        --this.fillingTime;
        if (this.fillingTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        this.pendingProducts.push(this.currentRecipe.bottled.func_77946_l());
        this.inventory.func_70298_a(0, 1);
        this.resourceTank.quantity -= this.currentRecipe.input.amount;
        if (this.resourceTank.quantity < 0) {
            this.resourceTank.quantity = 0;
        }
        this.checkRecipe();
        this.resetRecipe();
        while (this.tryAddPending()) {
        }
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity), this.inventory.func_70301_a(0));
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fillingTime = 0;
            this.fillingTotalTime = 0;
            return;
        }
        this.fillingTime = this.currentRecipe.cyclesPerUnit;
        this.fillingTotalTime = this.currentRecipe.cyclesPerUnit;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = (ItemStack)this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(ItemStack product, boolean all) {
        return this.inventory.tryAddStack(product, 1, 1, all);
    }

    @Override
    public boolean isWorking() {
        return this.fillingTime > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventory.func_70301_a(0) == null) {
            return false;
        }
        return (float)this.inventory.func_70301_a((int)0).field_77994_a / (float)this.inventory.func_70301_a(0).func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidMeta = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fillingTime);
        iCrafting.func_71112_a(container, 1, this.fillingTotalTime);
        iCrafting.func_71112_a(container, 2, this.resourceTank.liquidId);
        iCrafting.func_71112_a(container, 3, this.resourceTank.quantity);
        iCrafting.func_71112_a(container, 4, this.resourceTank.liquidMeta);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (!RecipeManager.hasCan(stack)) {
            return 0;
        }
        return this.inventory.addStack(stack, 2, 1, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.inventory.func_70301_a(1) == null) {
            return StackUtils.EMPTY_STACK_ARRAY;
        }
        if (this.inventory.func_70301_a((int)1).field_77994_a <= 0) {
            return StackUtils.EMPTY_STACK_ARRAY;
        }
        ItemStack product = new ItemStack(this.inventory.func_70301_a((int)1).field_77993_c, 1, this.inventory.func_70301_a(1).func_77960_j());
        if (doRemove) {
            this.inventory.func_70298_a(1, 1);
        }
        return new ItemStack[]{product};
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    protected InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 1;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 0) {
            return RecipeManager.hasCan(itemstack);
        }
        if (slotIndex == 2) {
            LiquidContainerData container = LiquidHelper.getLiquidContainer(itemstack);
            return container != null && RecipeManager.isInput(container.stillLiquid);
        }
        return false;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.resourceTank.quantity > 0 && this.resourceTank.liquidId != resource.itemID) {
            return 0;
        }
        if (!RecipeManager.isInput(resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements IBottlerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int cyclesPerUnit, LiquidStack input, ItemStack can, ItemStack bottled) {
            recipes.add(new Recipe(cyclesPerUnit, input, can, bottled));
        }

        public static Recipe findMatchingRecipe(LiquidStack res, ItemStack empty) {
            ItemStack filled;
            if (res == null || empty == null) {
                return null;
            }
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(res, empty)) continue;
                return recipe;
            }
            if (LiquidContainerRegistry.isEmptyContainer((ItemStack)empty) && (filled = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)res, (ItemStack)empty)) != null) {
                RecipeManagers.bottlerManager.addRecipe(5, LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)filled), empty, filled);
                return RecipeManager.findMatchingRecipe(res, empty);
            }
            return null;
        }

        public static boolean isInput(LiquidStack res) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.hasInput(res)) continue;
                return true;
            }
            return LiquidDictionary.getCanonicalLiquid((LiquidStack)res) != null;
        }

        public static boolean hasCan(ItemStack res) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.hasCan(res)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            HashMap<ItemStack[], ItemStack[]> recipeList = new HashMap<ItemStack[], ItemStack[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ItemStack[]{recipe.input.asItemStack(), recipe.can}, new ItemStack[]{recipe.bottled});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int cyclesPerUnit;
        public final LiquidStack input;
        public final ItemStack can;
        public final ItemStack bottled;

        public Recipe(int cyclesPerUnit, LiquidStack input, ItemStack can, ItemStack bottled) {
            this.cyclesPerUnit = cyclesPerUnit;
            this.input = input;
            this.can = can;
            this.bottled = bottled;
        }

        public boolean matches(LiquidStack res, ItemStack empty) {
            return this.input.isLiquidEqual(res) && res.amount >= this.input.amount && this.can.func_77969_a(empty);
        }

        public boolean hasInput(LiquidStack res) {
            return this.input.isLiquidEqual(res);
        }

        public boolean hasCan(ItemStack res) {
            return this.can.func_77969_a(res);
        }
    }
}

