/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICentrifugeManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.InventoryAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;

public class MachineCentrifuge
extends TilePowered
implements ISidedInventory,
ISpecialInventory {
    public static final int SLOT_RESOURCE = 0;
    public static final int SLOT_PRODUCT_1 = 1;
    private InventoryAdapter inventory = new InventoryAdapter(10, "Items");
    public Recipe currentRecipe;
    private Stack pendingProducts = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineCentrifuge() {
        this.setHints((String[])Config.hints.get("centrifuge"));
    }

    @Override
    public String func_70303_b() {
        return "factory.2";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.CentrifugeGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    protected void configurePowerProvider(IPowerProvider provider) {
        provider.configure(1000, 5, 40, 20, 500);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("ProductionTime", this.productionTime);
        nbttagcompound.func_74768_a("TimePerItem", this.timePerItem);
        this.inventory.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.productionTime = nbttagcompound.func_74762_e("ProductionTime");
        this.timePerItem = nbttagcompound.func_74762_e("TimePerItem");
        this.inventory.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("PendingProducts");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            this.pendingProducts.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        if (this.field_70331_k.func_72820_D() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        for (Map.Entry entry : this.currentRecipe.products.entrySet()) {
            if ((Integer)entry.getValue() >= 100) {
                this.pendingProducts.push(((ItemStack)entry.getKey()).func_77946_l());
                continue;
            }
            if (this.field_70331_k.field_73012_v.nextInt(100) >= (Integer)entry.getValue()) continue;
            this.pendingProducts.push(((ItemStack)entry.getKey()).func_77946_l());
        }
        this.inventory.func_70298_a(0, 1);
        this.checkRecipe();
        this.resetRecipe();
        this.tryAddPending();
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0));
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = (ItemStack)this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(ItemStack product, boolean all) {
        return this.inventory.tryAddStack(product, 1, this.func_70302_i_() - 1, all);
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventory.func_70301_a(0) == null) {
            return false;
        }
        return (float)this.inventory.func_70301_a((int)0).field_77994_a / (float)this.inventory.func_70301_a(0).func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.productionTime);
        iCrafting.func_71112_a(container, 1, this.timePerItem);
    }

    @Override
    protected InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex >= 1 && slotIndex < 10;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 0 && RecipeManager.findMatchingRecipe(itemstack) != null;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack product = null;
        for (int i = 1; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            product = new ItemStack(this.inventory.func_70301_a((int)i).field_77993_c, 1, this.inventory.func_70301_a(i).func_77960_j());
            if (!doRemove) break;
            this.func_70298_a(i, 1);
            break;
        }
        if (product != null) {
            return new ItemStack[]{product};
        }
        return new ItemStack[0];
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (this.inventory.func_70301_a(0) == null) {
            if (doAdd) {
                this.inventory.func_70299_a(0, stack.func_77946_l());
            }
            return stack.field_77994_a;
        }
        if (!this.inventory.func_70301_a(0).func_77969_a(stack)) {
            return 0;
        }
        int space = this.inventory.func_70301_a(0).func_77976_d() - this.inventory.func_70301_a((int)0).field_77994_a;
        if (space <= 0) {
            return 0;
        }
        if (doAdd) {
            this.inventory.func_70301_a((int)0).field_77994_a = stack.field_77994_a <= space ? (this.inventory.func_70301_a((int)0).field_77994_a += stack.field_77994_a) : (this.inventory.func_70301_a((int)0).field_77994_a += space);
        }
        return Math.min(stack.field_77994_a, space);
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements ICentrifugeManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, HashMap products) {
            recipes.add(new Recipe(timePerItem, resource, products));
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, ItemStack[] produce, int[] chances) {
            HashMap<ItemStack, Integer> products = new HashMap<ItemStack, Integer>();
            int i = 0;
            for (ItemStack prod : produce) {
                products.put(prod, chances[i]);
                ++i;
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, ItemStack primary, ItemStack secondary, int chance) {
            HashMap<ItemStack, Integer> products = new HashMap<ItemStack, Integer>();
            products.put(primary, 100);
            if (secondary != null) {
                products.put(secondary, chance);
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack resource, ItemStack primary) {
            HashMap<ItemStack, Integer> products = new HashMap<ItemStack, Integer>();
            products.put(primary, 100);
            this.addRecipe(timePerItem, resource, products);
        }

        public static Recipe findMatchingRecipe(ItemStack item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            HashMap<ItemStack[], ItemStack[]> recipeList = new HashMap<ItemStack[], ItemStack[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ItemStack[]{recipe.resource}, recipe.products.keySet().toArray(new ItemStack[0]));
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final ItemStack resource;
        public final HashMap products;

        public Recipe(int timePerItem, ItemStack resource, HashMap products) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.products = products;
        }

        public boolean matches(ItemStack res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null && this.resource != null) {
                return false;
            }
            if (res != null && this.resource == null) {
                return false;
            }
            return this.resource.func_77969_a(res);
        }
    }
}

