/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterManager;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineFermenter
extends TilePowered
implements ISidedInventory,
ISpecialInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_FUEL = 1;
    public static final short SLOT_CAN_OUTPUT = 2;
    public static final short SLOT_CAN_INPUT = 3;
    public static final short SLOT_INPUT = 4;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    @EntityNetData
    public TankSlot productTank = new TankSlot(10000);
    private InventoryAdapter inventory = new InventoryAdapter(5, "Items").configureSidedUp(0, 1).configureSidedDown(2, 1).configureSidedNorthSouth(4, 1).configureSided(4, 3, 1).configureSided(5, 1, 1);
    private Recipe currentRecipe;
    private float currentResourceModifier;
    public int fermentationTime = 0;
    public int fermentationTotalTime = 0;
    public int fuelBurnTime = 0;
    public int fuelTotalTime = 0;
    public int fuelCurrentFerment = 0;

    public MachineFermenter() {
        this.setHints((String[])Config.hints.get("fermenter"));
    }

    @Override
    public String func_70303_b() {
        return "factory.3";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.FermenterGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    protected void configurePowerProvider(IPowerProvider provider) {
        provider.configure(1000, 5, 110, 80, 800);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("FermentationTime", this.fermentationTime);
        nbttagcompound.func_74768_a("FermentationTotalTime", this.fermentationTotalTime);
        nbttagcompound.func_74768_a("FuelBurnTime", this.fuelBurnTime);
        nbttagcompound.func_74768_a("FuelTotalTime", this.fuelTotalTime);
        nbttagcompound.func_74768_a("FuelCurrentFerment", this.fuelCurrentFerment);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        NBTTagCompound NBTproductSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        nbttagcompound.func_74782_a("ProductTank", (NBTBase)NBTproductSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.fermentationTime = nbttagcompound.func_74762_e("FermentationTime");
        this.fermentationTotalTime = nbttagcompound.func_74762_e("FermentationTotalTime");
        this.fuelBurnTime = nbttagcompound.func_74762_e("FuelBurnTime");
        this.fuelTotalTime = nbttagcompound.func_74762_e("FuelTotalTime");
        this.fuelCurrentFerment = nbttagcompound.func_74762_e("FuelCurrentFerment");
        this.resourceTank = new TankSlot(10000);
        this.productTank = new TankSlot(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
            this.productTank.readFromNBT(nbttagcompound.func_74775_l("ProductTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.inventory.func_70301_a(4) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(4))) != null && RecipeManager.isLiquidResource(container.stillLiquid)) {
            this.inventory.func_70299_a(4, StackUtils.replenishByContainer(this, this.inventory.func_70301_a(4), container, this.resourceTank));
            if (this.inventory.func_70301_a((int)4).field_77994_a <= 0) {
                this.inventory.func_70299_a(4, null);
            }
        }
        if (this.inventory.func_70301_a(3) != null && (container = LiquidHelper.getEmptyContainer(this.inventory.func_70301_a(3), new LiquidStack(this.productTank.liquidId, this.productTank.quantity, this.productTank.liquidMeta))) != null) {
            this.inventory.func_70299_a(2, this.bottleIntoContainer(this.inventory.func_70301_a(3), this.inventory.func_70301_a(2), container, this.productTank));
            if (this.inventory.func_70301_a((int)3).field_77994_a <= 0) {
                this.inventory.func_70299_a(3, null);
            }
        }
        if (this.field_70331_k.func_72820_D() % 20L * 10L != 0L) {
            return;
        }
        if (RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta)) != null) {
            this.setErrorState(EnumErrorCode.OK);
        } else if (this.inventory.func_70301_a(1) == null && this.fuelBurnTime <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
    }

    @Override
    public boolean workCycle() {
        if (this.currentRecipe == null) {
            this.checkRecipe();
            this.resetRecipe();
            if (this.currentRecipe != null) {
                this.currentResourceModifier = this.determineResourceMod(this.inventory.func_70301_a(0));
                this.func_70298_a(0, 1);
                return true;
            }
            return false;
        }
        if (this.fuelBurnTime > 0 && this.resourceTank.quantity > 0 && this.productTank.quantity < 10000) {
            --this.fuelBurnTime;
            if (this.currentRecipe == null) {
                return true;
            }
            if (this.fermentationTime <= 0) {
                return false;
            }
            this.resourceTank.drain(this.fuelCurrentFerment, true);
            int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
            this.fermentationTime -= this.fuelCurrentFerment;
            this.addProduct(new LiquidStack(this.currentRecipe.output.itemID, Math.round((float)fermented * this.currentRecipe.modifier * this.currentResourceModifier), this.currentRecipe.output.itemMeta));
            if (this.fermentationTime > 0) {
                return true;
            }
            this.currentRecipe = null;
            return true;
        }
        if (this.fuelBurnTime <= 0) {
            this.fuelBurnTime = this.fuelTotalTime = this.determineFuelValue(this.getFuelStack());
            if (this.fuelBurnTime > 0) {
                this.fuelCurrentFerment = this.determineFermentPerCycle(this.getFuelStack());
                this.func_70298_a(1, 1);
                return true;
            }
            this.fuelCurrentFerment = 0;
            return false;
        }
        return false;
    }

    private void addProduct(LiquidStack output) {
        this.productTank.fill(output, true);
        if (this.productTank.quantity > 10000) {
            this.productTank.quantity = 10000;
        }
    }

    private void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta));
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fermentationTime = 0;
            this.fermentationTotalTime = 0;
            return;
        }
        this.fermentationTime = this.currentRecipe.fermentationValue;
        this.fermentationTotalTime = this.currentRecipe.fermentationValue;
    }

    private int determineFuelValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        int fuelid = item.func_77973_b().field_77779_bT;
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(item)) {
            return ((FermenterFuel)FuelManager.fermenterFuel.get((Object)item.func_77973_b())).burnDuration;
        }
        return 0;
    }

    private int determineFermentPerCycle(ItemStack item) {
        if (item == null) {
            return 0;
        }
        int fuelid = item.func_77973_b().field_77779_bT;
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(item.func_77973_b())) {
            return ((FermenterFuel)FuelManager.fermenterFuel.get((Object)item.func_77973_b())).fermentPerCycle;
        }
        return 0;
    }

    private float determineResourceMod(ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof IVariableFermentable)) {
            return 1.0f;
        }
        return ((IVariableFermentable)itemstack.func_77973_b()).getFermentationModifier(itemstack);
    }

    @Override
    public boolean isWorking() {
        if (this.currentRecipe == null && RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta)) == null) {
            return false;
        }
        if (this.fuelBurnTime > 0) {
            return this.resourceTank.quantity > 0 && this.productTank.quantity < 10000;
        }
        return this.determineFuelValue(this.getFuelStack()) > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.getFermentationStack() == null) {
            return false;
        }
        return (float)this.getFermentationStack().field_77994_a / (float)this.getFermentationStack().func_77976_d() > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        if (this.getFuelStack() == null) {
            return false;
        }
        return (float)this.getFuelStack().field_77994_a / (float)this.getFuelStack().func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        if (this.getFuelStack() == null && this.fuelBurnTime <= 0) {
            return false;
        }
        if (this.fuelBurnTime <= 0 && RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta)) == null) {
            return false;
        }
        if (this.getFermentationStack() == null && this.fermentationTime <= 0) {
            return false;
        }
        if (this.fermentationTime <= 0 && RecipeManager.findMatchingRecipe(this.inventory.func_70301_a(0), new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity, this.resourceTank.liquidMeta)) == null) {
            return false;
        }
        if (this.resourceTank.quantity <= 0) {
            return false;
        }
        return this.productTank.quantity < this.productTank.capacity;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.fuelTotalTime == 0) {
            return 0;
        }
        return this.fuelBurnTime * i / this.fuelTotalTime;
    }

    public int getFermentationProgressScaled(int i) {
        if (this.fermentationTotalTime == 0) {
            return 0;
        }
        return this.fermentationTime * i / this.fermentationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getProductScaled(100));
    }

    public ItemStack getFermentationStack() {
        return this.inventory.func_70301_a(0);
    }

    public ItemStack getFuelStack() {
        return this.inventory.func_70301_a(1);
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fuelBurnTime = j;
                break;
            }
            case 1: {
                this.fuelTotalTime = j;
                break;
            }
            case 2: {
                this.fermentationTime = j;
                break;
            }
            case 3: {
                this.fermentationTotalTime = j;
                break;
            }
            case 4: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 5: {
                this.resourceTank.quantity = j;
                break;
            }
            case 6: {
                this.resourceTank.liquidMeta = j;
                break;
            }
            case 7: {
                this.productTank.liquidId = j;
                break;
            }
            case 8: {
                this.productTank.quantity = j;
                break;
            }
            case 9: {
                this.productTank.liquidMeta = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fuelBurnTime);
        iCrafting.func_71112_a(container, 1, this.fuelTotalTime);
        iCrafting.func_71112_a(container, 2, this.fermentationTime);
        iCrafting.func_71112_a(container, 3, this.fermentationTotalTime);
        iCrafting.func_71112_a(container, 4, this.resourceTank.liquidId);
        iCrafting.func_71112_a(container, 5, this.resourceTank.quantity);
        iCrafting.func_71112_a(container, 6, this.resourceTank.liquidMeta);
        iCrafting.func_71112_a(container, 7, this.productTank.liquidId);
        iCrafting.func_71112_a(container, 8, this.productTank.quantity);
        iCrafting.func_71112_a(container, 9, this.productTank.liquidMeta);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        int inventorySlot;
        if (FuelManager.fermenterFuel.containsKey(stack.func_77973_b())) {
            inventorySlot = 1;
        } else if (RecipeManager.isResource(stack)) {
            inventorySlot = 0;
        } else if (LiquidHelper.isEmptyContainer(stack)) {
            inventorySlot = 3;
        } else {
            LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
            if (container != null && RecipeManager.isLiquidResource(container.stillLiquid)) {
                inventorySlot = 4;
            } else {
                return 0;
            }
        }
        return this.inventory.addStack(stack, inventorySlot, 1, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack product = null;
        if (this.inventory.func_70301_a(2) != null) {
            product = new ItemStack(this.inventory.func_70301_a((int)2).field_77993_c, 1, this.inventory.func_70301_a(2).func_77960_j());
            if (doRemove) {
                this.inventory.func_70298_a(2, 1);
            }
        }
        if (product != null) {
            return new ItemStack[]{product};
        }
        return new ItemStack[0];
    }

    @Override
    protected InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 2;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 0 && RecipeManager.isResource(itemstack)) {
            return true;
        }
        if (slotIndex == 4) {
            LiquidContainerData container = LiquidHelper.getLiquidContainer(itemstack);
            return container != null && RecipeManager.isLiquidResource(container.stillLiquid);
        }
        if (slotIndex == 3 && LiquidHelper.isEmptyContainer(itemstack)) {
            return true;
        }
        return slotIndex == 1 && FuelManager.fermenterFuel.containsKey(itemstack.func_77973_b());
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (!RecipeManager.isLiquidResource(resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    public LiquidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.drain(0, quantityMax, doEmpty);
    }

    public LiquidStack drain(int tankIndex, int quantityMax, boolean doEmpty) {
        if (tankIndex != 0) {
            return null;
        }
        return this.productTank.drain(quantityMax, doEmpty);
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank, this.productTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == this.getOrientation().getRotation(ForgeDirection.UP)) {
            return this.resourceTank;
        }
        if (direction == this.getOrientation().getRotation(ForgeDirection.DOWN)) {
            return this.productTank;
        }
        return null;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        res.add(ForestryTrigger.lowFuel10);
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements IFermenterManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(ItemStack resource, int fermentationValue, float modifier, LiquidStack output, LiquidStack liquid) {
            recipes.add(new Recipe(resource, fermentationValue, modifier, output, liquid));
        }

        @Override
        public void addRecipe(ItemStack resource, int fermentationValue, float modifier, LiquidStack output) {
            recipes.add(new Recipe(resource, fermentationValue, modifier, output, null));
        }

        public static Recipe findMatchingRecipe(ItemStack res, LiquidStack liqu) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(res, liqu)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResource(ItemStack resource) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (recipe.resource.func_77960_j() == Short.MAX_VALUE && recipe.resource.field_77993_c == resource.field_77993_c) {
                    return true;
                }
                if (!recipe.resource.func_77969_a(resource)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLiquidResource(LiquidStack liquid) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.liquid.isLiquidEqual(liquid)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLiquidProduct(LiquidStack liquid) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.output.isLiquidEqual(liquid)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            HashMap<ItemStack[], ItemStack[]> recipeList = new HashMap<ItemStack[], ItemStack[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ItemStack[]{recipe.resource, recipe.liquid.asItemStack()}, new ItemStack[]{recipe.output.asItemStack()});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final ItemStack resource;
        public final int fermentationValue;
        public final float modifier;
        public final LiquidStack output;
        public final LiquidStack liquid;

        public Recipe(ItemStack resource, int fermentationValue, float modifier, LiquidStack output, LiquidStack liquid) {
            this.resource = resource;
            this.fermentationValue = fermentationValue;
            this.modifier = modifier;
            this.output = output;
            this.liquid = liquid;
        }

        public boolean matches(ItemStack res, LiquidStack liqu) {
            if (res == null) {
                return false;
            }
            if (this.resource.field_77993_c != res.field_77993_c) {
                return false;
            }
            if (this.resource.func_77960_j() != Short.MAX_VALUE && this.resource.func_77960_j() != res.func_77960_j()) {
                return false;
            }
            if (this.liquid == null) {
                return true;
            }
            if (this.liquid != null && liqu == null) {
                return false;
            }
            if (!this.liquid.isLiquidEqual(liqu)) {
                return false;
            }
            return this.liquid.amount <= liqu.amount;
        }
    }
}

