/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.core.ITileStructure;
import forestry.api.farming.IFarmComponent;
import forestry.core.gadgets.BlockStructure;
import forestry.core.gadgets.StructureLogic;
import forestry.core.utils.Schemata;
import forestry.core.utils.Vect;
import forestry.farming.gadgets.TileFarm;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class StructureLogicFarm
extends StructureLogic {
    public static final String UID_FARM = "farm";
    public static final Schemata SCHEMATA_FARM_3x3 = new Schemata("farm3x3", 5, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FAAAF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-2, -3, -2);
    public static final Schemata SCHEMATA_FARM_4x3 = new Schemata("farm3x4", 6, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBABF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FAAAF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-2, -3, -3);
    public static final Schemata SCHEMATA_FARM_4x4 = new Schemata("farm4x4", 6, 6, 6, "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF", "FAAAAF", "FAAAAF", "FBBBBF", "FAAAAF", "FFFFFF", "FFFFFF", "FAAAAF", "FAAAAF", "FBAMBF", "FAAAAF", "FFFFFF", "FFFFFF", "FAAAAF", "FAAAAF", "FBAABF", "FAAAAF", "FFFFFF", "FFFFFF", "FAAAAF", "FAAAAF", "FBBBBF", "FAAAAF", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF", "FFFFFF").setOffsets(-3, -3, -3);
    public static final Schemata SCHEMATA_FARM_5x3 = new Schemata("farm3x5", 7, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBABF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBABF", "FAAAF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FAAAF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-3, -3, -2);
    public static final Schemata SCHEMATA_FARM_5x5 = new Schemata("farm5x5", 7, 6, 7, "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FAAAAAF", "FAAAAAF", "FBBBBBF", "FAAAAAF", "FFFFFFF", "FFFFFFF", "FAAAAAF", "FAAAAAF", "FBAAABF", "FAAAAAF", "FFFFFFF", "FFFFFFF", "FAAAAAF", "FAAAAAF", "FBAMABF", "FAAAAAF", "FFFFFFF", "FFFFFFF", "FAAAAAF", "FAAAAAF", "FBAAABF", "FAAAAAF", "FFFFFFF", "FFFFFFF", "FAAAAAF", "FAAAAAF", "FBBBBBF", "FAAAAAF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF").setOffsets(-3, -3, -3);
    public static HashSet brickIds = new HashSet();

    public StructureLogicFarm(ITileStructure structure) {
        super(UID_FARM, structure);
        this.schematas = new Schemata[]{SCHEMATA_FARM_3x3, SCHEMATA_FARM_4x3, SCHEMATA_FARM_5x3, SCHEMATA_FARM_5x5, SCHEMATA_FARM_4x4};
        this.metaOnValid.put(Schemata.EnumStructureBlock.BLOCK_B, 1);
    }

    @Override
    protected BlockStructure.EnumStructureState determineMasterState(Schemata schemata, boolean rotate) {
        Vect dimensions = schemata.getDimensions(rotate);
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (rotate) {
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < dimensions.x; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                block9: for (int k = 0; k < dimensions.z; ++k) {
                    int z;
                    int x = this.structureTile.field_70329_l + i + offsetX;
                    int y = this.structureTile.field_70330_m + j + schemata.getyOffset();
                    if (!this.structureTile.field_70331_k.func_72899_e(x, y, z = this.structureTile.field_70327_n + k + offsetZ)) {
                        return BlockStructure.EnumStructureState.INDETERMINATE;
                    }
                    Schemata.EnumStructureBlock required = schemata.getAt(i, j, k, rotate);
                    if (required == Schemata.EnumStructureBlock.ANY) continue;
                    TileEntity tile = this.structureTile.field_70331_k.func_72796_p(x, y, z);
                    int blockid = this.structureTile.field_70331_k.func_72798_a(x, y, z);
                    switch (required) {
                        case AIR: {
                            if (blockid == 0) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_A: {
                            if (tile == null || !(tile instanceof IFarmComponent)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if (((ITileStructure)tile).getTypeUID().equals(UID_FARM)) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_B: 
                        case MASTER: {
                            if (tile == null || !(tile instanceof TileFarm)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if (!((TileFarm)tile).hasFunction()) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_C: {
                            if (brickIds.contains(blockid)) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case FOREIGN: {
                            if (!(tile instanceof ITileStructure)) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        default: {
                            return BlockStructure.EnumStructureState.INDETERMINATE;
                        }
                    }
                }
            }
        }
        return BlockStructure.EnumStructureState.VALID;
    }

    static {
        brickIds.add(Block.field_72081_al.field_71990_ca);
        brickIds.add(Block.field_72007_bm.field_71990_ca);
        brickIds.add(Block.field_71957_Q.field_71990_ca);
        brickIds.add(Block.field_72033_bA.field_71990_ca);
        brickIds.add(Block.field_94339_ct.field_71990_ca);
    }
}

