/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.config.ForestryItem;
import forestry.mail.EnumAddressee;
import forestry.mail.EnumDeliveryState;
import forestry.mail.EnumPostage;
import forestry.mail.ILetter;
import forestry.mail.IPostOffice;
import forestry.mail.IPostalState;
import forestry.mail.IStamps;
import forestry.mail.ITradeStation;
import forestry.mail.MailAddress;
import forestry.mail.POBox;
import forestry.mail.TradeStation;
import forestry.mail.items.ItemLetter;
import forestry.plugins.PluginForestryMail;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class PostOffice
extends WorldSavedData
implements IPostOffice {
    public static final String SAVE_NAME = "ForestryMail";
    public static PostOffice cachedPostOffice;
    public static HashMap cachedPOBoxes;
    public static HashMap cachedTradeStations;
    private int[] collectedPostage = new int[EnumPostage.values().length];
    private LinkedHashMap activeTradeStations;

    public static boolean isValidPOBox(World world, String username) {
        return username.matches("^[a-zA-Z0-9]+$");
    }

    public static POBox getPOBox(World world, String username) {
        if (cachedPOBoxes.containsKey(username.toLowerCase(Locale.ENGLISH))) {
            return (POBox)((Object)cachedPOBoxes.get(username.toLowerCase(Locale.ENGLISH)));
        }
        POBox pobox = (POBox)world.func_72943_a(POBox.class, "POBox_" + username.toLowerCase(Locale.ENGLISH));
        if (pobox != null) {
            cachedPOBoxes.put(username.toLowerCase(Locale.ENGLISH), pobox);
        }
        return pobox;
    }

    public static POBox getOrCreatePOBox(World world, String username) {
        POBox pobox = PostOffice.getPOBox(world, username);
        if (pobox == null) {
            pobox = new POBox(username.toLowerCase(Locale.ENGLISH), true);
            world.func_72823_a("POBox_" + username.toLowerCase(Locale.ENGLISH), (WorldSavedData)pobox);
            pobox.func_76185_a();
            cachedPOBoxes.put(username.toLowerCase(Locale.ENGLISH), pobox);
            PluginForestryMail.proxy.setPOBoxInfo(world, username, pobox.getPOBoxInfo());
        }
        return pobox;
    }

    public static boolean isValidTradeMoniker(World world, String moniker) {
        return moniker.matches("^[a-zA-Z0-9]+$");
    }

    public static boolean isAvailableTradeMoniker(World world, String moniker) {
        return PostOffice.getTradeStation(world, moniker) == null;
    }

    public static TradeStation getTradeStation(World world, String moniker) {
        if (cachedTradeStations.containsKey(moniker)) {
            return (TradeStation)cachedTradeStations.get(moniker);
        }
        TradeStation trade = (TradeStation)world.func_72943_a(TradeStation.class, "TradePO_" + moniker);
        if (trade != null && trade.isValid()) {
            cachedTradeStations.put(moniker, trade);
            PostOffice.getPostOffice(world).registerTradeStation(trade);
            return trade;
        }
        return null;
    }

    public static TradeStation getOrCreateTradeStation(World world, String owner, String moniker) {
        TradeStation trade = PostOffice.getTradeStation(world, moniker);
        if (trade == null) {
            trade = new TradeStation(owner, moniker, true);
            world.func_72823_a("TradePO_" + moniker, (WorldSavedData)trade);
            trade.func_76185_a();
            cachedTradeStations.put(moniker, trade);
            PostOffice.getPostOffice(world).registerTradeStation(trade);
        }
        return trade;
    }

    public static void deleteTradeStation(World world, String moniker) {
        TradeStation trade = PostOffice.getTradeStation(world, moniker);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        cachedTradeStations.remove(moniker);
        PostOffice.getPostOffice(world).deregisterTradeStation(trade);
        File file = world.func_72860_G().func_75758_b(trade.field_76190_i);
        file.delete();
    }

    public static IPostOffice getPostOffice(World world) {
        if (cachedPostOffice != null) {
            return cachedPostOffice;
        }
        PostOffice office = (PostOffice)world.func_72943_a(PostOffice.class, SAVE_NAME);
        if (office == null) {
            office = new PostOffice();
            world.func_72823_a(SAVE_NAME, (WorldSavedData)office);
        }
        cachedPostOffice = office;
        return office;
    }

    public PostOffice(String s) {
        super(s);
    }

    public PostOffice() {
        super(SAVE_NAME);
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            if (!nbttagcompound.func_74764_b("CPS" + i)) continue;
            this.collectedPostage[i] = nbttagcompound.func_74762_e("CPS" + i);
        }
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            nbttagcompound.func_74768_a("CPS" + i, this.collectedPostage[i]);
        }
    }

    @Override
    public LinkedHashMap getActiveTradeStations(World world) {
        if (this.activeTradeStations == null) {
            this.refreshActiveTradeStations(world);
        }
        return this.activeTradeStations;
    }

    private void refreshActiveTradeStations(World world) {
        this.activeTradeStations = new LinkedHashMap();
        File file = world.func_72860_G().func_75758_b("dummy").getParentFile();
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        for (String str : file.list()) {
            TradeStation trade;
            if (!str.startsWith("TradePO_") || !str.endsWith(".dat") || (trade = PostOffice.getTradeStation(world, str.replace("TradePO_", "").replace(".dat", ""))) == null) continue;
            this.registerTradeStation(trade);
        }
    }

    @Override
    public void registerTradeStation(ITradeStation trade) {
        if (this.activeTradeStations == null) {
            return;
        }
        if (!this.activeTradeStations.containsKey(trade.getMoniker())) {
            this.activeTradeStations.put(trade.getMoniker(), trade);
        }
    }

    @Override
    public void deregisterTradeStation(ITradeStation trade) {
        if (this.activeTradeStations == null) {
            return;
        }
        this.activeTradeStations.remove(trade.getMoniker());
    }

    @Override
    public ItemStack getAnyStamp(int max) {
        return this.getAnyStamp(EnumPostage.values(), max);
    }

    @Override
    public ItemStack getAnyStamp(EnumPostage postage, int max) {
        return this.getAnyStamp(new EnumPostage[]{postage}, max);
    }

    @Override
    public ItemStack getAnyStamp(EnumPostage[] postages, int max) {
        for (EnumPostage postage : postages) {
            int collected = 0;
            if (this.collectedPostage[postage.ordinal()] <= 0) continue;
            if (max >= this.collectedPostage[postage.ordinal()]) {
                collected = this.collectedPostage[postage.ordinal()];
                this.collectedPostage[postage.ordinal()] = 0;
            } else {
                collected = max;
                int n = postage.ordinal();
                this.collectedPostage[n] = this.collectedPostage[n] - max;
            }
            if (collected <= 0) continue;
            return new ItemStack(ForestryItem.stamps, collected, postage.ordinal() - 1);
        }
        return null;
    }

    @Override
    public IPostalState lodgeLetter(World world, ItemStack itemstack, boolean doLodge) {
        ILetter letter = ItemLetter.getLetter(itemstack);
        if (letter.isProcessed()) {
            return EnumDeliveryState.ALREADY_MAILED;
        }
        if (!letter.isPostPaid()) {
            return EnumDeliveryState.NOT_POSTPAID;
        }
        if (!letter.isMailable()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        for (MailAddress address : letter.getRecipients()) {
            if (address.isPlayer()) {
                state = this.storeInPOBox(world, address, itemstack, doLodge);
                continue;
            }
            if (address.getType() != EnumAddressee.TRADER) continue;
            state = this.handleTradeLetter(world, address, itemstack, doLodge);
        }
        if (!state.isOk()) {
            return state;
        }
        this.collectPostage(letter.getPostage());
        this.func_76185_a();
        return EnumDeliveryState.OK;
    }

    private IPostalState handleTradeLetter(World world, MailAddress address, ItemStack letterstack, boolean doLodge) {
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        TradeStation trade = PostOffice.getTradeStation(world, address.getIdentifier());
        if (trade == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        state = trade.handleLetter(world, address, letterstack, doLodge);
        return state;
    }

    private EnumDeliveryState storeInPOBox(World world, MailAddress address, ItemStack letterstack, boolean doLodge) {
        if (!address.isPlayer()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        POBox pobox = PostOffice.getPOBox(world, address.getIdentifier());
        if (pobox == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        if (!pobox.storeLetter(letterstack.func_77946_l())) {
            return EnumDeliveryState.MAILBOX_FULL;
        }
        PluginForestryMail.proxy.setPOBoxInfo(world, address.getIdentifier(), pobox.getPOBoxInfo());
        return EnumDeliveryState.OK;
    }

    @Override
    public void collectPostage(ItemStack[] stamps) {
        for (ItemStack stamp : stamps) {
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps)) continue;
            EnumPostage postage = ((IStamps)stamp.func_77973_b()).getPostage(stamp);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] + stamp.field_77994_a;
        }
    }

    static {
        cachedPOBoxes = new HashMap();
        cachedTradeStations = new HashMap();
    }
}

