/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.ForestryAPI;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumDeliveryState;
import forestry.mail.ILetter;
import forestry.mail.IMailContainer;
import forestry.mail.IPostalState;
import forestry.mail.PostOffice;
import forestry.mail.items.ItemLetter;
import forestry.plugins.PluginForestryMail;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class MachineMailbox
extends TileBase
implements IMailContainer,
ISpecialInventory,
ISidedInventory {
    private boolean isLinked = false;
    private static int[] slotIndices;

    public MachineMailbox() {
        this.setHints((String[])Config.hints.get("mailbox"));
    }

    @Override
    public String func_70303_b() {
        return "mail.0";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        ItemStack held = player.func_71045_bC();
        if (ItemLetter.isLetter(held)) {
            IPostalState result = this.tryDispatchLetter(held, true);
            if (!result.isOk()) {
                player.func_71035_c(StringUtil.localize("chat.mail." + result.getIdentifier()));
            } else {
                --held.field_77994_a;
            }
        } else {
            player.openGui(ForestryAPI.instance, GuiId.MailboxGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("LNK", this.isLinked);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.isLinked = nbttagcompound.func_74767_n("LNK");
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked) {
            this.getOrCreateMailInventory();
            this.isLinked = true;
        }
    }

    public IInventory getOrCreateMailInventory() {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return new InventoryAdapter(84, "Letters");
        }
        if (this.getOwnerName() == null || this.getOwnerName().isEmpty()) {
            return new InventoryAdapter(84, "Letters");
        }
        return PostOffice.getOrCreatePOBox(this.field_70331_k, this.getOwnerName());
    }

    private IPostalState tryDispatchLetter(ItemStack letterstack, boolean dispatchLetter) {
        ILetter letter = ItemLetter.getLetter(letterstack);
        IPostalState result = letter != null ? PostOffice.getPostOffice(this.field_70331_k).lodgeLetter(this.field_70331_k, letterstack, dispatchLetter) : EnumDeliveryState.NOT_MAILABLE;
        return result;
    }

    @Override
    public boolean hasMail() {
        IInventory mailInventory = this.getOrCreateMailInventory();
        for (int i = 0; i < mailInventory.func_70302_i_(); ++i) {
            if (mailInventory.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(PluginForestryMail.triggerHasMail);
        return res;
    }

    public int[] getSizeInventorySide(int side) {
        IInventory inventory = this.getOrCreateMailInventory();
        if (slotIndices == null) {
            slotIndices = new int[inventory.func_70302_i_()];
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                MachineMailbox.slotIndices[i] = i;
            }
        }
        return slotIndices;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (!ItemLetter.isLetter(stack)) {
            return 0;
        }
        IPostalState result = this.tryDispatchLetter(stack, doAdd);
        if (!result.isOk()) {
            return 0;
        }
        return 1;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack product = null;
        IInventory mailInventory = this.getOrCreateMailInventory();
        for (int i = 0; i < mailInventory.func_70302_i_(); ++i) {
            ItemStack slotStack = mailInventory.func_70301_a(i);
            if (slotStack == null) continue;
            product = slotStack;
            if (!doRemove) break;
            mailInventory.func_70299_a(i, null);
            break;
        }
        if (product != null) {
            return new ItemStack[]{product};
        }
        return new ItemStack[0];
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int var1) {
        return null;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

