/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.recipes.RefineryRecipe;
import buildcraft.api.transport.IPipe;
import forestry.api.core.IPlugin;
import forestry.api.core.PluginInfo;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.gadgets.TileForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="BC3", name="BuildCraft 3", author="SirSengir", url="http://forestry.sengir.net/", description="Compatibility plugin for BuildCraft 3.")
public class PluginBuildCraft
implements IPlugin,
ITriggerProvider {
    public static PluginBuildCraft instance;
    public static Configuration config;
    public static boolean ignore;
    public static Item wrench;
    public static Item stoneGear;
    public static Item pipeWaterproof;
    public static Block oilStill;
    public static Block oilMoving;
    public static Item fuel;

    public PluginBuildCraft() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("BuildCraft|Core") && Proxies.common.isModLoaded("BuildCraft|Transport");
    }

    @Override
    public void doInit() {
        config = Config.config;
        Property buildcraftignore = config.get("buildcraft.ignore", "common", false);
        buildcraftignore.Comment = "set to true to ignore buildcraft";
        ignore = Boolean.parseBoolean(buildcraftignore.Value);
        IronEngineCoolant.coolants.add(new IronEngineCoolant(LiquidHelper.getLiquid("ice", 1), 10.0f));
        this.addIronEngineFuel(LiquidHelper.getLiquid("ethanol", 1), 4, 60000);
        this.addRefineryRecipe(LiquidHelper.getLiquid("biomass", 4), null, LiquidHelper.getLiquid("ethanol", 1), 10, 1);
        ActionManager.registerTriggerProvider(this);
        this.initStoneGear();
        this.initWaterproof();
        this.initLiquids();
    }

    @Override
    public void postInit() {
    }

    private void initLiquids() {
        try {
            oilStill = (Block)Class.forName("buildcraft.BuildCraftEnergy").getField("oilStill").get(null);
            oilMoving = (Block)Class.forName("buildcraft.BuildCraftEnergy").getField("oilMoving").get(null);
            fuel = (Item)Class.forName("buildcraft.BuildCraftEnergy").getField("fuel").get(null);
        }
        catch (Exception ex) {
            Proxies.log.fine("Oil or fuel not found.");
            return;
        }
        LiquidHelper.injectWaxContainer("Oil", 1000, new ItemStack(ForestryItem.waxCapsuleOil), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectWaxContainer("Fuel", 1000, new ItemStack(ForestryItem.waxCapsuleFuel), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectRefractoryContainer("Oil", 1000, new ItemStack(ForestryItem.refractoryOil), new ItemStack(ForestryItem.refractoryEmpty));
        LiquidHelper.injectRefractoryContainer("Fuel", 1000, new ItemStack(ForestryItem.refractoryFuel), new ItemStack(ForestryItem.refractoryEmpty));
        LiquidHelper.injectTinContainer("Oil", 1000, new ItemStack(ForestryItem.canOil), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectTinContainer("Fuel", 1000, new ItemStack(ForestryItem.canFuel), new ItemStack(ForestryItem.canEmpty));
    }

    private void addIronEngineFuel(LiquidStack fuel, int powerPerCycle, int totalBurningTime) {
        IronEngineFuel.fuels.add(new IronEngineFuel(fuel, (float)powerPerCycle, totalBurningTime));
    }

    private void addRefineryRecipe(LiquidStack ingredient1, LiquidStack ingredient2, LiquidStack result, int energy, int delay) {
        RefineryRecipe.registerRefineryRecipe(new RefineryRecipe(ingredient1, ingredient2, result, energy, delay));
    }

    private void initStoneGear() {
        try {
            stoneGear = (Item)Class.forName("buildcraft.BuildCraftCore").getField("stoneGearItem").get(null);
        }
        catch (Exception ex) {
            Proxies.log.fine("No BuildCraft stone gear found.");
            return;
        }
    }

    private void initWaterproof() {
        try {
            pipeWaterproof = (Item)Class.forName("buildcraft.BuildCraftTransport").getField("pipeWaterproof").get(null);
        }
        catch (Exception ex) {
            Proxies.log.fine("No BuildCraft pipe waterproof found.");
            return;
        }
        Proxies.common.addRecipe(new ItemStack(pipeWaterproof), new Object[]{"#", Character.valueOf('#'), ForestryItem.beeswax});
    }

    public float invokeUseEnergyMethod(IPowerProvider powerProvider, float min, float max, boolean doUse) {
        return powerProvider.useEnergy(min, max, doUse);
    }

    public void invokeReceiveEnergyMethod(IPowerProvider powerProvider, float quantity) {
        powerProvider.receiveEnergy(quantity, ForgeDirection.WEST);
    }

    @Override
    public LinkedList getPipeTriggers(IPipe pipe) {
        return null;
    }

    @Override
    public LinkedList getNeighborTriggers(Block block, TileEntity tile) {
        if (tile instanceof TileForestry) {
            return ((TileForestry)tile).getCustomTriggers();
        }
        return null;
    }

    @Override
    public void preInit() {
    }
}

