/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.PluginInfo;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.arboriculture.CommandSpawnForest;
import forestry.arboriculture.CommandSpawnTree;
import forestry.arboriculture.CommandTreekeepingMode;
import forestry.arboriculture.EventHandlerArboriculture;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.FruitProviderPod;
import forestry.arboriculture.FruitProviderRandom;
import forestry.arboriculture.FruitProviderRipening;
import forestry.arboriculture.GuiHandlerArboriculture;
import forestry.arboriculture.PacketHandlerArboriculture;
import forestry.arboriculture.VillageHandlerArboriculture;
import forestry.arboriculture.WoodType;
import forestry.arboriculture.gadgets.BlockArbFence;
import forestry.arboriculture.gadgets.BlockArbStairs;
import forestry.arboriculture.gadgets.BlockFruitPod;
import forestry.arboriculture.gadgets.BlockLeaves;
import forestry.arboriculture.gadgets.BlockLog;
import forestry.arboriculture.gadgets.BlockPlanks;
import forestry.arboriculture.gadgets.BlockSapling;
import forestry.arboriculture.gadgets.BlockSlab;
import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.gadgets.TileStairs;
import forestry.arboriculture.genetics.AlleleFruit;
import forestry.arboriculture.genetics.AlleleGrowth;
import forestry.arboriculture.genetics.AlleleLeafEffectNone;
import forestry.arboriculture.genetics.AlleleTreeSpecies;
import forestry.arboriculture.genetics.BranchTrees;
import forestry.arboriculture.genetics.BreedingManager;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.arboriculture.genetics.GrowthProviderTropical;
import forestry.arboriculture.genetics.Mutation;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemGrafter;
import forestry.arboriculture.items.ItemStairs;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.arboriculture.items.ItemWoodBlock;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.worldgen.WorldGenAcacia;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.arboriculture.worldgen.WorldGenBaobab;
import forestry.arboriculture.worldgen.WorldGenBirch;
import forestry.arboriculture.worldgen.WorldGenCherry;
import forestry.arboriculture.worldgen.WorldGenChestnut;
import forestry.arboriculture.worldgen.WorldGenDate;
import forestry.arboriculture.worldgen.WorldGenEbony;
import forestry.arboriculture.worldgen.WorldGenGiganteum;
import forestry.arboriculture.worldgen.WorldGenGreenheart;
import forestry.arboriculture.worldgen.WorldGenJungle;
import forestry.arboriculture.worldgen.WorldGenKapok;
import forestry.arboriculture.worldgen.WorldGenLarch;
import forestry.arboriculture.worldgen.WorldGenLemon;
import forestry.arboriculture.worldgen.WorldGenLime;
import forestry.arboriculture.worldgen.WorldGenMahoe;
import forestry.arboriculture.worldgen.WorldGenMahogany;
import forestry.arboriculture.worldgen.WorldGenMaple;
import forestry.arboriculture.worldgen.WorldGenOak;
import forestry.arboriculture.worldgen.WorldGenPapaya;
import forestry.arboriculture.worldgen.WorldGenPine;
import forestry.arboriculture.worldgen.WorldGenPlum;
import forestry.arboriculture.worldgen.WorldGenPoplar;
import forestry.arboriculture.worldgen.WorldGenSequoia;
import forestry.arboriculture.worldgen.WorldGenSpruce;
import forestry.arboriculture.worldgen.WorldGenTeak;
import forestry.arboriculture.worldgen.WorldGenWalnut;
import forestry.arboriculture.worldgen.WorldGenWenge;
import forestry.arboriculture.worldgen.WorldGenWillow;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Allele;
import forestry.core.genetics.FruitFamily;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemFruit;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.plugins.NativePlugin;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", description="Adds additional tree species and products.")
public class PluginForestryArboriculture
extends NativePlugin
implements IFuelHandler {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ClientProxyArboriculture", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static String treekeepingMode;
    public static int modelIdSaplings;
    public static int modelIdLeaves;
    public static int modelIdFences;
    public static int modelIdPods;

    @Override
    public boolean isAvailable() {
        return !Config.disableArboriculture;
    }

    @Override
    public void preInit() {
        int i;
        super.preInit();
        ForestryBlock.log1 = new BlockLog(Config.getOrCreateBlockIdProperty("log1", 1388), BlockLog.LogCat.CAT0).func_71864_b("for.log1");
        Item.field_77698_e[ForestryBlock.log1.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.log1.field_71990_ca] = new ItemWoodBlock(ForestryBlock.log1.field_71990_ca - 256, "for.log1");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log1, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log1.field_71990_ca + "@" + i));
        }
        ForestryBlock.log2 = new BlockLog(Config.getOrCreateBlockIdProperty("log2", 1389), BlockLog.LogCat.CAT1).func_71864_b("for.log2");
        Item.field_77698_e[ForestryBlock.log2.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.log2.field_71990_ca] = new ItemWoodBlock(ForestryBlock.log2.field_71990_ca - 256, "for.log2");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log2, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log2.field_71990_ca + "@" + i));
        }
        ForestryBlock.log3 = new BlockLog(Config.getOrCreateBlockIdProperty("log3", 1390), BlockLog.LogCat.CAT2).func_71864_b("for.log3");
        Item.field_77698_e[ForestryBlock.log3.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.log3.field_71990_ca] = new ItemWoodBlock(ForestryBlock.log3.field_71990_ca - 256, "for.log3");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log3, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log3.field_71990_ca + "@" + i));
        }
        ForestryBlock.log4 = new BlockLog(Config.getOrCreateBlockIdProperty("log4", 1391), BlockLog.LogCat.CAT3).func_71864_b("for.log4");
        Item.field_77698_e[ForestryBlock.log4.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.log4.field_71990_ca] = new ItemWoodBlock(ForestryBlock.log4.field_71990_ca - 256, "for.log4");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log4, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log4.field_71990_ca + "@" + i));
        }
        ForestryBlock.log5 = new BlockLog(Config.getOrCreateBlockIdProperty("log5", 1411), BlockLog.LogCat.CAT4).func_71864_b("for.log5");
        Item.field_77698_e[ForestryBlock.log5.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.log5.field_71990_ca] = new ItemWoodBlock(ForestryBlock.log5.field_71990_ca - 256, "for.log5");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log5, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log5.field_71990_ca + "@" + i));
        }
        ForestryBlock.log6 = new BlockLog(Config.getOrCreateBlockIdProperty("log6", 1412), BlockLog.LogCat.CAT5).func_71864_b("for.log6");
        Item.field_77698_e[ForestryBlock.log6.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.log6.field_71990_ca] = new ItemWoodBlock(ForestryBlock.log6.field_71990_ca - 256, "for.log6");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log6, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log6.field_71990_ca + "@" + i));
        }
        ForestryBlock.log7 = new BlockLog(Config.getOrCreateBlockIdProperty("log7", 1413), BlockLog.LogCat.CAT6).func_71864_b("for.log7");
        Item.field_77698_e[ForestryBlock.log7.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.log7.field_71990_ca] = new ItemWoodBlock(ForestryBlock.log7.field_71990_ca - 256, "for.log7");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log7, (String)"axe", (int)0);
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log1, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log2, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log3, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log4, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log5, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log6, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log7, 1, Short.MAX_VALUE));
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log1.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log2.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log3.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log4.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log5.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log6.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        ForestryBlock.planks1 = new BlockPlanks(Config.getOrCreateBlockIdProperty("planks", 1380), BlockPlanks.PlankCat.CAT0).func_71864_b("for.planks");
        Item.field_77698_e[ForestryBlock.planks1.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.planks1.field_71990_ca] = new ItemWoodBlock(ForestryBlock.planks1.field_71990_ca - 256, "for.planks");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.planks1, (String)"axe", (int)0);
        ForestryBlock.planks2 = new BlockPlanks(Config.getOrCreateBlockIdProperty("planks2", 1417), BlockPlanks.PlankCat.CAT1).func_71864_b("for.planks2");
        Item.field_77698_e[ForestryBlock.planks2.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.planks2.field_71990_ca] = new ItemWoodBlock(ForestryBlock.planks2.field_71990_ca - 256, "for.planks2");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.planks2, (String)"axe", (int)0);
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ForestryBlock.planks1, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ForestryBlock.planks2, 1, Short.MAX_VALUE));
        for (i = 0; i < 16; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.planks1.field_71990_ca + "@" + i));
        }
        ForestryBlock.slabs1 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs1", 1386), BlockSlab.SlabCat.CAT0).func_71864_b("for.slabs1");
        Item.field_77698_e[ForestryBlock.slabs1.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.slabs1.field_71990_ca] = new ItemWoodBlock(ForestryBlock.slabs1.field_71990_ca - 256, "for.slabs1");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.slabs1, (String)"axe", (int)0);
        ForestryBlock.slabs2 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs2", 1387), BlockSlab.SlabCat.CAT1).func_71864_b("for.slabs2");
        Item.field_77698_e[ForestryBlock.slabs2.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.slabs2.field_71990_ca] = new ItemWoodBlock(ForestryBlock.slabs2.field_71990_ca - 256, "for.slabs2");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.slabs2, (String)"axe", (int)0);
        ForestryBlock.slabs3 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs3", 1415), BlockSlab.SlabCat.CAT2).func_71864_b("for.slabs3");
        Item.field_77698_e[ForestryBlock.slabs3.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.slabs3.field_71990_ca] = new ItemWoodBlock(ForestryBlock.slabs3.field_71990_ca - 256, "for.slabs3");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.slabs3, (String)"axe", (int)0);
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(ForestryBlock.slabs1, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(ForestryBlock.slabs2, 1, Short.MAX_VALUE));
        ForestryBlock.fences1 = new BlockArbFence(Config.getOrCreateBlockIdProperty("fences", 1394), BlockArbFence.FenceCat.CAT0).func_71864_b("for.fences");
        Item.field_77698_e[ForestryBlock.fences1.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.fences1.field_71990_ca] = new ItemWoodBlock(ForestryBlock.fences1.field_71990_ca - 256, "for.fences");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.fences1, (String)"axe", (int)0);
        ForestryBlock.fences2 = new BlockArbFence(Config.getOrCreateBlockIdProperty("fences2", 1418), BlockArbFence.FenceCat.CAT1).func_71864_b("for.fences2");
        Item.field_77698_e[ForestryBlock.fences2.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.fences2.field_71990_ca] = new ItemWoodBlock(ForestryBlock.fences2.field_71990_ca - 256, "for.fences2");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.fences2, (String)"axe", (int)0);
        ForestryBlock.stairs = new BlockArbStairs(Config.getOrCreateBlockIdProperty("stairs", 1396), ForestryBlock.planks1, 0).func_71864_b("for.stairs");
        Item.field_77698_e[ForestryBlock.stairs.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.stairs.field_71990_ca] = new ItemStairs(ForestryBlock.stairs.field_71990_ca - 256, "for.stairs");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.stairs, (String)"axe", (int)0);
        ForestryBlock.saplingGE = new BlockSapling(Config.getOrCreateBlockIdProperty("saplingGE", 1392)).func_71864_b("saplingGE");
        Item.field_77698_e[ForestryBlock.saplingGE.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.saplingGE.field_71990_ca] = new ItemForestryBlock(ForestryBlock.saplingGE.field_71990_ca - 256, "saplingGE");
        ForestryBlock.leaves = new BlockLeaves(Config.getOrCreateBlockIdProperty("leaves", 1393)).func_71864_b("leaves");
        Item.field_77698_e[ForestryBlock.leaves.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.leaves.field_71990_ca] = new ItemForestryBlock(ForestryBlock.leaves.field_71990_ca - 256, "leaves");
        ForestryBlock.pods = new BlockFruitPod(Config.getOrCreateBlockIdProperty("pods", 1410)).func_71864_b("for.pods");
        Item.field_77698_e[ForestryBlock.pods.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.pods.field_71990_ca] = new ItemForestryBlock(ForestryBlock.pods.field_71990_ca - 256, "for.pods");
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        GameRegistry.registerTileEntity(TileStairs.class, (String)"forestry.Stairs");
        GameRegistry.registerTileEntity(TileFruitPod.class, (String)"forestry.Pods");
        TreeManager.treeInterface = new TreeHelper();
        TreeManager.breedingManager = new BreedingManager();
        proxy.initializeRendering();
        this.createAlleles();
    }

    @Override
    public void doInit() {
        super.doInit();
        proxy.addLocalizations();
        this.createMutations();
        this.registerTemplates();
        this.registerErsatzGenomes();
        TreeManager.breedingManager.registerTreekeepingMode(TreekeepingMode.easy);
        TreeManager.breedingManager.registerTreekeepingMode(TreekeepingMode.normal);
        TreeManager.breedingManager.registerTreekeepingMode(TreekeepingMode.hard);
        TreeManager.breedingManager.registerTreekeepingMode(TreekeepingMode.hardcore);
        TreeManager.breedingManager.registerTreekeepingMode(TreekeepingMode.insane);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerArboriculture());
        VillagerRegistry.instance().registerVillagerType(81, "/gfx/forestry/entities/lumberjack.png");
        VillagerRegistry.instance().registerVillageTradeHandler(81, (VillagerRegistry.IVillageTradeHandler)new VillageHandlerArboriculture());
    }

    @Override
    protected void registerItems() {
        ForestryItem.sapling = new ItemGermlingGE(Config.getOrCreateItemIdProperty("sapling", 13128), EnumGermlingType.SAPLING);
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(ForestryItem.sapling, 1, -1));
        ForestryItem.treealyzer = new ItemTreealyzer(Config.getOrCreateItemIdProperty("treealyzer", 13129)).func_77655_b("treealyzer");
        ForestryItem.grafter = new ItemGrafter(Config.getOrCreateItemIdProperty("grafter", 13131), 4).func_77655_b("grafter");
        ForestryItem.grafterProven = new ItemGrafter(Config.getOrCreateItemIdProperty("grafterProven", 13132), 149).func_77655_b("grafterProven");
    }

    @Override
    protected void registerBackpackItems() {
        if (BackpackManager.backpackItems == null) {
            return;
        }
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log1, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log2, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log3, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log4, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log5, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log6, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log7, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryItem.sapling, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryItem.fruits, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.stairs, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.slabs1, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.slabs2, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.slabs3, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.fences1, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.fences2, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.planks1, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.planks2, 1, Short.MAX_VALUE));
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        ItemStack stairs;
        NBTTagCompound compound;
        WoodType type;
        int i;
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks1, 4, i), new Object[]{new ItemStack(ForestryBlock.log1, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks1, 4, 4 + i), new Object[]{new ItemStack(ForestryBlock.log2, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks1, 4, 8 + i), new Object[]{new ItemStack(ForestryBlock.log3, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks1, 4, 12 + i), new Object[]{new ItemStack(ForestryBlock.log4, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks2, 4, i), new Object[]{new ItemStack(ForestryBlock.log5, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks2, 4, 4 + i), new Object[]{new ItemStack(ForestryBlock.log6, 1, i)});
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ItemStack(ForestryBlock.slabs1, 6, i), new Object[]{"###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks1, 1, i)});
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ItemStack(ForestryBlock.slabs2, 6, i), new Object[]{"###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks1, 1, 8 + i)});
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ItemStack(ForestryBlock.slabs3, 6, i), new Object[]{"###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks2, 1, i)});
        }
        for (i = 0; i < 16; ++i) {
            Proxies.common.addRecipe(new ItemStack(ForestryBlock.fences1, 4, i), new Object[]{"###", "# #", Character.valueOf('#'), new ItemStack(ForestryBlock.planks1, 1, i)});
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ItemStack(ForestryBlock.fences2, 4, i), new Object[]{"###", "# #", Character.valueOf('#'), new ItemStack(ForestryBlock.planks2, 1, i)});
        }
        RecipeManagers.carpenterManager.addRecipe(100, new LiquidStack(Block.field_71943_B.field_71990_ca, 2000), null, new ItemStack(ForestryItem.treealyzer), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), Block.field_72003_bq, Character.valueOf('X'), "ingotCopper", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('D'), Item.field_77702_n});
        RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.CHERRY.ordinal())}, new LiquidStack(ForestryItem.liquidSeedOil, 5 * GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")), new ItemStack(ForestryItem.mulch), 5);
        RecipeManagers.squeezerManager.addRecipe(60, new ItemStack[]{new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.WALNUT.ordinal())}, new LiquidStack(ForestryItem.liquidSeedOil, 18 * GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")), new ItemStack(ForestryItem.mulch), 5);
        RecipeManagers.squeezerManager.addRecipe(70, new ItemStack[]{new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.CHESTNUT.ordinal())}, new LiquidStack(ForestryItem.liquidSeedOil, 22 * GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")), new ItemStack(ForestryItem.mulch), 2);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.LEMON.ordinal())}, new LiquidStack(ForestryItem.liquidJuice, GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") * 2), new ItemStack(ForestryItem.mulch), (int)Math.floor((float)GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple") * 0.5f));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.PLUM.ordinal())}, new LiquidStack(ForestryItem.liquidJuice, (int)Math.floor((float)GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") * 0.5f)), new ItemStack(ForestryItem.mulch), GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple") * 3);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.PAPAYA.ordinal())}, new LiquidStack(ForestryItem.liquidJuice, GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") * 3), new ItemStack(ForestryItem.mulch), (int)Math.floor((float)GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple") * 0.5f));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.DATES.ordinal())}, new LiquidStack(ForestryItem.liquidJuice, (int)Math.floor((double)GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") * 0.25)), new ItemStack(ForestryItem.mulch), (int)Math.floor(GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple")));
        RecipeUtil.injectLeveledRecipe(new ItemStack(ForestryItem.sapling), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), new ItemStack(ForestryItem.liquidBiomass));
        for (i = 0; i < 16; ++i) {
            type = WoodType.VALUES[i];
            compound = new NBTTagCompound("tag");
            type.saveToCompound(compound);
            stairs = new ItemStack(ForestryBlock.stairs, 4, 0);
            stairs.func_77982_d(compound);
            Proxies.common.addRecipe(stairs, new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks1, 1, i)});
        }
        for (i = 0; i < 8; ++i) {
            type = WoodType.VALUES[16 + i];
            compound = new NBTTagCompound("tag");
            type.saveToCompound(compound);
            stairs = new ItemStack(ForestryBlock.stairs, 4, 0);
            stairs.func_77982_d(compound);
            Proxies.common.addRecipe(stairs, new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks2, 1, i)});
        }
        Proxies.common.addRecipe(new ItemStack(ForestryItem.grafter), new Object[]{"  B", " # ", "#  ", Character.valueOf('B'), "ingotBronze", Character.valueOf('#'), Item.field_77669_D});
    }

    private void createAlleles() {
        IClassification angiosperms = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "angiosperms", "Angiosperms");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(angiosperms);
        IClassification pinophyta = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "pinophyta", "Pinophyta");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(pinophyta);
        IClassification magnoliophyta = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "magnoliophyta", "Magnoliophyta");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(magnoliophyta);
        IClassification rosids = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "rosids", "Rosids");
        angiosperms.addMemberGroup(rosids);
        IClassification asterids = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "asterids", "Asterids");
        angiosperms.addMemberGroup(asterids);
        IClassification pinopsida = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "pinopsida", "Pinopsida");
        pinophyta.addMemberGroup(pinopsida);
        IClassification magnoliopsida = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "magnoliopsida", "Magnoliopsida");
        pinophyta.addMemberGroup(magnoliopsida);
        IClassification fabales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fabales", "Fabales");
        rosids.addMemberGroup(fabales);
        IClassification rosales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "rosales", "Rosales");
        rosids.addMemberGroup(rosales);
        IClassification fagales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fagales", "Fagales");
        rosids.addMemberGroup(fagales);
        IClassification malvales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malvales", "Malvales");
        rosids.addMemberGroup(malvales);
        IClassification malpighiales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malpighiales", "Malpighiales");
        rosids.addMemberGroup(malpighiales);
        IClassification ericales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "ericales", "Ericales");
        asterids.addMemberGroup(ericales);
        IClassification lamiales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "lamiales", "Lamiales");
        asterids.addMemberGroup(lamiales);
        IClassification pinales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "pinales", "Pinales");
        pinopsida.addMemberGroup(pinales);
        IClassification laurales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "laurales", "Laurales");
        rosids.addMemberGroup(laurales);
        IClassification sapindales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "sapindales", "Sapindales");
        rosids.addMemberGroup(sapindales);
        IClassification brassicales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "brassicales", "Brassicales");
        rosids.addMemberGroup(brassicales);
        IClassification betulaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "betulaceae", "Betulaceae");
        fagales.addMemberGroup(betulaceae);
        IClassification fagaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fagaceae", "Fagaceae");
        fagales.addMemberGroup(fagaceae);
        IClassification juglandaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "juglandaceae", "Juglandaceae");
        fagales.addMemberGroup(juglandaceae);
        IClassification malvaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "malvaceae", "Malvaceae");
        malvales.addMemberGroup(malvaceae);
        IClassification dipterocarpaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "dipterocarpaceae", "Dipterocarpaceae");
        malvales.addMemberGroup(dipterocarpaceae);
        IClassification pinaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "pinaceae", "Pinaceae");
        pinales.addMemberGroup(pinaceae);
        IClassification cupressaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "cupressaceae", "Cupressaceae");
        pinales.addMemberGroup(cupressaceae);
        IClassification lamiaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lamiaceae", "Lamiaceae");
        lamiales.addMemberGroup(lamiaceae);
        IClassification ebenaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "ebenaceae", "Ebenaceae");
        ericales.addMemberGroup(ebenaceae);
        IClassification fabaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fabaceae", "Fabaceae");
        ericales.addMemberGroup(fabaceae);
        IClassification rosaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rosaceae", "Rosaceae");
        rosales.addMemberGroup(rosaceae);
        IClassification salicaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "salicaceae", "Salicaceae");
        malpighiales.addMemberGroup(salicaceae);
        IClassification lauraceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lauraceae", "Lauraceae");
        malpighiales.addMemberGroup(lauraceae);
        IClassification rutaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rutaceae", "Rutaceae");
        sapindales.addMemberGroup(rutaceae);
        IClassification sapindaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "sapindaceae", "Sapindaceae");
        sapindales.addMemberGroup(sapindaceae);
        IClassification caricaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "caricaceae", "Caricaceae");
        brassicales.addMemberGroup(caricaceae);
        BranchTrees quercus = new BranchTrees("quercus", "Quercus");
        fagaceae.addMemberGroup(quercus);
        BranchTrees castanea = new BranchTrees("castanea", "Castanea");
        fagaceae.addMemberGroup(castanea);
        BranchTrees betula = new BranchTrees("betula", "Betula");
        betulaceae.addMemberGroup(betula);
        BranchTrees tilia = new BranchTrees("tilia", "Tilia");
        malvaceae.addMemberGroup(tilia);
        BranchTrees ceiba = new BranchTrees("ceiba", "Ceiba");
        malvaceae.addMemberGroup(ceiba);
        BranchTrees adansonia = new BranchTrees("adansonia", "Adansonia");
        malvaceae.addMemberGroup(adansonia);
        BranchTrees picea = new BranchTrees("picea", "Picea");
        pinaceae.addMemberGroup(picea);
        BranchTrees pinus = new BranchTrees("pinus", "Pinus");
        pinaceae.addMemberGroup(pinus);
        BranchTrees larix = new BranchTrees("larix", "Larix");
        pinaceae.addMemberGroup(larix);
        BranchTrees juglans = new BranchTrees("juglans", "Juglans");
        juglandaceae.addMemberGroup(juglans);
        BranchTrees sequoia = new BranchTrees("sequoia", "Sequoia");
        cupressaceae.addMemberGroup(sequoia);
        BranchTrees sequoiadendron = new BranchTrees("sequoiadendron", "Sequoiadendron");
        cupressaceae.addMemberGroup(sequoiadendron);
        BranchTrees tectona = new BranchTrees("tectona", "Tectona");
        lamiaceae.addMemberGroup(tectona);
        BranchTrees diospyros = new BranchTrees("ebony", "Diospyros");
        ebenaceae.addMemberGroup(diospyros);
        BranchTrees shorea = new BranchTrees("mahogany", "Shorea");
        dipterocarpaceae.addMemberGroup(shorea);
        BranchTrees acacia = new BranchTrees("acacia", "Acacia");
        fabaceae.addMemberGroup(acacia);
        BranchTrees millettia = new BranchTrees("millettia", "Millettia");
        fabaceae.addMemberGroup(millettia);
        BranchTrees ochroma = new BranchTrees("ochroma", "Ochroma");
        malvaceae.addMemberGroup(ochroma);
        BranchTrees prunus = new BranchTrees("prunus", "Prunus");
        rosaceae.addMemberGroup(prunus);
        BranchTrees salix = new BranchTrees("salix", "Salix");
        salicaceae.addMemberGroup(salix);
        BranchTrees chlorocardium = new BranchTrees("chlorocardium", "Chlorocardium");
        salicaceae.addMemberGroup(chlorocardium);
        BranchTrees talipariti = new BranchTrees("talipariti", "Talipariti");
        malvaceae.addMemberGroup(talipariti);
        BranchTrees populus = new BranchTrees("populus", "Populus");
        salicaceae.addMemberGroup(populus);
        BranchTrees citrus = new BranchTrees("citrus", "Citrus");
        rutaceae.addMemberGroup(citrus);
        BranchTrees acer = new BranchTrees("acer", "Acer");
        sapindaceae.addMemberGroup(acer);
        BranchTrees tropical = new BranchTrees("Tropical", "");
        BranchTrees carica = new BranchTrees("carica", "Carica");
        FruitFamily prunes = new FruitFamily("prunes", "Prunus domestica");
        FruitFamily pomes = new FruitFamily("pomes", "Pomum");
        FruitFamily jungle = new FruitFamily("jungle", "Tropicus");
        FruitFamily nux = new FruitFamily("nuts", "Nux");
        Allele.treeOak = new AlleleTreeSpecies("treeOak", false, "Apple Oak", (IClassification)quercus, "robur", proxy.getFoliageColorBasic(), WorldGenOak.class).addFruitFamily(pomes).setVanillaMap(0).setIsSecret();
        Allele.treeBirch = new AlleleTreeSpecies("treeBirch", false, "Silver Birch", betula, "pendula", proxy.getFoliageColorBirch(), 11585096, WorldGenBirch.class).setVanillaMap(2).setIsSecret();
        Allele.treeLime = new AlleleTreeSpecies("treeLime", true, "Silver Lime", (IClassification)tilia, "tomentosa", 6201607, WorldGenLime.class).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes);
        Allele.treeWalnut = new AlleleTreeSpecies("treeWalnut", true, "Common Walnut", juglans, "regia", 7965781, 11585096, WorldGenWalnut.class).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setGirth(2);
        Allele.treeChestnut = new AlleleTreeSpecies("treeChestnut", true, "Sweet Chestnut", castanea, "sativa", 6201607, 11585096, WorldGenChestnut.class).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setGirth(2);
        Allele.treeCherry = new AlleleTreeSpecies("treeCherry", true, "Hill Cherry", prunus, "serrulata", 15110618, 15089241, WorldGenCherry.class).addFruitFamily(prunes).addFruitFamily(pomes);
        Allele.treeLemon = new AlleleTreeSpecies("treeLemon", true, "Lemon", citrus, "limon", 8957780, 10729552, WorldGenLemon.class).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treePlum = new AlleleTreeSpecies("treePlum", true, "Plum", prunus, "domestica", 5804614, 10729552, WorldGenPlum.class).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treeMaple = new AlleleTreeSpecies("treeMaple", true, "Sugar Maple", acer, "saccharum", 13956133, 6396476, WorldGenMaple.class).addFruitFamily(prunes).addFruitFamily(pomes).setLeafIndices("maple");
        Allele.treeSpruce = new AlleleTreeSpecies("treeSpruce", false, "Red Spruce", picea, "abies", proxy.getFoliageColorPine(), 5479698, WorldGenSpruce.class).setLeafIndices("conifers").setVanillaMap(1).setIsSecret();
        Allele.treeLarch = new AlleleTreeSpecies("treeLarch", true, "Mundane Larch", larix, "decidua", 6918032, 5675158, WorldGenLarch.class).setLeafIndices("conifers");
        Allele.treePine = new AlleleTreeSpecies("treePine", true, "Bull Pine", pinus, "sabiniana", 0xFEFF8F, 16767375, WorldGenPine.class).setLeafIndices("conifers");
        Allele.treeSequioa = new AlleleTreeSpecies("treeSequioa", false, "Coast Sequoia", sequoia, "sempervirens", 4296305, 5675158, WorldGenSequoia.class).setLeafIndices("conifers").setGirth(3);
        Allele.treeGiganteum = new AlleleTreeSpecies("treeGigant", false, "Giant Sequoia", (IClassification)sequoiadendron, "giganteum", 7570484, WorldGenGiganteum.class).setLeafIndices("conifers").setGirth(4);
        Allele.treeJungle = new AlleleTreeSpecies("treeJungle", false, "Jungle", tropical, "tectona", proxy.getFoliageColorBasic(), 5479698, WorldGenJungle.class).addFruitFamily(jungle).setLeafIndices("jungle").setVanillaMap(3).setIsSecret();
        Allele.treeTeak = new AlleleTreeSpecies("treeTeak", true, "Teak", tectona, "grandis", 0xFEFF8F, 16767375, WorldGenTeak.class).addFruitFamily(jungle).setLeafIndices("jungle");
        Allele.treeKapok = new AlleleTreeSpecies("treeKapok", true, "Kapok", ceiba, "pentandra", 9017467, 9022110, WorldGenKapok.class).addFruitFamily(jungle).addFruitFamily(prunes).setLeafIndices("jungle");
        Allele.treeEbony = new AlleleTreeSpecies("treeEbony", true, "Myrtle Ebony", diospyros, "pentamera", 10670666, 12898890, WorldGenEbony.class).addFruitFamily(jungle).addFruitFamily(prunes).setGirth(3).setLeafIndices("jungle");
        Allele.treeMahogany = new AlleleTreeSpecies("treeMahogony", true, "Yellow Meranti", shorea, "gibbosa", 9089364, 11120980, WorldGenMahogany.class).addFruitFamily(jungle).setGirth(2).setLeafIndices("jungle");
        Allele.treeAcacia = new AlleleTreeSpecies("treeAcacia", true, "Desert Acacia", acacia, "erioloba", 0x616101, 11776770, WorldGenAcacia.class).addFruitFamily(jungle).addFruitFamily(nux);
        Allele.treeBalsa = new AlleleTreeSpecies("treeBalsa", true, "Balsa", ochroma, "pyramidale", 5876736, 0xFEFF8F, WorldGenBalsa.class).addFruitFamily(jungle).addFruitFamily(nux);
        Allele.treeWenge = new AlleleTreeSpecies("treeWenge", true, "Wenge", millettia, "laurentii", 11379031, 11373143, WorldGenWenge.class).addFruitFamily(jungle).addFruitFamily(nux).setGirth(2);
        Allele.treeBaobab = new AlleleTreeSpecies("treeBaobab", true, "Grandidier's Baobab", adansonia, "digitata", 0xFEFF8F, 16767375, WorldGenBaobab.class).addFruitFamily(jungle).addFruitFamily(nux).setGirth(3);
        Allele.treeMahoe = new AlleleTreeSpecies("treeMahoe", true, "Blue Mahoe", talipariti, "elatum", 10533403, 7971189, WorldGenMahoe.class).addFruitFamily(jungle).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treeWillow = new AlleleTreeSpecies("treeWillow", true, "White Willow", salix, "alba", 10729637, 10729552, WorldGenWillow.class).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setLeafIndices("willow");
        Allele.treeSipiri = new AlleleTreeSpecies("treeSipiri", true, "Sipiri", chlorocardium, "rodiei", 6785297, 7971189, WorldGenGreenheart.class).addFruitFamily(jungle);
        Allele.treePapaya = new AlleleTreeSpecies("treePapaya", true, "Papaya", carica, "papaya", 7184216, 10413695, WorldGenPapaya.class).addFruitFamily(jungle).addFruitFamily(nux).setLeafIndices("palm");
        Allele.treeDate = new AlleleTreeSpecies("treeDate", true, "Date Palm", null, "dactylifera", 13356409, 15790991, WorldGenDate.class).addFruitFamily(jungle).addFruitFamily(nux).setLeafIndices("palm");
        Allele.treePoplar = new AlleleTreeSpecies("treePoplar", true, "White Poplar", populus, "alba", 10729637, 5479698, WorldGenPoplar.class).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.fruitNone = new AlleleFruit("fruitNone", new FruitProviderNone("none", null));
        Allele.fruitApple = new AlleleFruit("fruitApple", new FruitProviderRandom("apple", pomes, new ItemStack(Item.field_77706_j), 1.0f).setColour(0xFF2E2E).setOverlay("pomes"));
        Allele.fruitCocoa = new AlleleFruit("fruitCocoa", new FruitProviderPod("cocoa", jungle, FruitProviderPod.EnumPodType.COCOA, null));
        Allele.fruitChestnut = new AlleleFruit("fruitChestnut", new FruitProviderRipening("chestnut", nux, new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.CHESTNUT.ordinal()), 1.0f).setRipeningPeriod(6).setColours(8336189, 12898890).setOverlay("nuts"), true);
        Allele.fruitWalnut = new AlleleFruit("fruitWalnut", new FruitProviderRipening("walnut", nux, new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.WALNUT.ordinal()), 1.0f).setRipeningPeriod(8).setColours(16491080, 12898890).setOverlay("nuts"), true);
        Allele.fruitCherry = new AlleleFruit("fruitCherry", new FruitProviderRipening("cherry", prunes, new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.CHERRY.ordinal()), 1.0f).setColours(0xFF2E2E, 12898890).setOverlay("berries"), true);
        Allele.fruitDates = new AlleleFruit("fruitDates", new FruitProviderPod("dates", jungle, FruitProviderPod.EnumPodType.DATES, new ItemStack[]{new ItemStack(ForestryItem.fruits, 4, ItemFruit.EnumFruit.DATES.ordinal())}));
        Allele.fruitPapaya = new AlleleFruit("fruitPapaya", new FruitProviderPod("papaya", jungle, FruitProviderPod.EnumPodType.PAPAYA, new ItemStack[]{new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.PAPAYA.ordinal())}));
        Allele.fruitLemon = new AlleleFruit("fruitLemon", new FruitProviderRipening("lemon", prunes, new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.LEMON.ordinal()), 1.0f).setColours(0xEEEE00, 0x99FF00).setOverlay("citrus"), true);
        Allele.fruitPlum = new AlleleFruit("fruitPlum", new FruitProviderRipening("plum", prunes, new ItemStack(ForestryItem.fruits, 1, ItemFruit.EnumFruit.PLUM.ordinal()), 1.0f).setColours(0x663446, 15662874).setOverlay("plums"), true);
        Allele.growthLightlevel = new AlleleGrowth("growthLightlevel", new GrowthProvider());
        Allele.growthAcacia = new AlleleGrowth("growthAcacia", new GrowthProvider());
        Allele.growthTropical = new AlleleGrowth("growthTropical", new GrowthProviderTropical());
        Allele.leavesNone = new AlleleLeafEffectNone("leavesNone");
    }

    private void registerTemplates() {
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getOakTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getBirchTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getSpruceTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getJungleTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getLimeTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getCherryTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getChestnutTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getWalnutTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getLarchTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getPineTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getSequoiaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getGiganteumTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getBalsaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getAcaciaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getWengeTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getBaobabTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getTeakTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getKapokTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getEbonyTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getMahoganyTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getWillowTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getSipiriTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getMahoeTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getPoplarTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getLemonTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getPlumTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getMapleTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getPapayaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getDateTemplate());
    }

    private void registerErsatzGenomes() {
        AlleleManager.ersatzSpecimen.put(new ItemStack(Block.field_71952_K.field_71990_ca, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getOakTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack(Block.field_71952_K.field_71990_ca, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getSpruceTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack(Block.field_71952_K.field_71990_ca, 1, 2), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getBirchTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack(Block.field_71952_K.field_71990_ca, 1, 3), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getJungleTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Block.field_71987_y.field_71990_ca, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getOakTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Block.field_71987_y.field_71990_ca, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getSpruceTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Block.field_71987_y.field_71990_ca, 1, 2), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getBirchTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Block.field_71987_y.field_71990_ca, 1, 3), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getJungleTemplate())));
    }

    private void createMutations() {
        TreeTemplates.limeA = new Mutation(Allele.treeBirch, Allele.treeOak, TreeTemplates.getLimeTemplate(), 15);
        TreeTemplates.mapleA = new Mutation(Allele.treeLime, Allele.treeLarch, TreeTemplates.getMapleTemplate(), 5);
        TreeTemplates.cherryA = new Mutation(Allele.treeLime, Allele.treeOak, TreeTemplates.getCherryTemplate(), 10);
        TreeTemplates.cherryB = new Mutation(Allele.treeLime, Allele.treeBirch, TreeTemplates.getCherryTemplate(), 10);
        TreeTemplates.lemonA = new Mutation(Allele.treeLime, Allele.treeCherry, TreeTemplates.getLemonTemplate(), 5);
        TreeTemplates.plumA = new Mutation(Allele.treeLemon, Allele.treeCherry, TreeTemplates.getPlumTemplate(), 5);
        TreeTemplates.walnutA = new Mutation(Allele.treeLime, Allele.treeCherry, TreeTemplates.getWalnutTemplate(), 10);
        TreeTemplates.chestnutA = new Mutation(Allele.treeWalnut, Allele.treeLime, TreeTemplates.getChestnutTemplate(), 10);
        TreeTemplates.chestnutB = new Mutation(Allele.treeWalnut, Allele.treeCherry, TreeTemplates.getChestnutTemplate(), 10);
        TreeTemplates.larchA = new Mutation(Allele.treeSpruce, Allele.treeBirch, TreeTemplates.getLarchTemplate(), 10);
        TreeTemplates.larchB = new Mutation(Allele.treeSpruce, Allele.treeOak, TreeTemplates.getLarchTemplate(), 10);
        TreeTemplates.pineA = new Mutation(Allele.treeSpruce, Allele.treeLarch, TreeTemplates.getPineTemplate(), 10);
        TreeTemplates.sequoiaA = new Mutation(Allele.treeLarch, Allele.treePine, TreeTemplates.getSequoiaTemplate(), 5);
        TreeTemplates.teakA = new Mutation(Allele.treeLime, Allele.treeJungle, TreeTemplates.getTeakTemplate(), 10);
        TreeTemplates.kapokA = new Mutation(Allele.treeJungle, Allele.treeTeak, TreeTemplates.getKapokTemplate(), 10);
        TreeTemplates.ebonyA = new Mutation(Allele.treeKapok, Allele.treeTeak, TreeTemplates.getEbonyTemplate(), 10);
        TreeTemplates.mahoganyA = new Mutation(Allele.treeKapok, Allele.treeEbony, TreeTemplates.getMahoganyTemplate(), 10);
        TreeTemplates.papayaA = new Mutation(Allele.treeJungle, Allele.treeCherry, TreeTemplates.getPapayaTemplate(), 5);
        TreeTemplates.dateA = new Mutation(Allele.treeJungle, Allele.treePapaya, TreeTemplates.getDateTemplate(), 5);
        TreeTemplates.balsaA = new Mutation(Allele.treeTeak, Allele.treeLime, TreeTemplates.getBalsaTemplate(), 10);
        TreeTemplates.acaciaA = new Mutation(Allele.treeTeak, Allele.treeBalsa, TreeTemplates.getAcaciaTemplate(), 10);
        TreeTemplates.wengeA = new Mutation(Allele.treeAcacia, Allele.treeBalsa, TreeTemplates.getWengeTemplate(), 10);
        TreeTemplates.baobabA = new Mutation(Allele.treeBalsa, Allele.treeWenge, TreeTemplates.getBaobabTemplate(), 10);
        TreeTemplates.mahoeA = new Mutation(Allele.treeBirch, Allele.treeAcacia, TreeTemplates.getMahoeTemplate(), 5);
        TreeTemplates.willowA = new Mutation(Allele.treeOak, Allele.treeBirch, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.willowB = new Mutation(Allele.treeOak, Allele.treeLime, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.willowC = new Mutation(Allele.treeLime, Allele.treeBirch, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.sipiriA = new Mutation(Allele.treeKapok, Allele.treeMahogany, TreeTemplates.getSipiriTemplate(), 10).setTemperatureRainfall(0.9f, 1.9f, 0.9f, 2.0f);
        TreeTemplates.poplarA = new Mutation(Allele.treeBirch, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
        TreeTemplates.poplarB = new Mutation(Allele.treeOak, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
        TreeTemplates.poplarB = new Mutation(Allele.treeLime, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerArboriculture();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{new CommandSpawnTree(), new CommandSpawnForest(), new CommandTreekeepingMode()};
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel != null && fuel.field_77993_c == ForestryItem.sapling.field_77779_bT) {
            return 100;
        }
        return 0;
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerArboriculture();
    }

    static {
        treekeepingMode = "NORMAL";
    }
}

