/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.PluginInfo;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.core.CommandForestry;
import forestry.core.CreativeTabForestry;
import forestry.core.GameMode;
import forestry.core.SaveEventHandlerCore;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineAnalyzer;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.genetics.Allele;
import forestry.core.genetics.AlleleRegistry;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemAssemblyKit;
import forestry.core.items.ItemCrated;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemForestryPickaxe;
import forestry.core.items.ItemForestryShovel;
import forestry.core.items.ItemFruit;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.items.ItemLiquids;
import forestry.core.items.ItemMisc;
import forestry.core.items.ItemOverlay;
import forestry.core.items.ItemPipette;
import forestry.core.items.ItemWrench;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.Utils;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginBuildCraft;
import forestry.plugins.PluginForestryApiculture;
import java.security.cert.Certificate;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", description="Core mechanics for Forestry. Required by all other plugins.")
public class PluginForestryCore
extends NativePlugin
implements IFuelHandler {
    public static MachineDefinition definitionAnalyzer;
    private static ArrayList jwrbSeBUxGERWelhClI;

    @Override
    public void preInit() {
        super.preInit();
        ChipsetManager.solderManager = new ItemSolderingIron.SolderManager();
        CircuitRegistry circuitRegistry = new CircuitRegistry();
        ChipsetManager.circuitRegistry = circuitRegistry;
        circuitRegistry.initialize();
        AlleleRegistry alleleRegistry = new AlleleRegistry();
        AlleleManager.alleleRegistry = alleleRegistry;
        alleleRegistry.initialize();
        Allele.initialize();
        int blockid = Config.getOrCreateBlockIdProperty("core", 1409);
        definitionAnalyzer = new MachineDefinition(blockid, 0, "forestry.Analyzer", MachineAnalyzer.class, PluginForestryApiculture.proxy.getRendererAnalyzer("/gfx/forestry/blocks/analyzer_"), new IRecipe[0]);
        ForestryBlock.core = new BlockBase(blockid, Material.field_76243_f, new MachineDefinition[]{definitionAnalyzer}, true).func_71864_b("for.core");
        Item.field_77698_e[ForestryBlock.core.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.core.field_71990_ca] = new ItemForestryBlock(ForestryBlock.core.field_71990_ca - 256, "for.core");
        GameRegistry.registerFuelHandler((IFuelHandler)this);
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginForestryCore.definitionAnalyzer.recipes = this.$jdxjosWrzxWjeQu$(ForestryBlock.core.field_71990_ca, 0);
        definitionAnalyzer.register();
    }

    @Override
    public void postInit() {
        super.postInit();
        this.$etweYiYUHNEN$();
        if (Proxies.render.hasRendering()) {
            this.$ecmhhzRkXhUmmZNRmxE$();
        }
        for (gqgxQiIqeCK prop : jwrbSeBUxGERWelhClI) {
            prop.$bhpqOIb$();
        }
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    protected void registerItems() {
        ForestryItem.fertilizerBio = new ItemForestry(Config.getOrCreateItemIdProperty("fertilizerBio", 5000)).func_77655_b("fertilizerBio");
        ForestryItem.fertilizerCompound = new ItemForestry(Config.getOrCreateItemIdProperty("fertilizerCompound", 5001)).func_77655_b("fertilizerCompound");
        ForestryItem.apatite = new ItemForestry(Config.getOrCreateItemIdProperty("apatite", 5002)).func_77655_b("apatite");
        OreDictionary.registerOre((String)"gemApatite", (ItemStack)new ItemStack(ForestryItem.apatite));
        Item copper = new ItemForestry(Config.getOrCreateItemIdProperty("ingotCopper", 5003)).func_77655_b("ingotCopper");
        ForestryItem.ingotCopper = new ItemStack(copper);
        FurnaceRecipes.func_77602_a().addSmelting(ForestryBlock.resources.field_71990_ca, 1, ForestryItem.ingotCopper, 0.5f);
        Item tin = new ItemForestry(Config.getOrCreateItemIdProperty("ingotTin", 5004)).func_77655_b("ingotTin");
        ForestryItem.ingotTin = new ItemStack(tin);
        FurnaceRecipes.func_77602_a().addSmelting(ForestryBlock.resources.field_71990_ca, 2, ForestryItem.ingotTin, 0.5f);
        Item bronze = new ItemForestry(Config.getOrCreateItemIdProperty("ingotBronze", 5005)).func_77655_b("ingotBronze");
        ForestryItem.ingotBronze = new ItemStack(bronze);
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)ForestryItem.ingotCopper);
        OreDictionary.registerOre((String)"ingotTin", (ItemStack)ForestryItem.ingotTin);
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)ForestryItem.ingotBronze);
        ForestryItem.wrench = new ItemWrench(Config.getOrCreateItemIdProperty("wrench", 5007)).func_77655_b("wrench");
        ForestryItem.pipette = new ItemPipette(Config.getOrCreateItemIdProperty("pipette", 13111)).func_77655_b("pipette").func_77664_n();
        ForestryItem.sturdyCasing = new ItemForestry(Config.getOrCreateItemIdProperty("sturdyMachine", 5010)).func_77655_b("sturdyMachine");
        ForestryItem.hardenedCasing = new ItemForestry(Config.getOrCreateItemIdProperty("hardenedMachine", 5025)).func_77655_b("hardenedMachine");
        ForestryItem.impregnatedCasing = new ItemForestry(Config.getOrCreateItemIdProperty("impregnatedCasing", 13124)).func_77655_b("impregnatedCasing");
        ForestryItem.craftingMaterial = new ItemMisc(Config.getOrCreateItemIdProperty("craftingMaterial", 13098)).func_77655_b("craftingMaterial");
        ForestryItem.vialCatalyst = new ItemForestry(Config.getOrCreateItemIdProperty("vialCatalyst", 5012)).func_77655_b("vialCatalyst");
        this.$knTTEsnmdoBr$();
        ForestryItem.waxCapsule = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsule", 13034), ItemLiquidContainer.EnumContainerType.CAPSULE, -1).func_77655_b("waxCapsule").func_77625_d(64);
        ForestryItem.canEmpty = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canEmpty", 5021), ItemLiquidContainer.EnumContainerType.CAN, -1).func_77655_b("canEmpty").func_77625_d(64);
        ForestryItem.refractoryEmpty = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryEmpty", 13070), ItemLiquidContainer.EnumContainerType.REFRACTORY, -1).func_77655_b("refractoryEmpty").func_77625_d(64);
        ForestryItem.bucketBiomass = new ItemForestry(Config.getOrCreateItemIdProperty("bucketBiomass", 5009)).func_77655_b("bucketBiomass").func_77642_a(Item.field_77788_aw).func_77625_d(1);
        ForestryItem.bucketBiofuel = new ItemForestry(Config.getOrCreateItemIdProperty("bucketBiofuel", 5015)).func_77655_b("bucketBiofuel").func_77642_a(Item.field_77788_aw).func_77625_d(1);
        ForestryItem.waxCapsuleWater = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleWater", 13038), ItemLiquidContainer.EnumContainerType.CAPSULE, 2372332).func_77655_b("waxCapsuleWater");
        ForestryItem.waxCapsuleBiomass = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleBiomass", 13039), ItemLiquidContainer.EnumContainerType.CAPSULE, 8639516).func_77655_b("waxCapsuleBiomass");
        ForestryItem.waxCapsuleBiofuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleBiofuel", 13040), ItemLiquidContainer.EnumContainerType.CAPSULE, 16742665).func_77655_b("waxCapsuleBiofuel");
        ForestryItem.waxCapsuleOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleOil", 13042), ItemLiquidContainer.EnumContainerType.CAPSULE, 0x404040).func_77655_b("waxCapsuleOil");
        ForestryItem.waxCapsuleFuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleFuel", 13043), ItemLiquidContainer.EnumContainerType.CAPSULE, 0xFFFF00).func_77655_b("waxCapsuleFuel");
        ForestryItem.waxCapsuleSeedOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleSeedOil", 13065), ItemLiquidContainer.EnumContainerType.CAPSULE, 0xFFFFA9).func_77655_b("waxCapsuleSeedOil");
        ForestryItem.waxCapsuleHoney = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleHoney", 13066), ItemLiquidContainer.EnumContainerType.CAPSULE, 16767559).setDrink(2, 0.2f).func_77655_b("waxCapsuleHoney");
        ForestryItem.waxCapsuleJuice = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleJuice", 13067), ItemLiquidContainer.EnumContainerType.CAPSULE, 10080334).setDrink(2, 0.2f).func_77655_b("waxCapsuleJuice");
        ForestryItem.waxCapsuleIce = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleIce", 13121), ItemLiquidContainer.EnumContainerType.CAPSULE, 0xDCFFFF).func_77655_b("waxCapsuleIce");
        ForestryItem.canWater = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waterCan", 5020), ItemLiquidContainer.EnumContainerType.CAN, 2372332).func_77655_b("waterCan");
        ForestryItem.canBiomass = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("biomassCan", 5022), ItemLiquidContainer.EnumContainerType.CAN, 8639516).func_77655_b("biomassCan");
        ForestryItem.canBiofuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("biofuelCan", 5023), ItemLiquidContainer.EnumContainerType.CAN, 16742665).func_77655_b("biofuelCan");
        ForestryItem.canOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canOil", 13044), ItemLiquidContainer.EnumContainerType.CAN, 0x404040).func_77655_b("canOil");
        ForestryItem.canFuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canFuel", 13045), ItemLiquidContainer.EnumContainerType.CAN, 0xFFFF00).func_77655_b("canFuel");
        ForestryItem.canLava = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canLava", 13046), ItemLiquidContainer.EnumContainerType.CAN, 16598559).func_77655_b("canLava");
        ForestryItem.canSeedOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canSeedOil", 13062), ItemLiquidContainer.EnumContainerType.CAN, 0xFFFFA9).func_77655_b("canSeedOil");
        ForestryItem.canHoney = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canHoney", 13063), ItemLiquidContainer.EnumContainerType.CAN, 16767559).setDrink(2, 0.2f).func_77655_b("canHoney");
        ForestryItem.canJuice = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canJuice", 13064), ItemLiquidContainer.EnumContainerType.CAN, 10080334).setDrink(2, 0.2f).func_77655_b("canJuice");
        ForestryItem.canIce = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canIce", 13120), ItemLiquidContainer.EnumContainerType.CAN, 0xDCFFFF).func_77655_b("canIce");
        ForestryItem.refractoryWater = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryWater", 13075), ItemLiquidContainer.EnumContainerType.REFRACTORY, 2372332).func_77655_b("refractoryWater");
        ForestryItem.refractoryBiomass = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryBiomass", 13076), ItemLiquidContainer.EnumContainerType.REFRACTORY, 8639516).func_77655_b("refractoryBiomass");
        ForestryItem.refractoryBiofuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryBiofuel", 13077), ItemLiquidContainer.EnumContainerType.REFRACTORY, 16742665).func_77655_b("refractoryBiofuel");
        ForestryItem.refractoryOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryOil", 13078), ItemLiquidContainer.EnumContainerType.REFRACTORY, 0x404040).func_77655_b("refractoryOil");
        ForestryItem.refractoryFuel = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryFuel", 13079), ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xFFFF00).func_77655_b("refractoryFuel");
        ForestryItem.refractoryLava = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryLava", 13071), ItemLiquidContainer.EnumContainerType.REFRACTORY, 16598559).func_77655_b("refractoryLava");
        ForestryItem.refractorySeedOil = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractorySeedOil", 13080), ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xFFFFA9).func_77655_b("refractorySeedOil");
        ForestryItem.refractoryHoney = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryHoney", 13081), ItemLiquidContainer.EnumContainerType.REFRACTORY, 16767559).setDrink(2, 0.2f).func_77655_b("refractoryHoney");
        ForestryItem.refractoryJuice = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryJuice", 13082), ItemLiquidContainer.EnumContainerType.REFRACTORY, 10080334).setDrink(2, 0.2f).func_77655_b("refractoryJuice");
        ForestryItem.refractoryIce = new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryIce", 13122), ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xDCFFFF).func_77655_b("refractoryIce");
        ForestryItem.liquidMilk = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidMilk", 5016)).func_77655_b("liquidMilk");
        ForestryItem.liquidBiofuel = new ItemLiquids(Config.getOrCreateItemIdProperty("bioFuel", 5013)).func_77655_b("liquidBiofuel");
        ForestryItem.liquidBiomass = new ItemLiquids(Config.getOrCreateItemIdProperty("bioMass", 5014)).func_77655_b("liquidBiomass");
        ForestryItem.liquidSeedOil = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidSeedOil", 13057)).func_77655_b("liquidSeedOil");
        ForestryItem.liquidJuice = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidJuice", 13058)).func_77655_b("liquidJuice");
        ForestryItem.liquidHoney = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidHoney", 13059)).func_77655_b("liquidHoney");
        ForestryItem.liquidMead = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidMead", 13109)).func_77655_b("liquidMead");
        ForestryItem.liquidGlass = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidGlass", 13115)).func_77655_b("liquidGlass");
        ForestryItem.liquidIce = new ItemLiquids(Config.getOrCreateItemIdProperty("liquidIce", 13119)).func_77655_b("liquidIce");
        ForestryItem.cratedWood = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedWood", 13500), new ItemStack(Block.field_71951_J)).func_77655_b("cratedWood");
        ForestryItem.cratedCobblestone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCobblestone", 13501), new ItemStack(Block.field_71978_w)).func_77655_b("cratedCobblestone");
        ForestryItem.cratedDirt = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedDirt", 13502), new ItemStack(Block.field_71979_v)).func_77655_b("cratedDirt");
        ForestryItem.cratedStone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedStone", 13503), new ItemStack(Block.field_71981_t)).func_77655_b("cratedStone");
        ForestryItem.cratedBrick = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBrick", 13504), new ItemStack(Block.field_72081_al)).func_77655_b("cratedBrick");
        ForestryItem.cratedCacti = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCacti", 13505), new ItemStack(Block.field_72038_aV)).func_77655_b("cratedCacti");
        ForestryItem.cratedSand = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSand", 13506), new ItemStack(Block.field_71939_E)).func_77655_b("cratedSand");
        ForestryItem.cratedObsidian = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedObsidian", 13507), new ItemStack(Block.field_72089_ap)).func_77655_b("cratedObsidian");
        ForestryItem.cratedNetherrack = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherrack", 13508), new ItemStack(Block.field_72012_bb)).func_77655_b("cratedNetherrack");
        ForestryItem.cratedSoulsand = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSoulsand", 13509), new ItemStack(Block.field_72013_bc)).func_77655_b("cratedSoulsand");
        ForestryItem.cratedSandstone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSandstone", 13510), new ItemStack(Block.field_71957_Q)).func_77655_b("cratedSandstone");
        ForestryItem.cratedBogearth = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBogearth", 13511), new ItemStack(ForestryBlock.soil, 1, 1)).func_77655_b("cratedBogearth");
        ForestryItem.cratedHumus = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedHumus", 13512), new ItemStack(ForestryBlock.soil, 1, 0)).func_77655_b("cratedHumus");
        ForestryItem.cratedNetherbrick = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherbrick", 13513), new ItemStack(Block.field_72033_bA)).func_77655_b("cratedNetherbrick");
        ForestryItem.cratedPeat = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPeat", 13514), new ItemStack(ForestryItem.peat)).func_77655_b("cratedPeat");
        ForestryItem.cratedApatite = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedApatite", 13515), new ItemStack(ForestryItem.apatite)).func_77655_b("cratedApatite");
        ForestryItem.cratedFertilizer = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedFertilizer", 13516), new ItemStack(ForestryItem.fertilizerCompound)).func_77655_b("cratedFertilizer");
        ForestryItem.cratedTin = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedTin", 13517), ForestryItem.ingotTin).func_77655_b("cratedTin");
        ForestryItem.cratedCopper = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCopper", 13518), ForestryItem.ingotCopper).func_77655_b("cratedCopper");
        ForestryItem.cratedBronze = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBronze", 13519), ForestryItem.ingotBronze).func_77655_b("cratedBronze");
        ForestryItem.cratedWheat = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedWheat", 13520), new ItemStack(Item.field_77685_T)).func_77655_b("cratedWheat");
        ForestryItem.cratedMycelium = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedMycelium", 13521), new ItemStack((Block)Block.field_71994_by)).func_77655_b("cratedMycelium");
        ForestryItem.cratedMulch = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedMulch", 13522), new ItemStack(ForestryItem.mulch)).func_77655_b("cratedMulch");
        ForestryItem.cratedSilver = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSilver", 13523)).func_77655_b("cratedSilver");
        ForestryItem.cratedBrass = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBrass", 13524)).func_77655_b("cratedBrass");
        ForestryItem.cratedNikolite = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedNikolite", 13525)).func_77655_b("cratedNikolite");
        ForestryItem.cratedCookies = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCookies", 13526), new ItemStack(Item.field_77743_bc)).func_77655_b("cratedCookies");
        ForestryItem.cratedRedstone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRedstone", 13534), new ItemStack(Item.field_77767_aC)).func_77655_b("cratedRedstone");
        ForestryItem.cratedLapis = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedLapis", 13535), new ItemStack(Item.field_77756_aW, 1, 4)).func_77655_b("cratedLapis");
        ForestryItem.cratedReeds = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedReeds", 13536), new ItemStack(Item.field_77758_aJ)).func_77655_b("cratedReeds");
        ForestryItem.cratedClay = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedClay", 13537), new ItemStack(Item.field_77757_aI)).func_77655_b("cratedClay");
        ForestryItem.cratedGlowstone = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedGlowstone", 13538), new ItemStack(Item.field_77751_aT)).func_77655_b("cratedGlowstone");
        ForestryItem.cratedApples = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedApples", 13539), new ItemStack(Item.field_77706_j)).func_77655_b("cratedApples");
        ForestryItem.cratedNetherwart = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherwart", 13540), new ItemStack(Item.field_77727_br)).func_77655_b("cratedNetherwart");
        ForestryItem.cratedResin = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedResin", 13541)).func_77655_b("cratedResin");
        ForestryItem.cratedRubber = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRubber", 13542)).func_77655_b("cratedRubber");
        ForestryItem.cratedScrap = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedScrap", 13543)).func_77655_b("cratedScrap");
        ForestryItem.cratedUUM = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedUUM", 13544)).func_77655_b("cratedUUM");
        ForestryItem.cratedPhosphor = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPhosphor", 13550), new ItemStack(ForestryItem.phosphor)).func_77655_b("cratedPhosphor");
        ForestryItem.cratedAsh = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedAsh", 13551), new ItemStack(ForestryItem.ash)).func_77655_b("cratedAsh");
        ForestryItem.cratedCharcoal = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCharcoal", 13552), new ItemStack(Item.field_77705_m, 1, 1)).func_77655_b("cratedCharcoal");
        ForestryItem.cratedGravel = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedGravel", 13553), new ItemStack(Block.field_71940_F)).func_77655_b("cratedGravel");
        ForestryItem.cratedCoal = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCoal", 13554), new ItemStack(Item.field_77705_m, 1, 0)).func_77655_b("cratedCoal");
        ForestryItem.cratedSeeds = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSeeds", 13555), new ItemStack(Item.field_77690_S)).func_77655_b("cratedSeeds");
        ForestryItem.cratedSaplings = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSaplings", 13556), new ItemStack(Block.field_71987_y)).func_77655_b("cratedSaplings");
    }

    private void $knTTEsnmdoBr$() {
        ForestryItem.peat = new ItemForestry(Config.getOrCreateItemIdProperty("peat", 5017)).func_77655_b("peat");
        OreDictionary.registerOre((String)"brickPeat", (ItemStack)new ItemStack(ForestryItem.peat));
        ForestryItem.ash = new ItemForestry(Config.getOrCreateItemIdProperty("ash", 5018)).func_77655_b("ash");
        OreDictionary.registerOre((String)"dustAsh", (ItemStack)new ItemStack(ForestryItem.ash));
        Proxies.common.addSmelting(new ItemStack(ForestryItem.peat), new ItemStack(ForestryItem.ash));
        ForestryItem.bituminousPeat = new ItemForestry(Config.getOrCreateItemIdProperty("bituminousPeat", 13041)).func_77655_b("bituminousPeat");
        ForestryItem.gearBronze = new ItemForestry(Config.getOrCreateItemIdProperty("gearBronze", 5008)).func_77655_b("gearBronze");
        OreDictionary.registerOre((String)"gearBronze", (ItemStack)new ItemStack(ForestryItem.gearBronze));
        ForestryItem.gearCopper = new ItemForestry(Config.getOrCreateItemIdProperty("gearCopper", 5019)).func_77655_b("gearCopper");
        OreDictionary.registerOre((String)"gearCopper", (ItemStack)new ItemStack(ForestryItem.gearCopper));
        ForestryItem.gearTin = new ItemForestry(Config.getOrCreateItemIdProperty("gearTin", 5024)).func_77655_b("gearTin");
        OreDictionary.registerOre((String)"gearTin", (ItemStack)new ItemStack(ForestryItem.gearTin));
        ForestryItem.circuitboards = new ItemCircuitBoard(Config.getOrCreateItemIdProperty("chipsets", 13112)).func_77655_b("chipsets");
        ForestryItem.solderingIron = new ItemSolderingIron(Config.getOrCreateItemIdProperty("solderingIron", 13113)).func_77655_b("solderingIron");
        ForestryItem.tubes = new ItemOverlay(Config.getOrCreateItemIdProperty("thermionicTubes", 13114), CreativeTabForestry.tabForestry, new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("ex-0", 0xFFFFFF, 14923662), new ItemOverlay.OverlayInfo("ex-1", 0xFFFFFF, 14806772), new ItemOverlay.OverlayInfo("ex-2", 0xFFFFFF, 14533238), new ItemOverlay.OverlayInfo("ex-3", 0xFFFFFF, 0xD8D8D8), new ItemOverlay.OverlayInfo("ex-4", 0xFFFFFF, 0xFFFF8B), new ItemOverlay.OverlayInfo("ex-5", 0xFFFFFF, 8114616), new ItemOverlay.OverlayInfo("ex-6", 0xFFFFFF, 8809408), new ItemOverlay.OverlayInfo("ex-7", 16775294, 14247424), new ItemOverlay.OverlayInfo("ex-8", 0xFFFFFF, 0x444444), new ItemOverlay.OverlayInfo("ex-9", 0xFFFFFF, 0xBFFFDD), new ItemOverlay.OverlayInfo("ex-10", 0xFFFFFF, 6868206), new ItemOverlay.OverlayInfo("ex-11", 0xFFFFFF, 1857478)}).func_77655_b("thermionicTubes");
        ForestryItem.carton = new ItemForestry(Config.getOrCreateItemIdProperty("carton", 13000)).func_77655_b("carton");
        ForestryItem.crate = new ItemForestry(Config.getOrCreateItemIdProperty("crate", 13001)).func_77655_b("crate");
        ForestryItem.stickImpregnated = new ItemForestry(Config.getOrCreateItemIdProperty("oakStick", 13002)).func_77655_b("oakStick");
        ForestryItem.woodPulp = new ItemForestry(Config.getOrCreateItemIdProperty("woodPulp", 13003)).func_77655_b("woodPulp");
        OreDictionary.registerOre((String)"pulpWood", (ItemStack)new ItemStack(ForestryItem.woodPulp));
        ForestryItem.brokenBronzePickaxe = new ItemForestry(Config.getOrCreateItemIdProperty("brokenBronzePickaxe", 13006)).func_77655_b("brokenBronzePickaxe");
        ForestryItem.brokenBronzeShovel = new ItemForestry(Config.getOrCreateItemIdProperty("brokenBronzeShovel", 13009)).func_77655_b("brokenBronzeShovel");
        ForestryItem.bronzePickaxe = new ItemForestryPickaxe(Config.getOrCreateItemIdProperty("bronzePickaxe", 13005), new ItemStack(ForestryItem.brokenBronzePickaxe)).func_77655_b("bronzePickaxe");
        MinecraftForge.setToolClass((Item)ForestryItem.bronzePickaxe, (String)"pickaxe", (int)3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzePickaxe);
        ForestryItem.bronzeShovel = new ItemForestryShovel(Config.getOrCreateItemIdProperty("bronzeShovel", 13008), new ItemStack(ForestryItem.brokenBronzeShovel)).func_77655_b("bronzeShovel");
        MinecraftForge.setToolClass((Item)ForestryItem.bronzeShovel, (String)"shovel", (int)3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzeShovel);
        ForestryItem.kitShovel = new ItemAssemblyKit(Config.getOrCreateItemIdProperty("kitShovel", 13007), new ItemStack(ForestryItem.bronzeShovel)).func_77655_b("kitShovel");
        ForestryItem.kitPickaxe = new ItemAssemblyKit(Config.getOrCreateItemIdProperty("kitPickaxe", 13004), new ItemStack(ForestryItem.bronzePickaxe)).func_77655_b("kitPickaxe");
        ForestryItem.mouldyWheat = new ItemForestry(Config.getOrCreateItemIdProperty("mouldyWheat", 13020)).func_77655_b("mouldyWheat");
        ForestryItem.decayingWheat = new ItemForestry(Config.getOrCreateItemIdProperty("decayingWheat", 13021)).func_77655_b("decayingWheat");
        ForestryItem.mulch = new ItemForestry(Config.getOrCreateItemIdProperty("mulch", 13022)).func_77655_b("mulch");
        ForestryItem.iodineCharge = new ItemForestry(Config.getOrCreateItemIdProperty("iodineCapsule", 5026)).func_77655_b("iodineCapsule");
        ForestryItem.phosphor = new ItemForestry(Config.getOrCreateItemIdProperty("phosphor", 13068)).func_77655_b("phosphor");
        ForestryItem.beeswax = new ItemForestry(Config.getOrCreateItemIdProperty("beeswax", 13029)).func_77655_b("beeswax").func_77637_a(Tabs.tabApiculture);
        OreDictionary.registerOre((String)"itemBeeswax", (ItemStack)new ItemStack(ForestryItem.beeswax));
        ForestryItem.refractoryWax = new ItemForestry(Config.getOrCreateItemIdProperty("refractoryWax", 13069)).func_77655_b("refractoryWax");
        ForestryItem.fruits = new ItemFruit(Config.getOrCreateItemIdProperty("fruits", 13130)).func_77655_b("fruits");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        if (Config.craftingBronzeEnabled) {
            Proxies.common.addRecipe(new ItemStack(ForestryItem.ingotBronze.field_77993_c, 4, ForestryItem.ingotBronze.func_77960_j()), new Object[]{"##", "#X", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), "ingotTin"});
        }
        Proxies.common.addRecipe(new ItemStack(ForestryItem.sturdyCasing, 1), new Object[]{"###", "# #", "###", Character.valueOf('#'), "ingotBronze"});
        Proxies.common.addRecipe(GameMode.getGameMode().getRecipeCanOutput(), new Object[]{" # ", "# #", Character.valueOf('#'), "ingotTin"});
        if (PluginBuildCraft.stoneGear != null) {
            Proxies.common.addRecipe(new ItemStack(ForestryItem.gearBronze, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('Y'), PluginBuildCraft.stoneGear});
            Proxies.common.addRecipe(new ItemStack(ForestryItem.gearCopper, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('Y'), PluginBuildCraft.stoneGear});
            Proxies.common.addRecipe(new ItemStack(ForestryItem.gearTin, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('Y'), PluginBuildCraft.stoneGear});
        } else {
            Proxies.common.addRecipe(new ItemStack(ForestryItem.gearBronze, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "ingotCopper"});
            Proxies.common.addRecipe(new ItemStack(ForestryItem.gearCopper, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), "ingotCopper"});
            Proxies.common.addRecipe(new ItemStack(ForestryItem.gearTin, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "ingotCopper"});
        }
        Proxies.common.addRecipe(new ItemStack(ForestryItem.bronzePickaxe), new Object[]{" X ", " X ", "###", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.bronzeShovel), new Object[]{" X ", " X ", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        Proxies.common.addShapelessRecipe(new ItemStack(ForestryItem.kitPickaxe), new Object[]{ForestryItem.bronzePickaxe, ForestryItem.carton});
        Proxies.common.addShapelessRecipe(new ItemStack(ForestryItem.kitShovel), new Object[]{ForestryItem.bronzeShovel, ForestryItem.carton});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.wrench, 1), new Object[]{"# #", " # ", " # ", Character.valueOf('#'), "ingotBronze"});
        if (GameMode.getGameMode().getRecipeCompostOutputWheat().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeCompostOutputWheat(), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), Item.field_77685_T});
        }
        if (GameMode.getGameMode().getRecipeCompostOutputAsh().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeCompostOutputAsh(), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), "dustAsh"});
        }
        if (GameMode.getGameMode().getRecipeFertilizerOutputApatite().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeFertilizerOutputApatite(), new Object[]{" # ", " X ", " # ", Character.valueOf('#'), Block.field_71939_E, Character.valueOf('X'), ForestryItem.apatite});
        }
        if (GameMode.getGameMode().getRecipeFertilizerOutputAsh().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeFertilizerOutputAsh(), new Object[]{"###", "#X#", "###", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), ForestryItem.apatite});
        }
        if (GameMode.getGameMode().getRecipeHumusOutputCompost().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeHumusOutputCompost(), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.fertilizerBio});
        }
        if (GameMode.getGameMode().getRecipeHumusOutputFertilizer().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeHumusOutputFertilizer(), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.fertilizerCompound});
        }
        if (GameMode.getGameMode().getRecipeBogEarthOutputBucket().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputBucket(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), Item.field_77786_ax, Character.valueOf('Y'), Block.field_71939_E});
        }
        if (GameMode.getGameMode().getRecipeBogEarthOutputCans().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputCans(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.canWater, Character.valueOf('Y'), Block.field_71939_E});
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputCans(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.waxCapsuleWater, Character.valueOf('Y'), Block.field_71939_E});
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputCans(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.refractoryWater, Character.valueOf('Y'), Block.field_71939_E});
        }
        Proxies.common.addRecipe(new ItemStack(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule, Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty, Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxies.common.addRecipe(new ItemStack(Item.field_77683_K), new Object[]{"#", "#", "#", Character.valueOf('#'), new ItemStack(ForestryItem.craftingMaterial, 1, 2)});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.pipette), new Object[]{"  #", " X ", "X  ", Character.valueOf('X'), Block.field_72003_bq, Character.valueOf('#'), new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE)});
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{new CommandForestry()};
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel != null && fuel.field_77993_c == ForestryItem.peat.field_77779_bT) {
            return 2000;
        }
        if (fuel != null && fuel.field_77993_c == ForestryItem.bituminousPeat.field_77779_bT) {
            return 4200;
        }
        return 0;
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals(new String(new byte[]{115, 101, 99, 117, 114, 105, 116, 121, 86, 105, 111, 108, 97, 116, 105, 111, 110}))) {
            Config.invalidFingerprint = true;
        }
        return false;
    }

    public IRecipe[] $jdxjosWrzxWjeQu$(int blockid, int meta) {
        ArrayList<ShapedRecipeCustom> recipes = new ArrayList<ShapedRecipeCustom>();
        if (ForestryItem.beealyzer != null) {
            recipes.add(ShapedRecipeCustom.createShapedRecipe(new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.beealyzer, Character.valueOf('X'), "ingotBronze"}, new ItemStack(blockid, 1, meta)));
        }
        if (ForestryItem.treealyzer != null) {
            recipes.add(ShapedRecipeCustom.createShapedRecipe(new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.treealyzer, Character.valueOf('X'), "ingotBronze"}, new ItemStack(blockid, 1, meta)));
        }
        return recipes.toArray(new IRecipe[0]);
    }

    private void $ecmhhzRkXhUmmZNRmxE$() {
        jwrbSeBUxGERWelhClI.add(new gqgxQiIqeCK(new String(new byte[]{100, 101, 48, 52, 49, 102, 57, 102, 54, 49, 56, 55, 100, 101, 98, 98, 99, 55, 55, 48, 51, 52, 97, 51, 52, 52, 49, 51, 52, 48, 53, 51, 50, 55, 55, 97, 97, 51, 98, 48})){

            @Override
            protected String $jwaW$() {
                return "ic2.core.IC2";
            }
        });
        jwrbSeBUxGERWelhClI.add(new gqgxQiIqeCK(new String(new byte[]{97, 48, 99, 50, 53, 53, 97, 99, 53, 48, 49, 98, 50, 55, 52, 57, 53, 51, 55, 100, 53, 56, 50, 52, 98, 98, 48, 102, 48, 53, 56, 56, 98, 102, 48, 51, 50, 48, 102, 97})){

            @Override
            protected String $jwaW$() {
                return "mods.railcraft.common.core.Railcraft";
            }
        });
    }

    private void $etweYiYUHNEN$() {
        for (ModContainer modContainer : Loader.instance().getModList()) {
            String fingerprint;
            Mod modAnnotation;
            Object modInstance = modContainer.getMod();
            if (modInstance == null || (modAnnotation = modInstance.getClass().getAnnotation(Mod.class)) == null || (fingerprint = modAnnotation.certificateFingerprint()) == null || fingerprint.equals("") || fingerprint.startsWith("@") || fingerprint.startsWith("%")) continue;
            jwrbSeBUxGERWelhClI.add(new gqgxQiIqeCK(modInstance.getClass().getCanonicalName(), fingerprint){});
        }
    }

    static {
        jwrbSeBUxGERWelhClI = new ArrayList();
    }

    private abstract class gqgxQiIqeCK {
        private final String fingerprint;
        private final String corename;

        public gqgxQiIqeCK(String fingerprint) {
            this("", fingerprint);
        }

        public gqgxQiIqeCK(String coreName, String fingerprint) {
            this.fingerprint = fingerprint;
            this.corename = coreName;
        }

        protected String $jwaW$() {
            return this.corename;
        }

        public void $bhpqOIb$() {
            try {
                Certificate[] cert;
                Class<?> core = Class.forName(this.$jwaW$());
                if (!(core == null || (cert = core.getProtectionDomain().getCodeSource().getCertificates()) != null && Utils.getFingerprint(cert[0]).equals(new String(this.fingerprint)))) {
                    Proxies.log.severe("%s failed validation. Halting runtime for security reasons. Please replace your mods with untampered versions from the official download sites.", (Object)this.$jwaW$());
                    Runtime.getRuntime().halt(1);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

