/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.PluginInfo;
import forestry.api.farming.Farmables;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.farming.EventHandlerFarming;
import forestry.farming.FarmHelper;
import forestry.farming.GuiHandlerFarming;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.gadgets.BlockFarm;
import forestry.farming.gadgets.BlockMushroom;
import forestry.farming.gadgets.TileControl;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileGearbox;
import forestry.farming.gadgets.TileHatch;
import forestry.farming.gadgets.TileValve;
import forestry.farming.items.ItemFarmBlock;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.logic.FarmLogicCereal;
import forestry.farming.logic.FarmLogicCocoa;
import forestry.farming.logic.FarmLogicGourd;
import forestry.farming.logic.FarmLogicInfernal;
import forestry.farming.logic.FarmLogicOrchard;
import forestry.farming.logic.FarmLogicPeat;
import forestry.farming.logic.FarmLogicPoale;
import forestry.farming.logic.FarmLogicRubber;
import forestry.farming.logic.FarmLogicShroom;
import forestry.farming.logic.FarmLogicSucculent;
import forestry.farming.logic.FarmLogicVegetable;
import forestry.farming.logic.FarmableGE;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.farming.logic.FarmableGenericSapling;
import forestry.farming.logic.FarmableGourd;
import forestry.farming.logic.FarmableStacked;
import forestry.farming.logic.FarmableVanillaSapling;
import forestry.farming.logic.FarmableVanillaShroom;
import forestry.farming.proxy.ProxyFarming;
import forestry.farming.triggers.TriggerLowFertilizer;
import forestry.farming.triggers.TriggerLowLiquid;
import forestry.farming.triggers.TriggerLowSoil;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginIC2;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

@PluginInfo(pluginID="Farming", name="Farming", author="SirSengir", url="http://forestry.sengir.net/", description="Adds automatic farms and harvesters for a wide variety of products.")
public class PluginForestryFarming
extends NativePlugin {
    @SidedProxy(clientSide="forestry.farming.proxy.ClientProxyFarming", serverSide="forestry.farming.proxy.ProxyFarming")
    public static ProxyFarming proxy;
    public static int modelIdFarmBlock;
    public static ItemStack farmFertilizer;
    public static Trigger lowResourceLiquid50;
    public static Trigger lowResourceLiquid25;
    public static Trigger lowSoil128;
    public static Trigger lowSoil64;
    public static Trigger lowSoil32;
    public static Trigger lowFertilizer50;
    public static Trigger lowFertilizer25;

    @Override
    public boolean isAvailable() {
        return !Config.disableFarming;
    }

    @Override
    public void preInit() {
        super.preInit();
        Farmables.farmInterface = new FarmHelper();
        ForestryBlock.mushroom = new BlockMushroom(Config.getOrCreateBlockIdProperty("mushroom", 1375));
        Farmables.farmables.put("farmArboreal", new ArrayList());
        ((Collection)Farmables.farmables.get("farmArboreal")).add(new FarmableVanillaSapling());
        ((Collection)Farmables.farmables.get("farmArboreal")).add(new FarmableGE());
        Farmables.farmables.put("farmShroom", new ArrayList());
        ((Collection)Farmables.farmables.get("farmShroom")).add(new FarmableVanillaShroom(Block.field_72109_af.field_71990_ca, 0));
        ((Collection)Farmables.farmables.get("farmShroom")).add(new FarmableVanillaShroom(Block.field_72103_ag.field_71990_ca, 0));
        Farmables.farmables.put("farmWheat", new ArrayList());
        ((Collection)Farmables.farmables.get("farmWheat")).add(new FarmableGenericCrop(new ItemStack(Item.field_77690_S), Block.field_72058_az.field_71990_ca, 7));
        Farmables.farmables.put("farmGourd", new ArrayList());
        ((Collection)Farmables.farmables.get("farmGourd")).add(new FarmableGourd(new ItemStack(Item.field_77739_bg), new ItemStack(Block.field_71996_bs), new ItemStack(Block.field_72061_ba)));
        ((Collection)Farmables.farmables.get("farmGourd")).add(new FarmableGourd(new ItemStack(Item.field_77740_bh), new ItemStack(Block.field_71999_bt), new ItemStack(Block.field_71997_br)));
        Farmables.farmables.put("farmInfernal", new ArrayList());
        ((Collection)Farmables.farmables.get("farmInfernal")).add(new FarmableGenericCrop(new ItemStack(Item.field_77727_br), Block.field_72094_bD.field_71990_ca, 3));
        Farmables.farmables.put("farmPoales", new ArrayList());
        ((Collection)Farmables.farmables.get("farmPoales")).add(new FarmableStacked(Block.field_72040_aX.field_71990_ca, 3));
        Farmables.farmables.put("farmSucculentes", new ArrayList());
        ((Collection)Farmables.farmables.get("farmSucculentes")).add(new FarmableStacked(Block.field_72038_aV.field_71990_ca, 3));
        Farmables.farmables.put("farmVegetables", new ArrayList());
        ((Collection)Farmables.farmables.get("farmVegetables")).add(new FarmableGenericCrop(new ItemStack(Item.field_82794_bL), Block.field_82514_ch.field_71990_ca, 7));
        ((Collection)Farmables.farmables.get("farmVegetables")).add(new FarmableGenericCrop(new ItemStack(Item.field_82797_bK), Block.field_82513_cg.field_71990_ca, 7));
        ForestryBlock.farm = new BlockFarm(Config.getOrCreateBlockIdProperty("farm", 1395)).func_71864_b("ffarm");
        Item.field_77698_e[ForestryBlock.farm.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.farm.field_71990_ca] = new ItemFarmBlock(ForestryBlock.farm.field_71990_ca - 256, "ffarm");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.farm, (String)"pickaxe", (int)0);
        proxy.initializeRendering();
        lowResourceLiquid50 = new TriggerLowLiquid(621, 0.5f);
        lowResourceLiquid25 = new TriggerLowLiquid(622, 0.25f);
        lowSoil128 = new TriggerLowSoil(623, 128);
        lowSoil64 = new TriggerLowSoil(624, 64);
        lowSoil32 = new TriggerLowSoil(625, 32);
        lowFertilizer50 = new TriggerLowFertilizer(626, 0.5f);
        lowFertilizer25 = new TriggerLowFertilizer(627, 0.25f);
        CircuitLayout layoutManaged = new CircuitLayout("farms.managed");
        ChipsetManager.circuitRegistry.registerLayout(layoutManaged);
        CircuitLayout layoutManual = new CircuitLayout("farms.manual");
        ChipsetManager.circuitRegistry.registerLayout(layoutManual);
    }

    @Override
    public void doInit() {
        super.doInit();
        proxy.addLocalizations();
        GameRegistry.registerTileEntity(TileFarmPlain.class, (String)"forestry.Farm");
        GameRegistry.registerTileEntity(TileGearbox.class, (String)"forestry.FarmGearbox");
        GameRegistry.registerTileEntity(TileHatch.class, (String)"forestry.FarmHatch");
        GameRegistry.registerTileEntity(TileValve.class, (String)"forestry.FarmValve");
        GameRegistry.registerTileEntity(TileControl.class, (String)"forestry.FarmControl");
        Circuit.farmArborealManaged = new CircuitFarmLogic("managedArboreal", FarmLogicArboreal.class, new String[]{"Arboreal Plants"});
        Circuit.farmShroomManaged = new CircuitFarmLogic("managedShroom", FarmLogicShroom.class, new String[]{"Mushrooms"});
        Circuit.farmPeatManaged = new CircuitFarmLogic("managedPeat", FarmLogicPeat.class, new String[]{"Peat Bog"});
        Circuit.farmCerealManaged = new CircuitFarmLogic("managedCereal", FarmLogicCereal.class, new String[]{"Crops"});
        Circuit.farmVegetableManaged = new CircuitFarmLogic("managedVegetable", FarmLogicVegetable.class, new String[]{"Vegetables"});
        Circuit.farmInfernalManaged = new CircuitFarmLogic("managedInfernal", FarmLogicInfernal.class, new String[]{"Infernal Crops"});
        Circuit.farmPeatManual = new CircuitFarmLogic("manualPeat", FarmLogicPeat.class, new String[]{"Peat Bog"}).setManual();
        Circuit.farmShroomManual = new CircuitFarmLogic("manualShroom", FarmLogicShroom.class, new String[]{"Mushrooms"}).setManual();
        Circuit.farmCerealManual = new CircuitFarmLogic("manualCereal", FarmLogicCereal.class, new String[]{"Crops"}).setManual();
        Circuit.farmVegetableManual = new CircuitFarmLogic("manualVegetable", FarmLogicVegetable.class, new String[]{"Vegetables"}).setManual();
        Circuit.farmSucculentManual = new CircuitFarmLogic("manualSucculent", FarmLogicSucculent.class, new String[]{"Succulents"}).setManual();
        Circuit.farmPoalesManual = new CircuitFarmLogic("manualPoales", FarmLogicPoale.class, new String[]{"Reeds"}).setManual();
        Circuit.farmGourdManual = new CircuitFarmLogic("manualGourd", FarmLogicGourd.class, new String[]{"Gourds"}).setManual();
        Circuit.farmCocoaManual = new CircuitFarmLogic("manualCocoa", FarmLogicCocoa.class, new String[]{"Cocoa Plantation"}).setManual();
        Circuit.farmOrchardManual = new CircuitFarmLogic("manualOrchard", FarmLogicOrchard.class, new String[]{"Orchard"});
        Circuit.farmRubberManual = new CircuitFarmLogic("manualRubber", FarmLogicRubber.class, new String[]{"Rubber Plantation"});
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerFarming());
    }

    @Override
    public void postInit() {
        super.postInit();
        farmFertilizer = new ItemStack(ForestryItem.fertilizerCompound);
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-farmable-sapling")) {
            String[] tokens = message.getStringValue().split("@");
            String errormsg = String.format("Received an invalid 'add-farmable-sapling' request '%s' from mod %s", message.getStringValue(), message.getSender());
            if (tokens.length != 2) {
                Proxies.log.info(errormsg + ".");
                return true;
            }
            if (!Farmables.farmables.containsKey(tokens[0])) {
                Proxies.log.info("%s for non-existent farm %s.", errormsg, tokens[0]);
                return true;
            }
            String[] items = tokens[1].split("[\\.]+");
            if (items.length != 2 && items.length != 4) {
                Proxies.log.info("%s for farm '%s': id definitions did not match.", errormsg, tokens[0]);
                return true;
            }
            try {
                if (items.length == 2) {
                    ((Collection)Farmables.farmables.get(tokens[0])).add(new FarmableGenericSapling(Integer.parseInt(items[0]), Integer.parseInt(items[1])));
                } else {
                    ((Collection)Farmables.farmables.get(tokens[0])).add(new FarmableGenericSapling(Integer.parseInt(items[0]), Integer.parseInt(items[1]), new ItemStack[]{new ItemStack(Integer.parseInt(items[2]), 1, Integer.parseInt(items[3]))}));
                }
            }
            catch (Exception ex) {
                Proxies.log.info("%s for farm '%s': ", errormsg, tokens[0], ex.getMessage());
            }
            return true;
        }
        if (message.key.equals("add-farmable-crop")) {
            String[] tokens = message.getStringValue().split("@");
            String errormsg = String.format("Received an invalid 'add-farmable-crop' request '%s' from mod %s", message.getStringValue(), message.getSender());
            if (tokens.length != 2) {
                Proxies.log.info(errormsg + ".");
                return true;
            }
            if (!Farmables.farmables.containsKey(tokens[0])) {
                Proxies.log.info("%s for non-existent farm %s.", errormsg, tokens[0]);
                return true;
            }
            String[] items = tokens[1].split("[\\.]+");
            if (items.length != 4) {
                Proxies.log.info("%s for farm '%s': id definitions did not match.", errormsg, tokens[0]);
                return true;
            }
            try {
                ((Collection)Farmables.farmables.get(tokens[0])).add(new FarmableGenericCrop(new ItemStack(Integer.parseInt(items[0]), 1, Integer.parseInt(items[1])), Integer.parseInt(items[2]), Integer.parseInt(items[3])));
            }
            catch (Exception ex) {
                Proxies.log.info("%s for farm '%s': ", errormsg, tokens[0], ex.getMessage());
            }
            return true;
        }
        return false;
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFarming();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        ItemStack basic = new ItemStack(ForestryBlock.farm, 1, 0);
        for (TileFarm.EnumFarmBlock block : TileFarm.EnumFarmBlock.values()) {
            NBTTagCompound compound = new NBTTagCompound("tag");
            block.saveToCompound(compound);
            basic.func_77982_d((NBTTagCompound)compound.func_74737_b());
            CraftingManager.func_77594_a().func_77592_b().add(ShapedRecipeCustom.createShapedRecipe(new Object[]{"I#I", "WCW", Character.valueOf('#'), block.getCraftingIngredient(), Character.valueOf('W'), "slabWood", Character.valueOf('C'), new ItemStack(ForestryItem.tubes, 1, 1), Character.valueOf('I'), "ingotCopper"}, basic.func_77946_l()));
        }
        ItemStack gearbox = new ItemStack(ForestryBlock.farm, 1, 2);
        CraftingManager.func_77594_a().func_77592_b().add(ShapedRecipeCustom.createShapedRecipe(new Object[]{" # ", "TTT", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin"}, gearbox).setPreserveNBT());
        ItemStack hatch = new ItemStack(ForestryBlock.farm, 1, 3);
        CraftingManager.func_77594_a().func_77592_b().add(ShapedRecipeCustom.createShapedRecipe(new Object[]{" # ", "TDT", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin", Character.valueOf('D'), Block.field_72005_bk}, hatch).setPreserveNBT());
        ItemStack valve = new ItemStack(ForestryBlock.farm, 1, 4);
        CraftingManager.func_77594_a().func_77592_b().add(ShapedRecipeCustom.createShapedRecipe(new Object[]{" # ", "XTX", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin", Character.valueOf('X'), Block.field_71946_M}, valve).setPreserveNBT());
        ItemStack control = new ItemStack(ForestryBlock.farm, 1, 5);
        CraftingManager.func_77594_a().func_77592_b().add(ShapedRecipeCustom.createShapedRecipe(new Object[]{" # ", "XTX", Character.valueOf('#'), basic, Character.valueOf('T'), new ItemStack(ForestryItem.tubes, 1, 4), Character.valueOf('X'), Item.field_77767_aC}, control).setPreserveNBT());
        ICircuitLayout layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
        ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
        ChipsetManager.solderManager.addRecipe(layoutManaged, new ItemStack(ForestryItem.tubes, 1, 0), Circuit.farmArborealManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, new ItemStack(ForestryItem.tubes, 1, 1), Circuit.farmPeatManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, new ItemStack(ForestryItem.tubes, 1, 2), Circuit.farmCerealManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, new ItemStack(ForestryItem.tubes, 1, 3), Circuit.farmVegetableManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, new ItemStack(ForestryItem.tubes, 1, 7), Circuit.farmInfernalManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, new ItemStack(ForestryItem.tubes, 1, 10), Circuit.farmShroomManaged);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 0), Circuit.farmOrchardManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 1), Circuit.farmPeatManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 2), Circuit.farmCerealManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 3), Circuit.farmVegetableManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 4), Circuit.farmSucculentManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 5), Circuit.farmPoalesManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 6), Circuit.farmGourdManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 10), Circuit.farmShroomManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 11), Circuit.farmCocoaManual);
        if (PluginIC2.resin != null && PluginIC2.rubberwood != null) {
            ChipsetManager.solderManager.addRecipe(layoutManual, new ItemStack(ForestryItem.tubes, 1, 8), Circuit.farmRubberManual);
        }
    }
}

