/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.event.FMLInterModComms;
import forestry.api.core.IPlugin;
import forestry.api.core.PluginInfo;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.RecipeUtil;
import ic2.api.item.Items;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@PluginInfo(pluginID="IC2", name="IndustrialCraft2", author="SirSengir", url="http://forestry.sengir.net/", description="Compatibility plugin for IC2.")
public class PluginIC2
implements IPlugin {
    public static PluginIC2 instance;
    public static Configuration config;
    public static boolean ignore;
    public static ItemStack plantBall;
    public static ItemStack compressedPlantBall;
    public static ItemStack wrench;
    public static ItemStack treetap;
    public static ItemStack resin;
    public static ItemStack rubbersapling;
    public static ItemStack rubberwood;
    public static ItemStack rubberleaves;
    public static ItemStack fuelcanFilled;
    public static ItemStack fuelcanEmpty;
    public static ItemStack emptyCell;
    public static ItemStack lavaCell;
    public static ItemStack waterCell;
    public static ItemStack rubber;
    public static ItemStack scrap;
    public static ItemStack uum;
    public static int fuelcanMeta;

    public PluginIC2() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("IC2");
    }

    @Override
    public void doInit() {
        config = Config.config;
        this.initLiquidContainers();
        this.initRubberChain();
        this.initFermentation();
        this.initCrates();
        this.registerBackpackItems();
        if (rubbersapling != null && resin != null) {
            String imc = String.format("farmArboreal@%s.%s.%s.%s", PluginIC2.rubbersapling.field_77993_c, rubbersapling.func_77960_j(), PluginIC2.resin.field_77993_c, resin.func_77960_j());
            Proxies.log.finest("Sending IMC '%s'.", (Object)imc);
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)imc);
        }
    }

    private void initFermentation() {
        plantBall = Items.getItem("plantBall");
        compressedPlantBall = Items.getItem("compressedPlantBall");
        if (plantBall == null || compressedPlantBall == null) {
            Proxies.log.fine("No IC2 plantballs found.");
            return;
        }
        RecipeUtil.injectLeveledRecipe(plantBall, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat") * 4, new ItemStack(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(compressedPlantBall, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat") * 5, new ItemStack(ForestryItem.liquidBiomass));
    }

    private void initLiquidContainers() {
        emptyCell = Items.getItem("cell");
        lavaCell = Items.getItem("lavaCell");
        waterCell = Items.getItem("waterCell");
        if (emptyCell == null || lavaCell == null || waterCell == null) {
            Proxies.log.fine("Any of the following IC2 items could not be found: empty cell, water cell, lava cell. Skipped adding IC2 liquid containers.");
            return;
        }
        LiquidHelper.injectTinContainer("Lava", 1000, lavaCell, emptyCell);
        LiquidHelper.injectTinContainer("Water", 1000, waterCell, emptyCell);
        if (GameMode.getGameMode().getRecipeBogEarthOutputCans().field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getRecipeBogEarthOutputCans(), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), waterCell, Character.valueOf('Y'), Block.field_71939_E});
        }
    }

    private void initRubberChain() {
        treetap = Items.getItem("treetap");
        resin = Items.getItem("resin");
        rubberwood = Items.getItem("rubberWood");
        rubbersapling = Items.getItem("rubberSapling");
        rubberleaves = Items.getItem("rubberLeaves");
        fuelcanFilled = Items.getItem("filledFuelCan");
        fuelcanEmpty = Items.getItem("fuelCan");
        if (treetap == null || resin == null || rubberwood == null || rubbersapling == null || rubberleaves == null || fuelcanFilled == null || fuelcanEmpty == null) {
            Proxies.log.fine("Any of the following IC2 blocks and items could not be found: resin, rubber wood, saplings or leaves, filled fuel cans, empty fuel cans. Skipped adding rubber chain.");
            return;
        }
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.propolis), resin);
        ItemStack fuelcanStack = new ItemStack(PluginIC2.fuelcanFilled.field_77993_c, 1, 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("value", 15288);
        fuelcanStack.func_77982_d(compound);
        RecipeManagers.bottlerManager.addRecipe(20, LiquidHelper.getLiquid("ethanol", 2000), fuelcanEmpty, fuelcanStack);
        RecipeUtil.injectLeveledRecipe(rubbersapling, GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), new ItemStack(ForestryItem.liquidBiomass));
        BackpackManager.backpackItems[2].add(rubbersapling);
        BackpackManager.backpackItems[2].add(rubberleaves);
    }

    private void initCrates() {
        resin = Items.getItem("resin");
        rubber = Items.getItem("rubber");
        scrap = Items.getItem("scrap");
        uum = Items.getItem("matter");
        if (resin == null || rubber == null || scrap == null || uum == null) {
            Proxies.log.fine("Any of the following IC2 blocks and items could not be found: resin, rubber, scrap or uu matter. Skipped adding crates.");
            return;
        }
        ForestryItem.cratedResin.setContained(new ItemStack((Item)ForestryItem.cratedResin), resin);
        ForestryItem.cratedRubber.setContained(new ItemStack((Item)ForestryItem.cratedRubber), rubber);
        ForestryItem.cratedScrap.setContained(new ItemStack((Item)ForestryItem.cratedScrap), scrap);
        ForestryItem.cratedUUM.setContained(new ItemStack((Item)ForestryItem.cratedUUM), uum);
    }

    private void registerBackpackItems() {
        if (BackpackManager.backpackItems == null) {
            return;
        }
        if (resin != null) {
            ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(resin);
        }
        if (rubber != null) {
            ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(rubber);
        }
    }

    @Override
    public void preInit() {
    }

    @Override
    public void postInit() {
    }
}

