/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers;

import com.nisovin.shopkeepers.ShopkeepersPlugin;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.InventoryHolder;

class ChestProtectListener
implements Listener {
    ShopkeepersPlugin plugin;

    ChestProtectListener(ShopkeepersPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().getType() == Material.CHEST) {
            Player player = event.getPlayer();
            Block block = event.getBlock();
            if (!event.getPlayer().hasPermission("shopkeeper.bypass")) {
                if (this.plugin.isChestProtected(player, block)) {
                    event.setCancelled(true);
                    return;
                }
                BlockFace[] blockFaceArray = this.plugin.chestProtectFaces;
                int n = this.plugin.chestProtectFaces.length;
                int n2 = 0;
                while (n2 < n) {
                    BlockFace face = blockFaceArray[n2];
                    if (block.getRelative(face).getType() == Material.CHEST && this.plugin.isChestProtected(player, block.getRelative(face))) {
                        event.setCancelled(true);
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        int id = block.getTypeId();
        if (id == Material.CHEST.getId()) {
            Player player = event.getPlayer();
            BlockFace[] blockFaceArray = this.plugin.chestProtectFaces;
            int n = this.plugin.chestProtectFaces.length;
            int n2 = 0;
            while (n2 < n) {
                BlockFace face = blockFaceArray[n2];
                Block b = block.getRelative(face);
                if (b.getType() == Material.CHEST && this.plugin.isChestProtected(player, b)) {
                    event.setCancelled(true);
                    return;
                }
                ++n2;
            }
        } else if (id == 154) {
            Player player = event.getPlayer();
            BlockFace[] blockFaceArray = this.plugin.hopperProtectFaces;
            int n = this.plugin.hopperProtectFaces.length;
            int n3 = 0;
            while (n3 < n) {
                BlockFace face = blockFaceArray[n3];
                Block b = block.getRelative(face);
                if (b.getType() == Material.CHEST && this.plugin.isChestProtected(player, b)) {
                    event.setCancelled(true);
                    return;
                }
                ++n3;
            }
        } else if (id == Material.RAILS.getId() || id == Material.POWERED_RAIL.getId() || id == Material.DETECTOR_RAIL.getId() || id == 157) {
            Player player = event.getPlayer();
            Block b = block.getRelative(BlockFace.UP);
            if (b.getType() == Material.CHEST && this.plugin.isChestProtected(player, b)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    void onInventoryMoveItem(InventoryMoveItemEvent event) {
        Block block;
        InventoryHolder holder;
        if (event.getSource() != null && (holder = event.getSource().getHolder()) != null && holder instanceof Chest && this.plugin.isChestProtected(null, block = ((Chest)holder).getBlock())) {
            event.setCancelled(true);
        }
    }
}

