/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers;

import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.ShopObjectType;
import com.nisovin.shopkeepers.Shopkeeper;
import com.nisovin.shopkeepers.ShopkeeperType;
import com.nisovin.shopkeepers.ShopkeepersPlugin;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Attachable;
import org.bukkit.plugin.Plugin;

public class CreateListener
implements Listener {
    ShopkeepersPlugin plugin;

    public CreateListener(ShopkeepersPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemMeta meta;
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            return;
        }
        final Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        final ItemStack inHand = player.getItemInHand();
        if (inHand == null || inHand.getTypeId() != Settings.shopCreationItem || inHand.getDurability() != Settings.shopCreationItemData) {
            return;
        }
        if (!(Settings.shopCreationItemName == null || Settings.shopCreationItemName.isEmpty() || (meta = inHand.getItemMeta()).hasDisplayName() && meta.getDisplayName().equals(Settings.shopCreationItemName))) {
            return;
        }
        String playerName = player.getName();
        if (event.getAction() == Action.RIGHT_CLICK_AIR) {
            if (player.isSneaking()) {
                ShopObjectType shopObjectType = this.plugin.selectedShopObjectType.get(playerName);
                if ((shopObjectType = ShopObjectType.next(player, shopObjectType)) != null) {
                    this.plugin.selectedShopObjectType.put(playerName, shopObjectType);
                    if (shopObjectType == ShopObjectType.VILLAGER) {
                        this.plugin.sendMessage(player, Settings.msgSelectedVillagerShop);
                    } else if (shopObjectType == ShopObjectType.SIGN) {
                        this.plugin.sendMessage(player, Settings.msgSelectedSignShop);
                    } else if (shopObjectType == ShopObjectType.WITCH) {
                        this.plugin.sendMessage(player, Settings.msgSelectedWitchShop);
                    }
                }
            } else {
                ShopkeeperType shopType = this.plugin.selectedShopType.get(playerName);
                if ((shopType = ShopkeeperType.next(player, shopType)) != null) {
                    this.plugin.selectedShopType.put(playerName, shopType);
                    if (shopType == ShopkeeperType.PLAYER_NORMAL) {
                        this.plugin.sendMessage(player, Settings.msgSelectedNormalShop);
                    } else if (shopType == ShopkeeperType.PLAYER_BOOK) {
                        this.plugin.sendMessage(player, Settings.msgSelectedBookShop);
                    } else if (shopType == ShopkeeperType.PLAYER_BUY) {
                        this.plugin.sendMessage(player, Settings.msgSelectedBuyShop);
                    } else if (shopType == ShopkeeperType.PLAYER_TRADE) {
                        this.plugin.sendMessage(player, Settings.msgSelectedTradeShop);
                    }
                }
            }
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block block = event.getClickedBlock();
            if (!(block.getType() != Material.CHEST || this.plugin.selectedChest.containsKey(playerName) && this.plugin.selectedChest.get(playerName).equals(block))) {
                if (event.useInteractedBlock() != Event.Result.DENY) {
                    List<String> list = this.plugin.recentlyPlacedChests.get(playerName);
                    if (Settings.requireChestRecentlyPlaced && (list == null || !list.contains(String.valueOf(block.getWorld().getName()) + "," + block.getX() + "," + block.getY() + "," + block.getZ()))) {
                        this.plugin.sendMessage(player, Settings.msgChestNotPlaced);
                    } else {
                        this.plugin.selectedChest.put(playerName, event.getClickedBlock());
                        this.plugin.sendMessage(player, Settings.msgSelectedChest);
                    }
                } else {
                    ShopkeepersPlugin.debug("Right-click on chest prevented, player " + player.getName() + " at " + block.getLocation().toString());
                }
                event.setCancelled(true);
            } else if (this.plugin.selectedChest.containsKey(playerName)) {
                Block chest = this.plugin.selectedChest.get(playerName);
                if (!chest.getWorld().equals(block.getWorld()) || (int)chest.getLocation().distance(block.getLocation()) > Settings.maxChestDistance) {
                    this.plugin.sendMessage(player, Settings.msgChestTooFar);
                } else {
                    Block sign;
                    ShopObject obj;
                    ShopObjectType objType;
                    ShopkeeperType shopType = this.plugin.selectedShopType.get(playerName);
                    if (shopType == null) {
                        shopType = ShopkeeperType.next(player, null);
                    }
                    if ((objType = this.plugin.selectedShopObjectType.get(playerName)) == null) {
                        objType = ShopObjectType.next(player, null);
                    }
                    if (objType == ShopObjectType.SIGN && !this.validSignFace(event.getBlockFace())) {
                        return;
                    }
                    if (shopType != null && objType != null && (obj = objType.createObject()) != null && (sign = event.getClickedBlock().getRelative(event.getBlockFace())).getType() == Material.AIR) {
                        Shopkeeper shopkeeper = this.plugin.createNewPlayerShopkeeper(player, chest, sign.getLocation(), shopType, obj);
                        if (shopkeeper != null) {
                            if (objType == ShopObjectType.SIGN) {
                                sign.setType(Material.WALL_SIGN);
                                Sign signState = (Sign)sign.getState();
                                ((Attachable)signState.getData()).setFacingDirection(event.getBlockFace());
                                signState.setLine(0, Settings.signShopFirstLine);
                                signState.setLine(2, playerName);
                                signState.update();
                                event.setCancelled(true);
                            }
                            this.plugin.sendCreatedMessage(player, shopType);
                        }
                        this.plugin.selectedShopType.remove(playerName);
                        this.plugin.selectedChest.remove(playerName);
                        event.setCancelled(true);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                if (inHand.getAmount() <= 1) {
                                    player.setItemInHand(null);
                                } else {
                                    inHand.setAmount(inHand.getAmount() - 1);
                                    player.setItemInHand(inHand);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private boolean validSignFace(BlockFace face) {
        return face == BlockFace.NORTH || face == BlockFace.SOUTH || face == BlockFace.EAST || face == BlockFace.WEST;
    }
}

