/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers;

import com.nisovin.shopkeepers.EditorClickResult;
import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.ShopkeeperType;
import com.nisovin.shopkeepers.ShopkeepersPlugin;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Shopkeeper {
    protected ShopObject shopObject;
    protected String world;
    protected int x;
    protected int y;
    protected int z;
    protected String name;

    public Shopkeeper(ConfigurationSection config) {
        this.load(config);
    }

    public Shopkeeper(Location location, ShopObject obj) {
        this.world = location.getWorld().getName();
        this.x = location.getBlockX();
        this.y = location.getBlockY();
        this.z = location.getBlockZ();
        this.shopObject = obj;
        this.shopObject.setShopkeeper(this);
    }

    public void load(ConfigurationSection config) {
        this.name = config.getString("name");
        this.world = config.getString("world");
        this.x = config.getInt("x");
        this.y = config.getInt("y");
        this.z = config.getInt("z");
        this.shopObject = ShopObject.getShopObject(config);
        this.shopObject.setShopkeeper(this);
        this.shopObject.load(config);
    }

    public void save(ConfigurationSection config) {
        config.set("name", (Object)this.name);
        config.set("world", (Object)this.world);
        config.set("x", (Object)this.x);
        config.set("y", (Object)this.y);
        config.set("z", (Object)this.z);
        this.shopObject.save(config);
    }

    public abstract ShopkeeperType getType();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.shopObject.setName(name);
    }

    public ShopObject getShopObject() {
        return this.shopObject;
    }

    public boolean needsSpawned() {
        return this.shopObject.needsSpawned();
    }

    public boolean spawn() {
        return this.shopObject.spawn(this.world, this.x, this.y, this.z);
    }

    public boolean isActive() {
        return this.shopObject.isActive();
    }

    public boolean teleport() {
        return this.shopObject.check(this.world, this.x, this.y, this.z);
    }

    public void remove() {
        this.shopObject.despawn();
    }

    protected void delete() {
        this.shopObject.delete();
    }

    public String getChunk() {
        return String.valueOf(this.world) + "," + (this.x >> 4) + "," + (this.z >> 4);
    }

    public String getPositionString() {
        return String.valueOf(this.world) + "," + this.x + "," + this.y + "," + this.z;
    }

    public Location getActualLocation() {
        return this.shopObject.getActualLocation();
    }

    public String getWorldName() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getId() {
        return this.shopObject.getId();
    }

    public abstract List<ItemStack[]> getRecipes();

    public abstract boolean onEdit(Player var1);

    public EditorClickResult onEditorClick(InventoryClickEvent event) {
        if (event.getRawSlot() == 8) {
            event.setCancelled(true);
            this.saveEditor(event.getInventory(), (Player)event.getWhoClicked());
            return EditorClickResult.SET_NAME;
        }
        if (event.getRawSlot() == 17) {
            if (event.getCursor() != null && event.getCursor().getType() != Material.AIR) {
                this.shopObject.setItem(event.getCursor().clone());
            } else {
                this.shopObject.cycleType();
                ItemStack typeItem = this.shopObject.getTypeItem();
                if (typeItem != null) {
                    event.getInventory().setItem(17, this.setItemStackName(typeItem, Settings.msgButtonType));
                }
            }
            event.setCancelled(true);
            return EditorClickResult.SAVE_AND_CONTINUE;
        }
        if (event.getRawSlot() == 26) {
            this.delete();
            event.setCancelled(true);
            return EditorClickResult.DELETE_SHOPKEEPER;
        }
        return EditorClickResult.NOTHING;
    }

    protected abstract void saveEditor(Inventory var1, Player var2);

    public abstract void onEditorClose(InventoryCloseEvent var1);

    public abstract void onPurchaseClick(InventoryClickEvent var1);

    protected void closeInventory(HumanEntity player) {
        ShopkeepersPlugin.plugin.closeInventory(player);
    }

    protected void setActionButtons(Inventory inv) {
        inv.setItem(8, this.createItemStackWithName(Settings.nameItem, Settings.msgButtonName));
        ItemStack typeItem = this.shopObject.getTypeItem();
        if (typeItem != null) {
            inv.setItem(17, this.setItemStackName(typeItem, Settings.msgButtonType));
        }
        inv.setItem(26, this.createItemStackWithName(Settings.deleteItem, Settings.msgButtonDelete));
    }

    protected ItemStack createItemStackWithName(int type, String name) {
        ItemStack item = new ItemStack(type, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        item.setItemMeta(meta);
        return item;
    }

    protected ItemStack setItemStackName(ItemStack item, String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        item.setItemMeta(meta);
        return item;
    }
}

