/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.shopobjects;

import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import com.nisovin.shopkeepers.shoptypes.PlayerShopkeeper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class BlockShop
extends ShopObject {
    @Override
    public void load(ConfigurationSection config) {
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set("object", (Object)"block");
    }

    @Override
    public boolean needsSpawned() {
        return false;
    }

    @Override
    public boolean spawn(String world, int x, int y, int z) {
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public String getId() {
        return "block" + this.shopkeeper.getWorldName() + "," + this.shopkeeper.getX() + "," + this.shopkeeper.getY() + "," + this.shopkeeper.getZ();
    }

    @Override
    public Location getActualLocation() {
        World w = Bukkit.getWorld((String)this.shopkeeper.getWorldName());
        if (w == null) {
            return null;
        }
        return new Location(w, (double)this.shopkeeper.getX(), (double)this.shopkeeper.getY(), (double)this.shopkeeper.getZ());
    }

    @Override
    public void setName(String name) {
        Block block;
        Location loc = this.getActualLocation();
        if (loc != null && ((block = loc.getBlock()).getType() == Material.WALL_SIGN || block.getType() == Material.SIGN_POST)) {
            Sign sign = (Sign)block.getState();
            sign.setLine(0, Settings.signShopFirstLine);
            sign.setLine(1, name);
            if (this.shopkeeper instanceof PlayerShopkeeper) {
                sign.setLine(2, ((PlayerShopkeeper)this.shopkeeper).getOwner());
            }
            sign.update();
        }
    }

    @Override
    public void setItem(ItemStack item) {
    }

    @Override
    public boolean check(String world, int x, int y, int z) {
        return false;
    }

    @Override
    public void despawn() {
    }

    @Override
    public void delete() {
        World w = Bukkit.getWorld((String)this.shopkeeper.getWorldName());
        if (w != null) {
            w.getBlockAt(this.shopkeeper.getX(), this.shopkeeper.getY(), this.shopkeeper.getZ()).setType(Material.AIR);
        }
    }

    @Override
    public ItemStack getTypeItem() {
        return null;
    }

    @Override
    public void cycleType() {
    }
}

