/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.shopobjects;

import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.ShopkeepersPlugin;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public abstract class LivingEntityShop
extends ShopObject {
    protected LivingEntity entity;
    private String uuid;
    private int respawnAttempts = 0;

    @Override
    public void load(ConfigurationSection config) {
        if (config.contains("uuid")) {
            this.uuid = config.getString("uuid");
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.entity != null) {
            config.set("uuid", (Object)this.entity.getUniqueId().toString());
        }
    }

    protected abstract EntityType getEntityType();

    @Override
    public boolean needsSpawned() {
        return true;
    }

    @Override
    public boolean spawn(String world, int x, int y, int z) {
        World w = Bukkit.getWorld((String)world);
        Location loc = new Location(w, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        if (this.uuid != null && !this.uuid.isEmpty()) {
            Entity[] entities;
            Entity[] entityArray = entities = loc.getChunk().getEntities();
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Entity e = entityArray[n2];
                if (e.getType() == this.getEntityType() && e.getUniqueId().toString().equalsIgnoreCase(this.uuid) && e.isValid()) {
                    this.entity = (LivingEntity)e;
                    this.entity.setHealth(this.entity.getMaxHealth());
                    String name = this.shopkeeper.getName();
                    if (name != null && !name.isEmpty()) {
                        ShopkeepersPlugin.getVolatileCode().setEntityName(this.entity, name);
                    }
                    this.entity.teleport(loc);
                    break;
                }
                ++n2;
            }
        }
        if (this.entity == null || !this.entity.isValid()) {
            this.entity = (LivingEntity)w.spawnEntity(loc, this.getEntityType());
            this.uuid = this.entity.getUniqueId().toString();
            String name = this.shopkeeper.getName();
            if (name != null && !name.isEmpty() && Settings.showNameplates) {
                if (Settings.nameplatePrefix != null && !Settings.nameplatePrefix.isEmpty()) {
                    name = String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)Settings.nameplatePrefix)) + name;
                }
                ShopkeepersPlugin.getVolatileCode().setEntityName(this.entity, name);
            }
        }
        if (this.entity != null && this.entity.isValid()) {
            this.entity.setRemoveWhenFarAway(false);
            this.overwriteAI();
            return true;
        }
        if (this.entity != null) {
            this.entity.remove();
            this.entity = null;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.entity != null && !this.entity.isDead();
    }

    @Override
    public String getId() {
        if (this.entity != null) {
            return "entity" + this.entity.getEntityId();
        }
        return null;
    }

    @Override
    public Location getActualLocation() {
        if (this.entity == null || !this.entity.isValid()) {
            return null;
        }
        return this.entity.getLocation();
    }

    @Override
    public void setName(String name) {
        if (this.entity != null && this.entity.isValid() && Settings.showNameplates) {
            if (Settings.nameplatePrefix != null && !Settings.nameplatePrefix.isEmpty()) {
                name = String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)Settings.nameplatePrefix)) + name;
            }
            if (name.length() > 32) {
                name = name.substring(0, 32);
            }
            ShopkeepersPlugin.getVolatileCode().setEntityName(this.entity, name);
        }
    }

    @Override
    public void setItem(ItemStack item) {
        if (this.entity != null && this.entity.isValid()) {
            this.entity.getEquipment().setItemInHand(item);
            this.entity.getEquipment().setItemInHandDropChance(0.0f);
        }
    }

    @Override
    public boolean check(String world, int x, int y, int z) {
        if (this.entity == null || !this.entity.isValid()) {
            boolean spawned = this.spawn(world, x, y, z);
            ShopkeepersPlugin.debug("Shopkeeper (" + world + "," + x + "," + y + "," + z + ") missing, respawn " + (spawned ? "successful" : "failed"));
            if (spawned) {
                this.respawnAttempts = 0;
                return true;
            }
            return ++this.respawnAttempts > 5;
        }
        World w = Bukkit.getWorld((String)world);
        Location loc = new Location(w, (double)x + 0.5, (double)y, (double)z + 0.5, this.entity.getLocation().getYaw(), this.entity.getLocation().getPitch());
        if (this.entity.getLocation().distanceSquared(loc) > 0.4) {
            this.entity.teleport(loc);
            this.overwriteAI();
            ShopkeepersPlugin.debug("Shopkeeper (" + world + "," + x + "," + y + "," + z + ") out of place, teleported back");
        }
        return false;
    }

    @Override
    public void despawn() {
        if (this.entity != null) {
            this.entity.remove();
            this.entity.setHealth(0);
            this.entity = null;
        }
    }

    @Override
    public void delete() {
        this.despawn();
    }

    protected void overwriteAI() {
        ShopkeepersPlugin.getVolatileCode().overwriteLivingEntityAI(this.entity);
    }
}

