/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.shopobjects;

import com.nisovin.shopkeepers.Shopkeeper;
import com.nisovin.shopkeepers.shopobjects.BlockShop;
import com.nisovin.shopkeepers.shopobjects.VillagerShop;
import com.nisovin.shopkeepers.shopobjects.WitchShop;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public abstract class ShopObject {
    protected Shopkeeper shopkeeper;

    public void setShopkeeper(Shopkeeper shopkeeper) {
        this.shopkeeper = shopkeeper;
    }

    public abstract void load(ConfigurationSection var1);

    public abstract void save(ConfigurationSection var1);

    public abstract boolean needsSpawned();

    public abstract boolean spawn(String var1, int var2, int var3, int var4);

    public abstract boolean isActive();

    public abstract String getId();

    public abstract Location getActualLocation();

    public abstract void setName(String var1);

    public abstract void setItem(ItemStack var1);

    public abstract boolean check(String var1, int var2, int var3, int var4);

    public abstract void despawn();

    public abstract void delete();

    public abstract ItemStack getTypeItem();

    public abstract void cycleType();

    public static ShopObject getShopObject(ConfigurationSection config) {
        String obj = config.getString("object");
        if (obj != null) {
            if (obj.equals("villager")) {
                return new VillagerShop();
            }
            if (obj.equals("block")) {
                return new BlockShop();
            }
            if (obj.equals("witch")) {
                return new WitchShop();
            }
        }
        return new VillagerShop();
    }
}

