/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers;

import com.nisovin.shopkeepers.EditorClickResult;
import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.Shopkeeper;
import com.nisovin.shopkeepers.ShopkeepersPlugin;
import com.nisovin.shopkeepers.events.ShopkeeperDeletedEvent;
import com.nisovin.shopkeepers.events.ShopkeeperEditedEvent;
import com.nisovin.shopkeepers.shoptypes.PlayerShopkeeper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

class ShopListener
implements Listener {
    ShopkeepersPlugin plugin;
    Map<String, Long> lastPurchase;

    public ShopListener(ShopkeepersPlugin plugin) {
        this.plugin = plugin;
        this.lastPurchase = new HashMap<String, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onBlockPlace(BlockPlaceEvent event) {
        if (event.getBlock().getType() == Material.CHEST) {
            Block b = event.getBlock();
            List<String> list = this.plugin.recentlyPlacedChests.get(event.getPlayer().getName());
            if (list == null) {
                list = new LinkedList<String>();
                this.plugin.recentlyPlacedChests.put(event.getPlayer().getName(), list);
            }
            list.add(String.valueOf(b.getWorld().getName()) + "," + b.getX() + "," + b.getY() + "," + b.getZ());
            if (list.size() > 5) {
                list.remove(0);
            }
        }
    }

    @EventHandler
    void onInventoryClose(InventoryCloseEvent event) {
        String name = event.getPlayer().getName();
        if (this.plugin.editing.containsKey(name)) {
            ShopkeepersPlugin.debug("Player " + name + " closed editor window");
            String id = this.plugin.editing.remove(name);
            Shopkeeper shopkeeper = this.plugin.activeShopkeepers.get(id);
            if (shopkeeper != null && this.plugin.isShopkeeperEditorWindow(event.getInventory())) {
                shopkeeper.onEditorClose(event);
                this.plugin.closeTradingForShopkeeper(id);
                this.plugin.save();
            }
        } else if (this.plugin.purchasing.containsKey(name)) {
            ShopkeepersPlugin.debug("Player " + name + " closed trade window");
            this.plugin.purchasing.remove(name);
        }
    }

    @EventHandler
    void onInventoryClick(InventoryClickEvent event) {
        Shopkeeper shopkeeper;
        String id;
        String playerName;
        if (this.plugin.isShopkeeperEditorWindow(event.getInventory())) {
            playerName = event.getWhoClicked().getName();
            if (this.plugin.editing.containsKey(playerName)) {
                id = this.plugin.editing.get(playerName);
                shopkeeper = this.plugin.activeShopkeepers.get(id);
                if (shopkeeper != null) {
                    EditorClickResult result = shopkeeper.onEditorClick(event);
                    if (result == EditorClickResult.DELETE_SHOPKEEPER) {
                        this.plugin.closeTradingForShopkeeper(id);
                        if (Settings.deletingPlayerShopReturnsEgg && shopkeeper instanceof PlayerShopkeeper) {
                            HashMap remaining;
                            ItemStack creationItem = new ItemStack(Settings.shopCreationItem, 1, (short)Settings.shopCreationItemData);
                            if (Settings.shopCreationItemName != null && !Settings.shopCreationItemName.isEmpty()) {
                                ItemMeta meta = creationItem.getItemMeta();
                                meta.setDisplayName(Settings.shopCreationItemName);
                                creationItem.setItemMeta(meta);
                            }
                            if (!(remaining = event.getWhoClicked().getInventory().addItem(new ItemStack[]{creationItem})).isEmpty()) {
                                event.getWhoClicked().getWorld().dropItem(shopkeeper.getActualLocation(), creationItem);
                            }
                        }
                        this.plugin.activeShopkeepers.remove(id);
                        this.plugin.allShopkeepersByChunk.get(shopkeeper.getChunk()).remove(shopkeeper);
                        Bukkit.getPluginManager().callEvent((Event)new ShopkeeperDeletedEvent((Player)event.getWhoClicked(), shopkeeper));
                        this.plugin.save();
                    } else if (result == EditorClickResult.DONE_EDITING) {
                        this.plugin.closeTradingForShopkeeper(id);
                        Bukkit.getPluginManager().callEvent((Event)new ShopkeeperEditedEvent((Player)event.getWhoClicked(), shopkeeper));
                        this.plugin.save();
                    } else if (result == EditorClickResult.SAVE_AND_CONTINUE) {
                        Bukkit.getPluginManager().callEvent((Event)new ShopkeeperEditedEvent((Player)event.getWhoClicked(), shopkeeper));
                        this.plugin.save();
                    } else if (result == EditorClickResult.SET_NAME) {
                        this.plugin.closeInventory((HumanEntity)((Player)event.getWhoClicked()));
                        this.plugin.editing.remove(event.getWhoClicked().getName());
                        this.plugin.naming.put(event.getWhoClicked().getName(), id);
                        this.plugin.sendMessage((Player)event.getWhoClicked(), Settings.msgTypeNewName);
                        Bukkit.getPluginManager().callEvent((Event)new ShopkeeperEditedEvent((Player)event.getWhoClicked(), shopkeeper));
                        this.plugin.save();
                    }
                } else {
                    event.setCancelled(true);
                    this.plugin.closeInventory(event.getWhoClicked());
                }
            } else {
                event.setCancelled(true);
                this.plugin.closeInventory(event.getWhoClicked());
            }
        }
        if (event.getInventory().getName().equals("mob.villager") && event.getRawSlot() == 2 && this.plugin.purchasing.containsKey(event.getWhoClicked().getName())) {
            playerName = event.getWhoClicked().getName();
            if (event.isRightClick()) {
                event.setCancelled(true);
                return;
            }
            id = this.plugin.purchasing.get(event.getWhoClicked().getName());
            shopkeeper = this.plugin.activeShopkeepers.get(id);
            ItemStack item = event.getCurrentItem();
            if (shopkeeper != null && item != null) {
                Long last = this.lastPurchase.remove(playerName);
                long curr = System.currentTimeMillis();
                if (last != null && last > curr - 500L) {
                    event.setCancelled(true);
                    return;
                }
                this.lastPurchase.put(playerName, curr);
                ItemStack item1 = event.getInventory().getItem(0);
                ItemStack item2 = event.getInventory().getItem(1);
                boolean ok = false;
                List<ItemStack[]> recipes = shopkeeper.getRecipes();
                for (ItemStack[] recipe : recipes) {
                    if (!this.itemEquals(item1, recipe[0]) || !this.itemEquals(item2, recipe[1]) || !this.itemEquals(item, recipe[2])) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    ShopkeepersPlugin.debug("Invalid trade by " + event.getWhoClicked().getName() + " with shopkeeper at " + shopkeeper.getPositionString() + ":");
                    ShopkeepersPlugin.debug("  " + this.itemStackToString(item1) + " and " + this.itemStackToString(item2) + " for " + this.itemStackToString(item));
                    event.setCancelled(true);
                    return;
                }
                shopkeeper.onPurchaseClick(event);
                if (Settings.enablePurchaseLogging && !event.isCancelled()) {
                    try {
                        String owner = shopkeeper instanceof PlayerShopkeeper ? ((PlayerShopkeeper)shopkeeper).getOwner() : "[Admin]";
                        File file = new File(this.plugin.getDataFolder(), "purchases-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".csv");
                        boolean isNew = !file.exists();
                        BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
                        if (isNew) {
                            writer.append("TIME,PLAYER,SHOP TYPE,SHOP POS,OWNER,ITEM TYPE,DATA,QUANTITY,CURRENCY 1,CURRENCY 2\n");
                        }
                        writer.append("\"" + new SimpleDateFormat("HH:mm:ss").format(new Date()) + "\",\"" + playerName + "\",\"" + shopkeeper.getType().name() + "\",\"" + shopkeeper.getPositionString() + "\",\"" + owner + "\",\"" + item.getType().name() + "\",\"" + item.getDurability() + "\",\"" + item.getAmount() + "\",\"" + (item1 != null ? String.valueOf(item1.getType().name()) + ":" + item1.getDurability() : "") + "\",\"" + (item2 != null ? String.valueOf(item2.getType().name()) + ":" + item2.getDurability() : "") + "\"\n");
                        writer.close();
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().severe("IO exception while trying to log purchase");
                    }
                }
            }
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        final Player player = event.getPlayer();
        final String name = player.getName();
        if (this.plugin.naming.containsKey(name)) {
            event.setCancelled(true);
            final String message = event.getMessage();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    String id = ShopListener.this.plugin.naming.remove(name);
                    Shopkeeper shopkeeper = ShopListener.this.plugin.activeShopkeepers.get(id);
                    if (message.equals("-")) {
                        shopkeeper.setName("");
                    } else if (message.length() > 32) {
                        shopkeeper.setName(message.substring(0, 32));
                    } else {
                        shopkeeper.setName(message);
                    }
                    ShopListener.this.plugin.sendMessage(player, Settings.msgNameSet);
                    ShopListener.this.plugin.closeTradingForShopkeeper(id);
                    Bukkit.getPluginManager().callEvent((Event)new ShopkeeperEditedEvent(player, shopkeeper));
                    ShopListener.this.plugin.save();
                }
            });
        }
    }

    @EventHandler
    void onEntityDamage(EntityDamageEvent event) {
        if (this.plugin.activeShopkeepers.containsKey("entity" + event.getEntity().getEntityId())) {
            EntityDamageByEntityEvent evt;
            event.setCancelled(true);
            if (event instanceof EntityDamageByEntityEvent && (evt = (EntityDamageByEntityEvent)event).getDamager() instanceof Monster) {
                evt.getDamager().remove();
            }
        }
    }

    private boolean itemEquals(ItemStack item1, ItemStack item2) {
        if (!(item1 != null && item1.getTypeId() != 0 || item2 != null && item2.getTypeId() != 0)) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        return item1.isSimilar(item2);
    }

    private static String getNameOfItem(ItemStack item) {
        ItemMeta meta;
        if (item != null && item.getTypeId() > 0 && item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName()) {
            return meta.getDisplayName();
        }
        return "";
    }

    private String itemStackToString(ItemStack item) {
        if (item == null || item.getTypeId() == 0) {
            return "(nothing)";
        }
        String name = ShopListener.getNameOfItem(item);
        return String.valueOf(item.getTypeId()) + ":" + item.getDurability() + (!name.isEmpty() ? ":" + name : "");
    }

    @EventHandler(priority=EventPriority.LOW)
    void onPlayerInteract1(PlayerInteractEvent event) {
        if (event.hasBlock() && event.getClickedBlock().getType() == Material.CHEST) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            if (!event.getPlayer().hasPermission("shopkeeper.bypass")) {
                if (this.plugin.isChestProtected(player, block)) {
                    event.setCancelled(true);
                    return;
                }
                BlockFace[] blockFaceArray = this.plugin.chestProtectFaces;
                int n = this.plugin.chestProtectFaces.length;
                int n2 = 0;
                while (n2 < n) {
                    BlockFace face = blockFaceArray[n2];
                    if (block.getRelative(face).getType() == Material.CHEST && this.plugin.isChestProtected(player, block.getRelative(face))) {
                        event.setCancelled(true);
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    @EventHandler
    void onChunkLoad(ChunkLoadEvent event) {
        final Chunk chunk = event.getChunk();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (chunk.isLoaded()) {
                    ShopListener.this.plugin.loadShopkeepersInChunk(chunk);
                }
            }
        }, 2L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    void onChunkUnload(ChunkUnloadEvent event) {
        List<Shopkeeper> shopkeepers = this.plugin.allShopkeepersByChunk.get(String.valueOf(event.getWorld().getName()) + "," + event.getChunk().getX() + "," + event.getChunk().getZ());
        if (shopkeepers != null) {
            ShopkeepersPlugin.debug("Unloading " + shopkeepers.size() + " shopkeepers in chunk " + event.getChunk().getX() + "," + event.getChunk().getZ());
            for (Shopkeeper shopkeeper : shopkeepers) {
                this.plugin.activeShopkeepers.remove(shopkeeper.getId());
                shopkeeper.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onWorldLoad(WorldLoadEvent event) {
        Chunk[] chunkArray = event.getWorld().getLoadedChunks();
        int n = chunkArray.length;
        int n2 = 0;
        while (n2 < n) {
            Chunk chunk = chunkArray[n2];
            this.plugin.loadShopkeepersInChunk(chunk);
            ++n2;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onWorldUnload(WorldUnloadEvent event) {
        String worldName = event.getWorld().getName();
        Iterator<Shopkeeper> iter = this.plugin.activeShopkeepers.values().iterator();
        int count = 0;
        while (iter.hasNext()) {
            Shopkeeper shopkeeper = iter.next();
            if (!shopkeeper.getWorldName().equals(worldName)) continue;
            shopkeeper.remove();
            iter.remove();
            ++count;
        }
        ShopkeepersPlugin.debug("Unloaded " + count + " shopkeepers in unloaded world " + worldName);
    }

    @EventHandler
    void onPlayerQuit(PlayerQuitEvent event) {
        String name = event.getPlayer().getName();
        this.plugin.editing.remove(name);
        this.plugin.purchasing.remove(name);
        this.plugin.selectedShopType.remove(name);
        this.plugin.selectedChest.remove(name);
        this.plugin.recentlyPlacedChests.remove(name);
    }
}

