/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers;

import com.nisovin.shopkeepers.shopobjects.BlockShop;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import com.nisovin.shopkeepers.shopobjects.VillagerShop;
import com.nisovin.shopkeepers.shopobjects.WitchShop;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public enum ShopObjectType {
    NONE(0, ""),
    VILLAGER(1, "villager"),
    SIGN(2, "sign"),
    WITCH(3, "witch");

    private static final int MAX_ID = 3;
    private final int id;
    private final String permission;
    private static final Map<Integer, ShopObjectType> typeMap;

    static {
        typeMap = new HashMap<Integer, ShopObjectType>();
        ShopObjectType[] shopObjectTypeArray = ShopObjectType.values();
        int n = shopObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShopObjectType type = shopObjectTypeArray[n2];
            typeMap.put(type.id, type);
            ++n2;
        }
    }

    private ShopObjectType(int id, String permission) {
        this.id = id;
        this.permission = permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getId() {
        return this.id;
    }

    public boolean hasPermission(Player player) {
        return player.hasPermission("shopkeeper." + this.permission);
    }

    public ShopObject createObject() {
        if (this.id == 1) {
            return new VillagerShop();
        }
        if (this.id == 2) {
            return new BlockShop();
        }
        if (this.id == 3) {
            return new WitchShop();
        }
        return null;
    }

    public static ShopObjectType next(Player player, ShopObjectType current) {
        ShopObjectType next = null;
        next = current == null ? NONE : current;
        int i = 0;
        while (i < 3) {
            int nextId = next.id + 1;
            if (nextId > 3) {
                nextId = 1;
            }
            next = typeMap.get(nextId);
            if (player.hasPermission("shopkeeper." + next.permission)) {
                return next;
            }
            ++i;
        }
        return current;
    }
}

