/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public enum ShopkeeperType {
    ADMIN(0, "admin"),
    PLAYER_NORMAL(1, "player.normal"),
    PLAYER_BOOK(2, "player.book"),
    PLAYER_BUY(3, "player.buy"),
    PLAYER_TRADE(4, "player.trade");

    private static final int MAX_ID = 4;
    private final int id;
    private final String permission;
    private static final Map<Integer, ShopkeeperType> typeMap;

    static {
        typeMap = new HashMap<Integer, ShopkeeperType>();
        ShopkeeperType[] shopkeeperTypeArray = ShopkeeperType.values();
        int n = shopkeeperTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShopkeeperType type = shopkeeperTypeArray[n2];
            typeMap.put(type.id, type);
            ++n2;
        }
    }

    private ShopkeeperType(int id, String permission) {
        this.id = id;
        this.permission = permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getId() {
        return this.id;
    }

    public boolean hasPermission(Player player) {
        return player.hasPermission("shopkeeper." + this.permission);
    }

    public static ShopkeeperType next(Player player, ShopkeeperType current) {
        if (current == ADMIN) {
            return ADMIN;
        }
        ShopkeeperType next = null;
        next = current == null ? ADMIN : current;
        int i = 0;
        while (i < 4) {
            int nextId = next.id + 1;
            if (nextId > 4) {
                nextId = 1;
            }
            next = typeMap.get(nextId);
            if (player.hasPermission("shopkeeper." + next.permission)) {
                return next;
            }
            ++i;
        }
        return current;
    }
}

