/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers;

import com.nisovin.shopkeepers.BlockListener;
import com.nisovin.shopkeepers.BlockSpawnListener;
import com.nisovin.shopkeepers.ChestBreakListener;
import com.nisovin.shopkeepers.ChestProtectListener;
import com.nisovin.shopkeepers.CreateListener;
import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.ShopListener;
import com.nisovin.shopkeepers.ShopObjectType;
import com.nisovin.shopkeepers.Shopkeeper;
import com.nisovin.shopkeepers.ShopkeeperType;
import com.nisovin.shopkeepers.VillagerListener;
import com.nisovin.shopkeepers.WitchListener;
import com.nisovin.shopkeepers.events.CreatePlayerShopkeeperEvent;
import com.nisovin.shopkeepers.events.OpenTradeEvent;
import com.nisovin.shopkeepers.events.ShopkeeperCreatedEvent;
import com.nisovin.shopkeepers.pluginhandlers.TownyHandler;
import com.nisovin.shopkeepers.pluginhandlers.WorldGuardHandler;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import com.nisovin.shopkeepers.shopobjects.VillagerShop;
import com.nisovin.shopkeepers.shoptypes.AdminShopkeeper;
import com.nisovin.shopkeepers.shoptypes.BuyingPlayerShopkeeper;
import com.nisovin.shopkeepers.shoptypes.NormalPlayerShopkeeper;
import com.nisovin.shopkeepers.shoptypes.PlayerShopkeeper;
import com.nisovin.shopkeepers.shoptypes.TradingPlayerShopkeeper;
import com.nisovin.shopkeepers.shoptypes.WrittenBookPlayerShopkeeper;
import com.nisovin.shopkeepers.volatilecode.VolatileCodeHandle;
import com.nisovin.shopkeepers.volatilecode.VolatileCode_1_5_R2;
import com.nisovin.shopkeepers.volatilecode.VolatileCode_1_5_R3;
import com.nisovin.shopkeepers.volatilecode.VolatileCode_1_5_Z;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopkeepersPlugin
extends JavaPlugin {
    static ShopkeepersPlugin plugin;
    static VolatileCodeHandle volatileCodeHandle;
    private boolean debug = false;
    Map<String, List<Shopkeeper>> allShopkeepersByChunk = new HashMap<String, List<Shopkeeper>>();
    Map<String, Shopkeeper> activeShopkeepers = new HashMap<String, Shopkeeper>();
    Map<String, String> editing = new HashMap<String, String>();
    Map<String, String> naming = Collections.synchronizedMap(new HashMap());
    Map<String, String> purchasing = new HashMap<String, String>();
    Map<String, List<String>> recentlyPlacedChests = new HashMap<String, List<String>>();
    Map<String, ShopkeeperType> selectedShopType = new HashMap<String, ShopkeeperType>();
    Map<String, ShopObjectType> selectedShopObjectType = new HashMap<String, ShopObjectType>();
    Map<String, Block> selectedChest = new HashMap<String, Block>();
    private boolean dirty = false;
    private int chunkLoadSaveTask = -1;
    BlockFace[] chestProtectFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    BlockFace[] hopperProtectFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    static {
        volatileCodeHandle = null;
    }

    public void onEnable() {
        plugin = this;
        try {
            Class.forName("net.minecraft.server.v1_5_R3.MinecraftServer");
            volatileCodeHandle = new VolatileCode_1_5_R3();
        }
        catch (ClassNotFoundException e_1_5_r3) {
            try {
                Class.forName("net.minecraft.server.v1_5_R2.MinecraftServer");
                volatileCodeHandle = new VolatileCode_1_5_R2();
            }
            catch (ClassNotFoundException e_1_5_r2) {
                try {
                    Class.forName("net.minecraft.server.MinecraftServer");
                    if (this.getServer().getVersion().contains("1.5")) {
                        volatileCodeHandle = new VolatileCode_1_5_Z();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (volatileCodeHandle == null) {
            this.getLogger().severe("Incompatible server version: Shopkeepers plugin cannot be enabled.");
            this.setEnabled(false);
            return;
        }
        File file = new File(this.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.saveDefaultConfig();
        }
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        Settings.loadConfiguration((Configuration)config);
        this.debug = config.getBoolean("debug", this.debug);
        String lang = config.getString("language", "en");
        File langFile = new File(this.getDataFolder(), "language-" + lang + ".yml");
        if (!langFile.exists() && this.getResource("language-" + lang + ".yml") != null) {
            this.saveResource("language-" + lang + ".yml", false);
        }
        if (langFile.exists()) {
            try {
                YamlConfiguration langConfig = new YamlConfiguration();
                langConfig.load(langFile);
                Settings.loadLanguageConfiguration((Configuration)langConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.load();
        for (World world : Bukkit.getWorlds()) {
            Chunk[] chunkArray = world.getLoadedChunks();
            int n = chunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk chunk = chunkArray[n2];
                this.loadShopkeepersInChunk(chunk);
                ++n2;
            }
        }
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new ShopListener(this), (Plugin)this);
        pm.registerEvents((Listener)new CreateListener(this), (Plugin)this);
        if (Settings.enableVillagerShops) {
            pm.registerEvents((Listener)new VillagerListener(this), (Plugin)this);
        }
        if (Settings.enableSignShops) {
            pm.registerEvents((Listener)new BlockListener(this), (Plugin)this);
        }
        if (Settings.enableWitchShops) {
            pm.registerEvents((Listener)new WitchListener(this), (Plugin)this);
        }
        if (Settings.blockVillagerSpawns) {
            pm.registerEvents((Listener)new BlockSpawnListener(), (Plugin)this);
        }
        if (Settings.protectChests) {
            pm.registerEvents((Listener)new ChestProtectListener(this), (Plugin)this);
        } else if (Settings.deleteShopkeeperOnBreakChest) {
            pm.registerEvents((Listener)new ChestBreakListener(this), (Plugin)this);
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                ArrayList<Shopkeeper> readd = new ArrayList<Shopkeeper>();
                Iterator<Map.Entry<String, Shopkeeper>> iter = ShopkeepersPlugin.this.activeShopkeepers.entrySet().iterator();
                while (iter.hasNext()) {
                    Shopkeeper shopkeeper = iter.next().getValue();
                    boolean update = shopkeeper.teleport();
                    if (!update) continue;
                    readd.add(shopkeeper);
                    iter.remove();
                }
                for (Shopkeeper shopkeeper : readd) {
                    if (!shopkeeper.isActive()) continue;
                    ShopkeepersPlugin.this.activeShopkeepers.put(shopkeeper.getId(), shopkeeper);
                }
            }
        }, 200L, 200L);
        if (Settings.enableSpawnVerifier) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    int count = 0;
                    for (String chunkStr : ShopkeepersPlugin.this.allShopkeepersByChunk.keySet()) {
                        if (!ShopkeepersPlugin.this.isChunkLoaded(chunkStr)) continue;
                        List<Shopkeeper> shopkeepers = ShopkeepersPlugin.this.allShopkeepersByChunk.get(chunkStr);
                        for (Shopkeeper shopkeeper : shopkeepers) {
                            if (shopkeeper.isActive()) continue;
                            boolean spawned = shopkeeper.spawn();
                            if (spawned) {
                                ShopkeepersPlugin.this.activeShopkeepers.put(shopkeeper.getId(), shopkeeper);
                                ++count;
                                continue;
                            }
                            ShopkeepersPlugin.debug("Failed to spawn shopkeeper at " + shopkeeper.getPositionString());
                        }
                    }
                    if (count > 0) {
                        ShopkeepersPlugin.debug("Spawn verifier: " + count + " shopkeepers respawned");
                    }
                }
            }, 600L, 1200L);
        }
        if (!Settings.saveInstantly) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    if (ShopkeepersPlugin.this.dirty) {
                        ShopkeepersPlugin.this.saveReal();
                        ShopkeepersPlugin.this.dirty = false;
                    }
                }
            }, 6000L, 6000L);
        }
    }

    public void onDisable() {
        Player player;
        if (this.dirty) {
            this.saveReal();
            this.dirty = false;
        }
        for (String playerName : this.editing.keySet()) {
            player = Bukkit.getPlayerExact((String)playerName);
            if (player == null) continue;
            player.closeInventory();
        }
        this.editing.clear();
        for (String playerName : this.purchasing.keySet()) {
            player = Bukkit.getPlayerExact((String)playerName);
            if (player == null) continue;
            player.closeInventory();
        }
        this.purchasing.clear();
        for (Shopkeeper shopkeeper : this.activeShopkeepers.values()) {
            shopkeeper.remove();
        }
        this.activeShopkeepers.clear();
        this.allShopkeepersByChunk.clear();
        this.selectedShopType.clear();
        this.selectedShopObjectType.clear();
        this.selectedChest.clear();
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        plugin = null;
    }

    public void reload() {
        this.onDisable();
        this.onEnable();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload") && sender.hasPermission("shopkeeper.reload")) {
            this.reload();
            sender.sendMessage(ChatColor.GREEN + "Shopkeepers plugin reloaded!");
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("debug") && sender.isOp()) {
            this.debug = !this.debug;
            sender.sendMessage(ChatColor.GREEN + "Debug mode " + (this.debug ? "enabled" : "disabled"));
            return true;
        }
        if (args.length == 1 && args[0].equals("check") && sender.isOp()) {
            for (Shopkeeper shopkeeper : this.activeShopkeepers.values()) {
                if (shopkeeper.isActive()) {
                    Location loc = shopkeeper.getActualLocation();
                    sender.sendMessage("Shopkeeper at " + shopkeeper.getPositionString() + ": active (" + (loc != null ? loc.toString() : "maybe not?!?") + ")");
                    continue;
                }
                sender.sendMessage("Shopkeeper at " + shopkeeper.getPositionString() + ": INACTIVE!");
            }
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Block block = player.getTargetBlock(null, 10);
            if (block != null && block.getType() != Material.AIR) {
                if (Settings.createPlayerShopWithCommand && block.getType() == Material.CHEST) {
                    Shopkeeper shopkeeper;
                    List<String> list;
                    if (this.isChestProtected(null, block)) {
                        return true;
                    }
                    if (Settings.requireChestRecentlyPlaced && ((list = ShopkeepersPlugin.plugin.recentlyPlacedChests.get(player.getName())) == null || !list.contains(String.valueOf(block.getWorld().getName()) + "," + block.getX() + "," + block.getY() + "," + block.getZ()))) {
                        this.sendMessage(player, Settings.msgChestNotPlaced);
                        return true;
                    }
                    if (Settings.simulateRightClickOnCommand) {
                        PlayerInteractEvent event = new PlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, new ItemStack(Material.AIR), block, BlockFace.UP);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return true;
                        }
                    }
                    ShopkeeperType shopType = ShopkeeperType.next(player, null);
                    ShopObjectType shopObjType = ShopObjectType.next(player, null);
                    if (args != null && args.length > 0) {
                        if (args.length >= 1) {
                            if (args[0].toLowerCase().startsWith("norm") || args[0].toLowerCase().startsWith("sell")) {
                                shopType = ShopkeeperType.PLAYER_NORMAL;
                            } else if (args[0].toLowerCase().startsWith("book")) {
                                shopType = ShopkeeperType.PLAYER_BOOK;
                            } else if (args[0].toLowerCase().startsWith("buy")) {
                                shopType = ShopkeeperType.PLAYER_BUY;
                            } else if (args[0].toLowerCase().startsWith("trad")) {
                                shopType = ShopkeeperType.PLAYER_TRADE;
                            } else if (args[0].toLowerCase().equals("villager")) {
                                shopObjType = ShopObjectType.VILLAGER;
                            } else if (args[0].toLowerCase().equals("sign")) {
                                shopObjType = ShopObjectType.SIGN;
                            }
                        }
                        if (args.length >= 2) {
                            if (args[1].equalsIgnoreCase("villager")) {
                                shopObjType = ShopObjectType.VILLAGER;
                            } else if (args[1].equalsIgnoreCase("sign")) {
                                shopObjType = ShopObjectType.SIGN;
                            }
                        }
                        if (shopType != null && !shopType.hasPermission(player)) {
                            shopType = null;
                        }
                        if (shopObjType != null && !shopObjType.hasPermission(player)) {
                            shopObjType = null;
                        }
                    }
                    if (shopType != null && (shopkeeper = this.createNewPlayerShopkeeper(player, block, block.getLocation().add(0.0, 1.5, 0.0), shopType, shopObjType.createObject())) != null) {
                        this.sendCreatedMessage(player, shopType);
                    }
                } else if (player.hasPermission("shopkeeper.admin")) {
                    Shopkeeper shopkeeper;
                    ShopObjectType shopObjType = ShopObjectType.VILLAGER;
                    Location loc = block.getLocation().add(0.0, 1.5, 0.0);
                    if (args.length > 0) {
                        if (args[0].equals("sign")) {
                            shopObjType = ShopObjectType.SIGN;
                            loc = block.getLocation();
                        } else if (args[0].equals("witch")) {
                            shopObjType = ShopObjectType.WITCH;
                        }
                    }
                    if ((shopkeeper = this.createNewAdminShopkeeper(loc, shopObjType.createObject())) != null) {
                        this.sendMessage(player, Settings.msgAdminShopCreated);
                        Bukkit.getPluginManager().callEvent((Event)new ShopkeeperCreatedEvent(player, shopkeeper));
                    }
                }
            } else {
                this.sendMessage(player, Settings.msgShopCreateFail);
            }
            return true;
        }
        sender.sendMessage("You must be a player to create a shopkeeper.");
        sender.sendMessage("Use 'shopkeeper reload' to reload the plugin.");
        return true;
    }

    public Shopkeeper createNewAdminShopkeeper(Location location, ShopObject shopObject) {
        AdminShopkeeper shopkeeper = new AdminShopkeeper(location, new VillagerShop());
        shopkeeper.spawn();
        this.activeShopkeepers.put(shopkeeper.getId(), shopkeeper);
        this.addShopkeeper(shopkeeper);
        return shopkeeper;
    }

    public Shopkeeper createNewPlayerShopkeeper(Player player, Block chest, Location location, ShopkeeperType shopType, ShopObject shopObject) {
        if (shopType == null || shopObject == null) {
            return null;
        }
        if (Settings.enableWorldGuardRestrictions && !WorldGuardHandler.canBuild(player, location)) {
            plugin.sendMessage(player, Settings.msgShopCreateFail);
            return null;
        }
        if (Settings.enableTownyRestrictions && !TownyHandler.isCommercialArea(location)) {
            plugin.sendMessage(player, Settings.msgShopCreateFail);
            return null;
        }
        int maxShops = Settings.maxShopsPerPlayer;
        CreatePlayerShopkeeperEvent event = new CreatePlayerShopkeeperEvent(player, chest, location, shopType, maxShops);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        location = event.getSpawnLocation();
        shopType = event.getType();
        maxShops = event.getMaxShopsForPlayer();
        if (maxShops > 0) {
            int count = 0;
            for (List<Shopkeeper> list : this.allShopkeepersByChunk.values()) {
                for (Shopkeeper shopkeeper : list) {
                    if (!(shopkeeper instanceof PlayerShopkeeper) || !((PlayerShopkeeper)shopkeeper).getOwner().equalsIgnoreCase(player.getName())) continue;
                    ++count;
                }
            }
            if (count >= maxShops) {
                this.sendMessage(player, Settings.msgTooManyShops);
                return null;
            }
        }
        PlayerShopkeeper shopkeeper = null;
        if (shopType == ShopkeeperType.PLAYER_NORMAL) {
            shopkeeper = new NormalPlayerShopkeeper(player, chest, location, shopObject);
        } else if (shopType == ShopkeeperType.PLAYER_BOOK) {
            shopkeeper = new WrittenBookPlayerShopkeeper(player, chest, location, shopObject);
        } else if (shopType == ShopkeeperType.PLAYER_BUY) {
            shopkeeper = new BuyingPlayerShopkeeper(player, chest, location, shopObject);
        } else if (shopType == ShopkeeperType.PLAYER_TRADE) {
            shopkeeper = new TradingPlayerShopkeeper(player, chest, location, shopObject);
        }
        if (shopkeeper != null) {
            shopkeeper.spawn();
            this.activeShopkeepers.put(shopkeeper.getId(), shopkeeper);
            this.addShopkeeper(shopkeeper);
        }
        Bukkit.getPluginManager().callEvent((Event)new ShopkeeperCreatedEvent(player, shopkeeper));
        return shopkeeper;
    }

    public Shopkeeper getShopkeeperByEntityId(int entityId) {
        return this.activeShopkeepers.get(entityId);
    }

    public List<Shopkeeper> getShopkeepersInChunk(String world, int x, int z) {
        return this.allShopkeepersByChunk.get(String.valueOf(world) + "," + x + "," + z);
    }

    public boolean isShopkeeper(Entity entity) {
        return this.activeShopkeepers.containsKey("entity" + entity.getEntityId());
    }

    public boolean isShopkeeperEditorWindow(Inventory inventory) {
        return inventory.getTitle().equals(Settings.editorTitle);
    }

    void addShopkeeper(Shopkeeper shopkeeper) {
        List<Shopkeeper> list = this.allShopkeepersByChunk.get(shopkeeper.getChunk());
        if (list == null) {
            list = new ArrayList<Shopkeeper>();
            this.allShopkeepersByChunk.put(shopkeeper.getChunk(), list);
        }
        list.add(shopkeeper);
        this.save();
    }

    boolean sendCreatedMessage(Player player, ShopkeeperType shopType) {
        if (shopType == ShopkeeperType.PLAYER_NORMAL) {
            plugin.sendMessage(player, Settings.msgPlayerShopCreated);
            return true;
        }
        if (shopType == ShopkeeperType.PLAYER_BOOK) {
            plugin.sendMessage(player, Settings.msgBookShopCreated);
            return true;
        }
        if (shopType == ShopkeeperType.PLAYER_BUY) {
            plugin.sendMessage(player, Settings.msgBuyShopCreated);
            return true;
        }
        if (shopType == ShopkeeperType.PLAYER_TRADE) {
            plugin.sendMessage(player, Settings.msgTradeShopCreated);
            return true;
        }
        return false;
    }

    void handleShopkeeperInteraction(Player player, Shopkeeper shopkeeper) {
        if (shopkeeper != null && player.isSneaking()) {
            ShopkeepersPlugin.debug("  Opening editor window...");
            boolean isEditing = shopkeeper.onEdit(player);
            if (isEditing) {
                ShopkeepersPlugin.debug("  Editor window opened");
                ShopkeepersPlugin.plugin.editing.put(player.getName(), shopkeeper.getId());
            } else {
                ShopkeepersPlugin.debug("  Editor window NOT opened");
            }
        } else if (shopkeeper != null) {
            ShopkeepersPlugin.debug("  Opening trade window...");
            OpenTradeEvent evt = new OpenTradeEvent(player, shopkeeper);
            Bukkit.getPluginManager().callEvent((Event)evt);
            if (evt.isCancelled()) {
                ShopkeepersPlugin.debug("  Trade cancelled by another plugin");
                return;
            }
            plugin.openTradeWindow(shopkeeper, player);
            ShopkeepersPlugin.plugin.purchasing.put(player.getName(), shopkeeper.getId());
            ShopkeepersPlugin.debug("  Trade window opened");
        }
    }

    void closeTradingForShopkeeper(final String id) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Iterator<String> editors = ShopkeepersPlugin.this.editing.keySet().iterator();
                while (editors.hasNext()) {
                    String name = editors.next();
                    if (!ShopkeepersPlugin.this.editing.get(name).equals(id)) continue;
                    editors.remove();
                    Player player = Bukkit.getPlayerExact((String)name);
                    if (player == null) continue;
                    player.closeInventory();
                }
                Iterator<String> purchasers = ShopkeepersPlugin.this.purchasing.keySet().iterator();
                while (purchasers.hasNext()) {
                    String name = purchasers.next();
                    if (!ShopkeepersPlugin.this.purchasing.get(name).equals(id)) continue;
                    purchasers.remove();
                    Player player = Bukkit.getPlayerExact((String)name);
                    if (player == null) continue;
                    player.closeInventory();
                }
            }
        }, 1L);
    }

    void closeInventory(final HumanEntity player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                player.closeInventory();
            }
        }, 1L);
    }

    boolean openTradeWindow(Shopkeeper shopkeeper, Player player) {
        return volatileCodeHandle.openTradeWindow(shopkeeper, player);
    }

    boolean isChestProtected(Player player, Block block) {
        for (Shopkeeper shopkeeper : this.activeShopkeepers.values()) {
            if (!(shopkeeper instanceof PlayerShopkeeper)) continue;
            PlayerShopkeeper pshop = (PlayerShopkeeper)shopkeeper;
            if (player != null && pshop.getOwner().equalsIgnoreCase(player.getName()) || !pshop.usesChest(block)) continue;
            return true;
        }
        return false;
    }

    Shopkeeper getShopkeeperOwnerOfChest(Block block) {
        for (Shopkeeper shopkeeper : this.activeShopkeepers.values()) {
            PlayerShopkeeper pshop;
            if (!(shopkeeper instanceof PlayerShopkeeper) || !(pshop = (PlayerShopkeeper)shopkeeper).usesChest(block)) continue;
            return pshop;
        }
        return null;
    }

    void sendMessage(Player player, String message) {
        String[] msgs;
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        String[] stringArray = msgs = message.split("\n");
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            player.sendMessage(msg);
            ++n2;
        }
    }

    void loadShopkeepersInChunk(Chunk chunk) {
        List<Shopkeeper> shopkeepers = this.allShopkeepersByChunk.get(String.valueOf(chunk.getWorld().getName()) + "," + chunk.getX() + "," + chunk.getZ());
        if (shopkeepers != null) {
            ShopkeepersPlugin.debug("Loading " + shopkeepers.size() + " shopkeepers in chunk " + chunk.getX() + "," + chunk.getZ());
            for (Shopkeeper shopkeeper : shopkeepers) {
                if (shopkeeper.isActive() || !shopkeeper.needsSpawned()) continue;
                boolean spawned = shopkeeper.spawn();
                if (spawned) {
                    this.activeShopkeepers.put(shopkeeper.getId(), shopkeeper);
                    continue;
                }
                this.getLogger().warning("Failed to spawn shopkeeper at " + shopkeeper.getPositionString());
            }
            this.dirty = true;
            if (Settings.saveInstantly && this.chunkLoadSaveTask < 0) {
                this.chunkLoadSaveTask = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        if (ShopkeepersPlugin.this.dirty) {
                            ShopkeepersPlugin.this.saveReal();
                            ShopkeepersPlugin.this.dirty = false;
                        }
                        ShopkeepersPlugin.this.chunkLoadSaveTask = -1;
                    }
                }, 600L);
            }
        }
    }

    private boolean isChunkLoaded(String chunkStr) {
        String[] chunkData = chunkStr.split(",");
        World w = this.getServer().getWorld(chunkData[0]);
        if (w != null) {
            int x = Integer.parseInt(chunkData[1]);
            int z = Integer.parseInt(chunkData[2]);
            return w.isChunkLoaded(x, z);
        }
        return false;
    }

    private void load() {
        File file = new File(this.getDataFolder(), "save.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            if (Settings.fileEncoding != null && !Settings.fileEncoding.isEmpty()) {
                FileInputStream stream = new FileInputStream(file);
                String data = new Scanner((InputStream)stream, Settings.fileEncoding).useDelimiter("\\A").next();
                config.loadFromString(data);
                stream.close();
            } else {
                config.load(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Set keys = config.getKeys(false);
        for (String key : keys) {
            String owner;
            OfflinePlayer offlinePlayer;
            long lastPlayed;
            ConfigurationSection section = config.getConfigurationSection(key);
            Shopkeeper shopkeeper = null;
            String type = section.getString("type", "");
            shopkeeper = type.equals("book") ? new WrittenBookPlayerShopkeeper(section) : (type.equals("buy") ? new BuyingPlayerShopkeeper(section) : (type.equals("trade") ? new TradingPlayerShopkeeper(section) : (type.equals("player") || section.contains("owner") ? new NormalPlayerShopkeeper(section) : new AdminShopkeeper(section))));
            if (shopkeeper == null) continue;
            if (Settings.playerShopkeeperInactiveDays > 0 && shopkeeper instanceof PlayerShopkeeper && (lastPlayed = (offlinePlayer = Bukkit.getOfflinePlayer((String)(owner = ((PlayerShopkeeper)shopkeeper).getOwner()))).getLastPlayed()) > 0L && (System.currentTimeMillis() - lastPlayed) / 86400000L > (long)Settings.playerShopkeeperInactiveDays) {
                this.getLogger().info("Shopkeeper owned by " + owner + " at " + shopkeeper.getPositionString() + " has been removed for owner inactivity");
                continue;
            }
            List<Shopkeeper> list = this.allShopkeepersByChunk.get(shopkeeper.getChunk());
            if (list == null) {
                list = new ArrayList<Shopkeeper>();
                this.allShopkeepersByChunk.put(shopkeeper.getChunk(), list);
            }
            list.add(shopkeeper);
            if (shopkeeper.needsSpawned()) continue;
            this.activeShopkeepers.put(shopkeeper.getId(), shopkeeper);
        }
    }

    void save() {
        if (Settings.saveInstantly) {
            this.saveReal();
        } else {
            this.dirty = true;
        }
    }

    private void saveReal() {
        YamlConfiguration config = new YamlConfiguration();
        int counter = 0;
        for (List<Shopkeeper> shopkeepers : this.allShopkeepersByChunk.values()) {
            for (Shopkeeper shopkeeper : shopkeepers) {
                ConfigurationSection section = config.createSection(String.valueOf(counter));
                shopkeeper.save(section);
                ++counter;
            }
        }
        File file = new File(this.getDataFolder(), "save.yml");
        if (file.exists()) {
            file.delete();
        }
        try {
            if (Settings.fileEncoding != null && !Settings.fileEncoding.isEmpty()) {
                PrintWriter writer = new PrintWriter(file, Settings.fileEncoding);
                writer.write(config.saveToString());
                writer.close();
            } else {
                config.save(file);
            }
            ShopkeepersPlugin.debug("Saved shopkeeper data");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static VolatileCodeHandle getVolatileCode() {
        return volatileCodeHandle;
    }

    public static ShopkeepersPlugin getInstance() {
        return plugin;
    }

    public static void debug(String message) {
        if (ShopkeepersPlugin.plugin.debug) {
            plugin.getLogger().info(message);
        }
    }

    public static void warning(String message) {
        plugin.getLogger().warning(message);
    }
}

