/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers;

import com.nisovin.shopkeepers.Shopkeeper;
import com.nisovin.shopkeepers.ShopkeepersPlugin;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class WitchListener
implements Listener {
    final ShopkeepersPlugin plugin;

    public WitchListener(ShopkeepersPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    void onEntityInteract(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Witch) {
            LivingEntity entity = (LivingEntity)event.getRightClicked();
            ShopkeepersPlugin.debug("Player " + event.getPlayer().getName() + " is interacting with witch at " + entity.getLocation());
            Shopkeeper shopkeeper = this.plugin.activeShopkeepers.get("entity" + entity.getEntityId());
            if (event.isCancelled()) {
                ShopkeepersPlugin.debug("  Cancelled by another plugin");
            } else if (shopkeeper != null) {
                this.plugin.handleShopkeeperInteraction(event.getPlayer(), shopkeeper);
                event.setCancelled(true);
            } else {
                ShopkeepersPlugin.debug("  Non-shopkeeper");
            }
        }
    }
}

