/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.shopobjects;

import com.nisovin.shopkeepers.ShopkeepersPlugin;
import com.nisovin.shopkeepers.shopobjects.LivingEntityShop;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;

public class VillagerShop
extends LivingEntityShop {
    private Villager villager;
    private int profession;

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        this.profession = config.getInt("prof");
    }

    @Override
    public void save(ConfigurationSection config) {
        super.save(config);
        config.set("prof", (Object)this.profession);
        config.set("object", (Object)"villager");
    }

    @Override
    protected EntityType getEntityType() {
        return EntityType.VILLAGER;
    }

    @Override
    public boolean spawn(String world, int x, int y, int z) {
        boolean spawned = super.spawn(world, x, y, z);
        if (spawned && this.entity != null && this.entity.isValid()) {
            this.villager = (Villager)this.entity;
            ShopkeepersPlugin.getVolatileCode().setVillagerProfession(this.villager, this.profession);
            this.villager.setBreed(false);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getTypeItem() {
        return new ItemStack(Material.WOOL, 1, this.getProfessionWoolColor());
    }

    @Override
    public void cycleType() {
        ++this.profession;
        if (this.profession > 5) {
            this.profession = 0;
        }
        ShopkeepersPlugin.getVolatileCode().setVillagerProfession(this.villager, this.profession);
    }

    private short getProfessionWoolColor() {
        switch (this.profession) {
            case 0: {
                return 12;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 5;
            }
        }
        return 14;
    }

    @Override
    protected void overwriteAI() {
        ShopkeepersPlugin.getVolatileCode().overwriteVillagerAI(this.entity);
    }
}

