/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.shoptypes;

import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.Shopkeeper;
import com.nisovin.shopkeepers.ShopkeeperType;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class AdminShopkeeper
extends Shopkeeper {
    protected List<ItemStack[]> recipes;

    public AdminShopkeeper(ConfigurationSection config) {
        super(config);
    }

    public AdminShopkeeper(Location location, ShopObject shopObject) {
        super(location, shopObject);
        this.recipes = new ArrayList<ItemStack[]>();
    }

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        this.recipes = new ArrayList<ItemStack[]>();
        ConfigurationSection recipesSection = config.getConfigurationSection("recipes");
        if (recipesSection != null) {
            for (String key : recipesSection.getKeys(false)) {
                ConfigurationSection recipeSection = recipesSection.getConfigurationSection(key);
                ItemStack[] recipe = new ItemStack[3];
                int i = 0;
                while (i < 3) {
                    if (recipeSection.contains(String.valueOf(i))) {
                        recipe[i] = this.loadItemStack(recipeSection.getConfigurationSection(String.valueOf(i)));
                    }
                    ++i;
                }
                this.recipes.add(recipe);
            }
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        super.save(config);
        config.set("type", (Object)"admin");
        ConfigurationSection recipesSection = config.createSection("recipes");
        int count = 0;
        for (ItemStack[] recipe : this.recipes) {
            ConfigurationSection recipeSection = recipesSection.createSection(String.valueOf(count));
            int i = 0;
            while (i < 3) {
                if (recipe[i] != null) {
                    this.saveItemStack(recipe[i], recipeSection.createSection(String.valueOf(i)));
                }
                ++i;
            }
            ++count;
        }
    }

    @Override
    public ShopkeeperType getType() {
        return ShopkeeperType.ADMIN;
    }

    @Override
    public boolean onEdit(Player player) {
        if (player.hasPermission("shopkeeper.admin")) {
            Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)Settings.editorTitle);
            List<ItemStack[]> recipes = this.getRecipes();
            int i = 0;
            while (i < recipes.size() && i < 8) {
                ItemStack[] recipe = recipes.get(i);
                inv.setItem(i, recipe[0]);
                inv.setItem(i + 9, recipe[1]);
                inv.setItem(i + 18, recipe[2]);
                ++i;
            }
            this.setActionButtons(inv);
            player.openInventory(inv);
            return true;
        }
        return false;
    }

    @Override
    public void onEditorClose(InventoryCloseEvent event) {
        Inventory inv = event.getInventory();
        this.saveEditor(inv, (Player)event.getPlayer());
    }

    @Override
    protected void saveEditor(Inventory inv, Player player) {
        ArrayList<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
        int i = 0;
        while (i < 8) {
            ItemStack cost1 = inv.getItem(i);
            ItemStack cost2 = inv.getItem(i + 9);
            ItemStack result = inv.getItem(i + 18);
            if (cost1 != null && result != null) {
                ItemStack[] recipe = new ItemStack[]{cost1, cost2, result};
                recipes.add(recipe);
            } else if (player != null) {
                if (cost1 != null) {
                    player.getInventory().addItem(new ItemStack[]{cost1});
                }
                if (cost2 != null) {
                    player.getInventory().addItem(new ItemStack[]{cost2});
                }
                if (result != null) {
                    player.getInventory().addItem(new ItemStack[]{result});
                }
            }
            ++i;
        }
        this.setRecipes(recipes);
    }

    @Override
    public void onPurchaseClick(InventoryClickEvent event) {
        if (event.getCurrentItem().getType() == Material.MAP && event.getCurrentItem().getDurability() > 0) {
            short mapId = event.getCurrentItem().getDurability();
            event.setCursor(event.getCurrentItem());
            event.setCurrentItem(null);
            for (ItemStack[] recipe : this.getRecipes()) {
                ItemStack cost;
                if (recipe[2].getType() != Material.MAP || recipe[2].getDurability() != mapId) continue;
                if (recipe[0] != null) {
                    cost = event.getInventory().getItem(0);
                    cost.setAmount(cost.getAmount() - recipe[0].getAmount());
                    if (cost.getAmount() > 0) {
                        event.getInventory().setItem(0, cost);
                    } else {
                        event.getInventory().setItem(0, null);
                    }
                }
                if (recipe[1] == null) continue;
                cost = event.getInventory().getItem(1);
                cost.setAmount(cost.getAmount() - recipe[1].getAmount());
                if (cost.getAmount() > 0) {
                    event.getInventory().setItem(1, cost);
                    continue;
                }
                event.getInventory().setItem(1, null);
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @Override
    public List<ItemStack[]> getRecipes() {
        return this.recipes;
    }

    private void setRecipes(List<ItemStack[]> recipes) {
        this.recipes = recipes;
    }

    private ItemStack loadItemStack(ConfigurationSection config) {
        ItemMeta meta;
        if (config.contains("item")) {
            return config.getItemStack("item");
        }
        ItemStack item = new ItemStack(config.getInt("id"), config.getInt("amt"), (short)config.getInt("data"));
        if (config.contains("name") || config.contains("lore") || config.contains("color")) {
            meta = item.getItemMeta();
            if (config.contains("name")) {
                meta.setDisplayName(config.getString("name"));
            }
            if (config.contains("lore")) {
                List lore = config.getStringList("lore");
                meta.setLore(lore);
            }
            if (config.contains("color") && meta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)meta).setColor(Color.fromRGB((int)config.getInt("color")));
            }
            item.setItemMeta(meta);
        }
        if (config.contains("enchants")) {
            List list = config.getStringList("enchants");
            for (String s : list) {
                String[] enchantData = s.split(" ");
                item.addUnsafeEnchantment(Enchantment.getById((int)Integer.parseInt(enchantData[0])), Integer.parseInt(enchantData[1]));
            }
        }
        if (item.getType() == Material.WRITTEN_BOOK && config.contains("title") && config.contains("author") && config.contains("pages")) {
            meta = (BookMeta)item.getItemMeta();
            meta.setTitle(config.getString("title"));
            meta.setAuthor(config.getString("author"));
            meta.setPages(config.getStringList("pages"));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void saveItemStack(ItemStack item, ConfigurationSection config) {
        config.set("item", (Object)item);
    }
}

