/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.shoptypes;

import com.nisovin.shopkeepers.EditorClickResult;
import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.ShopkeeperType;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import com.nisovin.shopkeepers.shoptypes.PlayerShopkeeper;
import com.nisovin.shopkeepers.util.ItemType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class NormalPlayerShopkeeper
extends PlayerShopkeeper {
    private Map<ItemStack, Cost> costs;

    public NormalPlayerShopkeeper(ConfigurationSection config) {
        super(config);
    }

    public NormalPlayerShopkeeper(Player owner, Block chest, Location location, ShopObject shopObject) {
        super(owner, chest, location, shopObject);
        this.costs = new HashMap<ItemStack, Cost>();
    }

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        this.costs = new HashMap<ItemStack, Cost>();
        ConfigurationSection costsSection = config.getConfigurationSection("costs");
        if (costsSection != null) {
            for (String key : costsSection.getKeys(false)) {
                ItemStack item;
                ConfigurationSection itemSection = costsSection.getConfigurationSection(key);
                if (itemSection.contains("item")) {
                    item = itemSection.getItemStack("item");
                } else {
                    ItemType type = new ItemType();
                    type.id = itemSection.getInt("id");
                    type.data = (short)itemSection.getInt("data");
                    if (itemSection.contains("enchants")) {
                        type.enchants = itemSection.getString("enchants");
                    }
                    item = type.getItemStack(1);
                }
                Cost cost = new Cost(itemSection.getInt("amount"), itemSection.getInt("cost"));
                this.costs.put(item, cost);
            }
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        super.save(config);
        ConfigurationSection costsSection = config.createSection("costs");
        int count = 0;
        for (ItemStack item : this.costs.keySet()) {
            Cost cost = this.costs.get(item);
            ConfigurationSection itemSection = costsSection.createSection(String.valueOf(count));
            itemSection.set("item", (Object)item);
            itemSection.set("amount", (Object)cost.amount);
            itemSection.set("cost", (Object)cost.cost);
            ++count;
        }
    }

    @Override
    public ShopkeeperType getType() {
        return ShopkeeperType.PLAYER_NORMAL;
    }

    @Override
    public List<ItemStack[]> getRecipes() {
        ArrayList<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
        Map<ItemStack, Integer> chestItems = this.getItemsFromChest();
        for (ItemStack item : this.costs.keySet()) {
            if (!chestItems.containsKey(item)) continue;
            Cost cost = this.costs.get(item);
            int chestAmt = chestItems.get(item);
            if (chestAmt < cost.amount) continue;
            ItemStack[] recipe = new ItemStack[3];
            this.setRecipeCost(recipe, cost.cost);
            recipe[2] = item.clone();
            recipe[2].setAmount(cost.amount);
            recipes.add(recipe);
        }
        return recipes;
    }

    public Map<ItemStack, Cost> getCosts() {
        return this.costs;
    }

    @Override
    public boolean onPlayerEdit(Player player) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)Settings.editorTitle);
        Map<ItemStack, Integer> typesFromChest = this.getItemsFromChest();
        int i = 0;
        for (ItemStack item : typesFromChest.keySet()) {
            Cost cost = this.costs.get(item);
            if (cost != null) {
                ItemStack saleItem = item.clone();
                saleItem.setAmount(cost.amount);
                inv.setItem(i, saleItem);
                this.setEditColumnCost(inv, i, cost.cost);
            } else {
                inv.setItem(i, item);
                this.setEditColumnCost(inv, i, 0);
            }
            if (++i > 8) break;
        }
        this.setActionButtons(inv);
        player.openInventory(inv);
        return true;
    }

    @Override
    public EditorClickResult onEditorClick(InventoryClickEvent event) {
        event.setCancelled(true);
        if (event.getRawSlot() >= 0 && event.getRawSlot() <= 7) {
            ItemStack item = event.getCurrentItem();
            if (item != null && item.getTypeId() != 0) {
                int amt = item.getAmount();
                if (event.isLeftClick()) {
                    amt = event.isShiftClick() ? (amt += 10) : ++amt;
                } else if (event.isRightClick()) {
                    amt = event.isShiftClick() ? (amt -= 10) : --amt;
                }
                if (amt <= 0) {
                    amt = 1;
                }
                if (amt > item.getMaxStackSize()) {
                    amt = item.getMaxStackSize();
                }
                item.setAmount(amt);
            }
            return EditorClickResult.NOTHING;
        }
        return super.onEditorClick(event);
    }

    @Override
    protected void saveEditor(Inventory inv, Player player) {
        int i = 0;
        while (i < 8) {
            ItemStack item = inv.getItem(i);
            if (item != null && item.getType() != Material.AIR) {
                ItemStack saleItem;
                int cost = this.getCostFromColumn(inv, i);
                if (cost > 0) {
                    saleItem = item.clone();
                    saleItem.setAmount(1);
                    this.costs.put(saleItem, new Cost(item.getAmount(), cost));
                } else {
                    saleItem = item.clone();
                    saleItem.setAmount(1);
                    this.costs.remove(saleItem);
                }
            }
            ++i;
        }
    }

    @Override
    public void onPlayerPurchaseClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        ItemStack type = item.clone();
        type.setAmount(1);
        if (!this.costs.containsKey(type)) {
            event.setCancelled(true);
            return;
        }
        Cost cost = this.costs.get(type);
        if (cost.amount != item.getAmount()) {
            event.setCancelled(true);
            return;
        }
        Block chest = Bukkit.getWorld((String)this.world).getBlockAt(this.chestx, this.chesty, this.chestz);
        if (chest.getType() != Material.CHEST) {
            event.setCancelled(true);
            return;
        }
        Inventory inv = ((Chest)chest.getState()).getInventory();
        ItemStack[] contents = inv.getContents();
        boolean removed = this.removeFromInventory(item, contents);
        if (!removed) {
            event.setCancelled(true);
            return;
        }
        if (Settings.highCurrencyItem <= 0 || cost.cost <= Settings.highCurrencyMinCost) {
            boolean added = this.addToInventory(new ItemStack(Settings.currencyItem, cost.cost, Settings.currencyItemData), contents);
            if (!added) {
                event.setCancelled(true);
                return;
            }
        } else {
            int highCost = cost.cost / Settings.highCurrencyValue;
            int lowCost = cost.cost % Settings.highCurrencyValue;
            boolean added = false;
            if (highCost > 0 && !(added = this.addToInventory(new ItemStack(Settings.highCurrencyItem, highCost, Settings.highCurrencyItemData), contents))) {
                event.setCancelled(true);
                return;
            }
            if (lowCost > 0 && !(added = this.addToInventory(new ItemStack(Settings.currencyItem, lowCost, Settings.currencyItemData), contents))) {
                event.setCancelled(true);
                return;
            }
        }
        inv.setContents(contents);
    }

    private Map<ItemStack, Integer> getItemsFromChest() {
        LinkedHashMap<ItemStack, Integer> map = new LinkedHashMap<ItemStack, Integer>();
        Block chest = Bukkit.getWorld((String)this.world).getBlockAt(this.chestx, this.chesty, this.chestz);
        if (chest.getType() == Material.CHEST) {
            ItemStack[] contents;
            Inventory inv = ((Chest)chest.getState()).getInventory();
            ItemStack[] itemStackArray = contents = inv.getContents();
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack item = itemStackArray[n2];
                if (item != null && item.getType() != Material.AIR && item.getTypeId() != Settings.currencyItem && item.getTypeId() != Settings.highCurrencyItem) {
                    ItemStack i = item.clone();
                    i.setAmount(1);
                    if (map.containsKey(i)) {
                        map.put(i, (Integer)map.get(i) + item.getAmount());
                    } else {
                        map.put(i, item.getAmount());
                    }
                }
                ++n2;
            }
        }
        return map;
    }

    public class Cost {
        int amount;
        int cost;

        public Cost(int amount, int cost) {
            this.amount = amount;
            this.cost = cost;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public int getCost() {
            return this.cost;
        }

        public void setCost(int cost) {
            this.cost = cost;
        }
    }
}

