/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.shoptypes;

import com.nisovin.shopkeepers.EditorClickResult;
import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.Shopkeeper;
import com.nisovin.shopkeepers.ShopkeepersPlugin;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class PlayerShopkeeper
extends Shopkeeper {
    protected String owner;
    protected int chestx;
    protected int chesty;
    protected int chestz;

    public PlayerShopkeeper(ConfigurationSection config) {
        super(config);
    }

    public PlayerShopkeeper(Player owner, Block chest, Location location, ShopObject shopObject) {
        super(location, shopObject);
        this.owner = owner.getName().toLowerCase();
        this.chestx = chest.getX();
        this.chesty = chest.getY();
        this.chestz = chest.getZ();
    }

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        this.owner = config.getString("owner");
        this.chestx = config.getInt("chestx");
        this.chesty = config.getInt("chesty");
        this.chestz = config.getInt("chestz");
    }

    @Override
    public void save(ConfigurationSection config) {
        super.save(config);
        config.set("type", (Object)"player");
        config.set("owner", (Object)this.owner);
        config.set("chestx", (Object)this.chestx);
        config.set("chesty", (Object)this.chesty);
        config.set("chestz", (Object)this.chestz);
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean usesChest(Block chest) {
        if (!chest.getWorld().getName().equals(this.world)) {
            return false;
        }
        int x = chest.getX();
        int y = chest.getY();
        int z = chest.getZ();
        if (x == this.chestx && y == this.chesty && z == this.chestz) {
            return true;
        }
        if (x == this.chestx + 1 && y == this.chesty && z == this.chestz) {
            return true;
        }
        if (x == this.chestx - 1 && y == this.chesty && z == this.chestz) {
            return true;
        }
        if (x == this.chestx && y == this.chesty && z == this.chestz + 1) {
            return true;
        }
        return x == this.chestx && y == this.chesty && z == this.chestz - 1;
    }

    @Override
    public boolean onEdit(Player player) {
        if (player.getName().equalsIgnoreCase(this.owner) && player.hasPermission("shopkeeper." + this.getType().getPermission()) || player.hasPermission("shopkeeper.bypass")) {
            return this.onPlayerEdit(player);
        }
        return false;
    }

    protected abstract boolean onPlayerEdit(Player var1);

    @Override
    public EditorClickResult onEditorClick(InventoryClickEvent event) {
        if (event.getRawSlot() > 27 && event.isShiftClick()) {
            event.setCancelled(true);
            return EditorClickResult.NOTHING;
        }
        if (event.getRawSlot() >= 18 && event.getRawSlot() <= 25) {
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem();
            if (item != null) {
                if (item.getTypeId() == Settings.currencyItem) {
                    int amount = item.getAmount();
                    if (event.isShiftClick() && event.isLeftClick()) {
                        amount += 10;
                    } else if (event.isShiftClick() && event.isRightClick()) {
                        amount -= 10;
                    } else if (event.isLeftClick()) {
                        ++amount;
                    } else if (event.isRightClick()) {
                        --amount;
                    }
                    if (amount > 64) {
                        amount = 64;
                    }
                    if (amount <= 0) {
                        item.setTypeId(Settings.zeroItem);
                        item.setDurability((short)0);
                        item.setAmount(1);
                    } else {
                        item.setAmount(amount);
                    }
                } else if (item.getTypeId() == Settings.zeroItem) {
                    item.setTypeId(Settings.currencyItem);
                    item.setDurability(Settings.currencyItemData);
                    item.setAmount(1);
                }
            }
            return EditorClickResult.NOTHING;
        }
        if (event.getRawSlot() >= 9 && event.getRawSlot() <= 16) {
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem();
            if (item != null && Settings.highCurrencyItem > 0) {
                if (item.getTypeId() == Settings.highCurrencyItem) {
                    int amount = item.getAmount();
                    if (event.isShiftClick() && event.isLeftClick()) {
                        amount += 10;
                    } else if (event.isShiftClick() && event.isRightClick()) {
                        amount -= 10;
                    } else if (event.isLeftClick()) {
                        ++amount;
                    } else if (event.isRightClick()) {
                        --amount;
                    }
                    if (amount > 64) {
                        amount = 64;
                    }
                    if (amount <= 0) {
                        item.setTypeId(Settings.highZeroItem);
                        item.setDurability((short)0);
                        item.setAmount(1);
                    } else {
                        item.setAmount(amount);
                    }
                } else if (item.getTypeId() == Settings.highZeroItem) {
                    item.setTypeId(Settings.highCurrencyItem);
                    item.setDurability(Settings.highCurrencyItemData);
                    item.setAmount(1);
                }
            }
            return EditorClickResult.NOTHING;
        }
        return super.onEditorClick(event);
    }

    @Override
    public void onEditorClose(InventoryCloseEvent event) {
        this.saveEditor(event.getInventory(), null);
    }

    @Override
    public final void onPurchaseClick(InventoryClickEvent event) {
        if (event.getWhoClicked().getName().equalsIgnoreCase(this.owner) && !event.getWhoClicked().isOp()) {
            event.setCancelled(true);
            ShopkeepersPlugin.debug("Cancelled trade from " + event.getWhoClicked().getName() + " because he can't trade with his own shop");
        } else {
            if (event.isRightClick() || event.isShiftClick()) {
                event.setCancelled(true);
                return;
            }
            this.onPlayerPurchaseClick(event);
        }
    }

    protected abstract void onPlayerPurchaseClick(InventoryClickEvent var1);

    protected void setRecipeCost(ItemStack[] recipe, int cost) {
        if (Settings.highCurrencyItem > 0 && cost > Settings.highCurrencyMinCost) {
            int highCost = cost / Settings.highCurrencyValue;
            int lowCost = cost % Settings.highCurrencyValue;
            if (highCost > 0) {
                recipe[0] = new ItemStack(Settings.highCurrencyItem, highCost, Settings.highCurrencyItemData);
                if (highCost > recipe[0].getMaxStackSize()) {
                    lowCost += (highCost - recipe[0].getMaxStackSize()) * Settings.highCurrencyValue;
                    recipe[0].setAmount(recipe[0].getMaxStackSize());
                }
            }
            if (lowCost > 0) {
                recipe[1] = new ItemStack(Settings.currencyItem, lowCost, Settings.currencyItemData);
                if (lowCost > recipe[1].getMaxStackSize()) {
                    ShopkeepersPlugin.warning("Shopkeeper at " + this.world + "," + this.x + "," + this.y + "," + this.z + " owned by " + this.owner + " has an invalid cost!");
                }
            }
        } else {
            recipe[0] = new ItemStack(Settings.currencyItem, cost, Settings.currencyItemData);
        }
    }

    protected void setEditColumnCost(Inventory inv, int column, int cost) {
        if (cost > 0) {
            if (Settings.highCurrencyItem > 0 && cost > Settings.highCurrencyMinCost) {
                int highCost = cost / Settings.highCurrencyValue;
                int lowCost = cost % Settings.highCurrencyValue;
                if (highCost > 0) {
                    ItemStack item = new ItemStack(Settings.highCurrencyItem, highCost, Settings.highCurrencyItemData);
                    if (highCost > item.getMaxStackSize()) {
                        lowCost += (highCost - item.getMaxStackSize()) * Settings.highCurrencyValue;
                        item.setAmount(item.getMaxStackSize());
                    }
                    inv.setItem(column + 9, item);
                } else {
                    inv.setItem(column + 9, new ItemStack(Settings.highZeroItem));
                }
                if (lowCost > 0) {
                    inv.setItem(column + 18, new ItemStack(Settings.currencyItem, lowCost, Settings.currencyItemData));
                } else {
                    inv.setItem(column + 18, new ItemStack(Settings.zeroItem));
                }
            } else {
                inv.setItem(column + 18, new ItemStack(Settings.currencyItem, cost, Settings.currencyItemData));
                if (Settings.highCurrencyItem > 0) {
                    inv.setItem(column + 9, new ItemStack(Settings.highZeroItem));
                }
            }
        } else {
            inv.setItem(column + 18, new ItemStack(Settings.zeroItem));
            if (Settings.highCurrencyItem > 0) {
                inv.setItem(column + 9, new ItemStack(Settings.highZeroItem));
            }
        }
    }

    protected int getCostFromColumn(Inventory inv, int column) {
        ItemStack lowCostItem = inv.getItem(column + 18);
        ItemStack highCostItem = inv.getItem(column + 9);
        int cost = 0;
        if (lowCostItem != null && lowCostItem.getTypeId() == Settings.currencyItem && lowCostItem.getAmount() > 0) {
            cost += lowCostItem.getAmount();
        }
        if (Settings.highCurrencyItem > 0 && highCostItem != null && highCostItem.getTypeId() == Settings.highCurrencyItem && highCostItem.getAmount() > 0) {
            cost += highCostItem.getAmount() * Settings.highCurrencyValue;
        }
        return cost;
    }

    protected boolean removeFromInventory(ItemStack item, ItemStack[] contents) {
        item = item.clone();
        int i = 0;
        while (i < contents.length) {
            if (contents[i] != null && item.isSimilar(contents[i])) {
                if (contents[i].getAmount() > item.getAmount()) {
                    contents[i].setAmount(contents[i].getAmount() - item.getAmount());
                    return true;
                }
                if (contents[i].getAmount() == item.getAmount()) {
                    contents[i] = null;
                    return true;
                }
                item.setAmount(item.getAmount() - contents[i].getAmount());
                contents[i] = null;
            }
            ++i;
        }
        return false;
    }

    protected boolean addToInventory(ItemStack item, ItemStack[] contents) {
        item = item.clone();
        int i = 0;
        while (i < contents.length) {
            if (contents[i] == null) {
                contents[i] = item;
                return true;
            }
            if (item.isSimilar(contents[i]) && contents[i].getAmount() != contents[i].getMaxStackSize()) {
                int amt = contents[i].getAmount() + item.getAmount();
                if (amt <= contents[i].getMaxStackSize()) {
                    contents[i].setAmount(amt);
                    return true;
                }
                item.setAmount(amt - contents[i].getMaxStackSize());
                contents[i].setAmount(contents[i].getMaxStackSize());
            }
            ++i;
        }
        return false;
    }
}

