/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.shoptypes;

import com.nisovin.shopkeepers.EditorClickResult;
import com.nisovin.shopkeepers.Settings;
import com.nisovin.shopkeepers.ShopkeeperType;
import com.nisovin.shopkeepers.shopobjects.ShopObject;
import com.nisovin.shopkeepers.shoptypes.PlayerShopkeeper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

public class WrittenBookPlayerShopkeeper
extends PlayerShopkeeper {
    private Map<String, Integer> costs;

    public WrittenBookPlayerShopkeeper(ConfigurationSection config) {
        super(config);
    }

    public WrittenBookPlayerShopkeeper(Player owner, Block chest, Location location, ShopObject shopObject) {
        super(owner, chest, location, shopObject);
        this.costs = new HashMap<String, Integer>();
    }

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        this.costs = new HashMap<String, Integer>();
        ConfigurationSection costsSection = config.getConfigurationSection("costs");
        if (costsSection != null) {
            for (String key : costsSection.getKeys(false)) {
                this.costs.put(key, costsSection.getInt(key));
            }
        }
    }

    @Override
    public void save(ConfigurationSection config) {
        super.save(config);
        config.set("type", (Object)"book");
        ConfigurationSection costsSection = config.createSection("costs");
        for (String title : this.costs.keySet()) {
            costsSection.set(title, (Object)this.costs.get(title));
        }
    }

    @Override
    public ShopkeeperType getType() {
        return ShopkeeperType.PLAYER_BOOK;
    }

    @Override
    public List<ItemStack[]> getRecipes() {
        ArrayList<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
        if (this.chestHasBlankBooks()) {
            List<ItemStack> books = this.getBooksFromChest();
            for (ItemStack book : books) {
                String title;
                if (book == null || (title = this.getTitleOfBook(book)) == null || !this.costs.containsKey(title)) continue;
                int cost = this.costs.get(title);
                ItemStack[] recipe = new ItemStack[3];
                this.setRecipeCost(recipe, cost);
                recipe[2] = book.clone();
                recipes.add(recipe);
            }
        }
        return recipes;
    }

    public Map<String, Integer> getCosts() {
        return this.costs;
    }

    @Override
    public boolean onPlayerEdit(Player player) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)Settings.editorTitle);
        List<ItemStack> books = this.getBooksFromChest();
        int i = 0;
        while (i < books.size() && i < 8) {
            String title = this.getTitleOfBook(books.get(i));
            if (title != null) {
                int cost = 0;
                if (this.costs.containsKey(title)) {
                    cost = this.costs.get(title);
                }
                inv.setItem(i, books.get(i));
                this.setEditColumnCost(inv, i, cost);
            }
            ++i;
        }
        this.setActionButtons(inv);
        player.openInventory(inv);
        return true;
    }

    @Override
    public EditorClickResult onEditorClick(InventoryClickEvent event) {
        event.setCancelled(true);
        return super.onEditorClick(event);
    }

    @Override
    protected void saveEditor(Inventory inv, Player player) {
        int i = 0;
        while (i < 8) {
            String title;
            ItemStack item = inv.getItem(i);
            if (item != null && item.getType() == Material.WRITTEN_BOOK && (title = this.getTitleOfBook(item)) != null) {
                int cost = this.getCostFromColumn(inv, i);
                if (cost > 0) {
                    this.costs.put(title, cost);
                } else {
                    this.costs.remove(title);
                }
            }
            ++i;
        }
    }

    @Override
    public void onPlayerPurchaseClick(InventoryClickEvent event) {
        ItemStack book = event.getCurrentItem();
        String title = this.getTitleOfBook(book);
        if (title == null) {
            event.setCancelled(true);
            return;
        }
        Block chest = Bukkit.getWorld((String)this.world).getBlockAt(this.chestx, this.chesty, this.chestz);
        if (chest.getType() != Material.CHEST) {
            event.setCancelled(true);
            return;
        }
        boolean removed = false;
        Inventory inv = ((Chest)chest.getState()).getInventory();
        ItemStack[] contents = inv.getContents();
        int i = 0;
        while (i < contents.length) {
            if (contents[i] != null && contents[i].getType() == Material.BOOK_AND_QUILL) {
                if (contents[i].getAmount() == 1) {
                    contents[i] = null;
                } else {
                    contents[i].setAmount(contents[i].getAmount() - 1);
                }
                removed = true;
                break;
            }
            ++i;
        }
        if (!removed) {
            event.setCancelled(true);
            return;
        }
        int cost = 0;
        if (!this.costs.containsKey(title)) {
            event.setCancelled(true);
            return;
        }
        cost = this.costs.get(title);
        int highCost = cost / Settings.highCurrencyValue;
        int lowCost = cost % Settings.highCurrencyValue;
        boolean added = false;
        if (highCost > 0 && !(added = this.addToInventory(new ItemStack(Settings.highCurrencyItem, highCost, Settings.highCurrencyItemData), contents))) {
            event.setCancelled(true);
            return;
        }
        if (lowCost > 0 && !(added = this.addToInventory(new ItemStack(Settings.currencyItem, lowCost, Settings.currencyItemData), contents))) {
            event.setCancelled(true);
            return;
        }
        inv.setContents(contents);
    }

    private List<ItemStack> getBooksFromChest() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Block chest = Bukkit.getWorld((String)this.world).getBlockAt(this.chestx, this.chesty, this.chestz);
        if (chest.getType() == Material.CHEST) {
            Inventory inv = ((Chest)chest.getState()).getInventory();
            ItemStack[] itemStackArray = inv.getContents();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack item = itemStackArray[n2];
                if (item != null && item.getType() == Material.WRITTEN_BOOK && this.isBookAuthoredByShopOwner(item)) {
                    list.add(item);
                }
                ++n2;
            }
        }
        return list;
    }

    private String getTitleOfBook(ItemStack book) {
        if (book.getType() == Material.WRITTEN_BOOK && book.hasItemMeta()) {
            BookMeta meta = (BookMeta)book.getItemMeta();
            return meta.getTitle();
        }
        return null;
    }

    private boolean isBookAuthoredByShopOwner(ItemStack book) {
        BookMeta meta;
        return book.getType() == Material.WRITTEN_BOOK && book.hasItemMeta() && (meta = (BookMeta)book.getItemMeta()).hasAuthor() && meta.getAuthor().equalsIgnoreCase(this.owner);
    }

    private boolean chestHasBlankBooks() {
        Block chest = Bukkit.getWorld((String)this.world).getBlockAt(this.chestx, this.chesty, this.chestz);
        if (chest.getType() == Material.CHEST) {
            Inventory inv = ((Chest)chest.getState()).getInventory();
            return inv.contains(Material.BOOK_AND_QUILL);
        }
        return false;
    }
}

