/*
 * Decompiled with CFR 0.152.
 */
package com.nisovin.shopkeepers.util;

import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ItemType {
    public int id;
    public short data;
    public String enchants;

    public ItemType() {
    }

    public ItemType(ItemStack item) {
        this.id = item.getTypeId();
        this.data = item.getDurability();
        Map enchantments = item.getEnchantments();
        if (enchantments != null && enchantments.size() > 0) {
            this.enchants = "";
            for (Enchantment e : enchantments.keySet()) {
                this.enchants = String.valueOf(this.enchants) + e.getId() + ":" + enchantments.get(e) + " ";
            }
            this.enchants = this.enchants.trim();
        }
    }

    public ItemStack getItemStack(int amount) {
        ItemStack item = new ItemStack(this.id, amount, this.data);
        if (this.enchants != null) {
            String[] dataList;
            String[] stringArray = dataList = this.enchants.split(" ");
            int n = dataList.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] data = s.split(":");
                item.addUnsafeEnchantment(Enchantment.getById((int)Integer.parseInt(data[0])), Integer.parseInt(data[1]));
                ++n2;
            }
        }
        return item;
    }

    public int hashCode() {
        return (String.valueOf(this.id) + " " + this.data + (this.enchants != null ? " " + this.enchants : "")).hashCode();
    }

    public boolean equals(Object o) {
        boolean test;
        if (!(o instanceof ItemType)) {
            return false;
        }
        ItemType i = (ItemType)o;
        boolean bl = test = i.id == this.id && i.data == this.data;
        if (!test) {
            return false;
        }
        if (i.enchants == null && this.enchants == null) {
            return true;
        }
        if (i.enchants == null || this.enchants == null) {
            return false;
        }
        return i.enchants.equals(this.enchants);
    }
}

